/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.async;

import com.google.inject.Inject;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.gitbub.devlibx.easy.helper.string.StringHelper;
import io.github.devlibx.easy.http.IRequestProcessor;
import io.github.devlibx.easy.http.RequestObject;
import io.github.devlibx.easy.http.ResponseObject;
import io.github.devlibx.easy.http.config.Api;
import io.github.devlibx.easy.http.config.Server;
import io.github.devlibx.easy.http.exception.EasyHttpExceptions;
import io.github.devlibx.easy.http.registry.ApiRegistry;
import io.github.devlibx.easy.http.registry.ServerRegistry;
import io.github.devlibx.easy.http.sync.IHttpResponseProcessor;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.client.WebClient;

public class AsyncRequestProcessor
implements IRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(AsyncRequestProcessor.class);
    private final ServerRegistry serverRegistry;
    private final ApiRegistry apiRegistry;
    private final StringHelper stringHelper;
    private final IHttpResponseProcessor httpResponseProcessor;
    private final IMetrics metrics;

    @Inject
    public AsyncRequestProcessor(ServerRegistry serverRegistry, ApiRegistry apiRegistry, IHttpResponseProcessor httpResponseProcessor, IMetrics metrics) {
        this.serverRegistry = serverRegistry;
        this.apiRegistry = apiRegistry;
        this.httpResponseProcessor = httpResponseProcessor;
        this.metrics = metrics;
        this.stringHelper = ApplicationContext.getOptionalInstance(StringHelper.class).orElse(new StringHelper());
    }

    @Override
    public Observable<ResponseObject> process(RequestObject requestObject) {
        return this.internalProcess(requestObject);
    }

    public Observable<ResponseObject> internalProcess(RequestObject requestObject) {
        Api api = this.apiRegistry.getOptional(requestObject.getApi()).orElseThrow(() -> new RuntimeException("Could not find api=" + requestObject.getApi()));
        Server server = this.serverRegistry.getOptional(api.getServer()).orElseThrow(() -> new RuntimeException("Could not find server=" + api.getServer()));
        return Observable.create(observableEmitter -> this.processRequest(server, api, requestObject, (ObservableEmitter<ResponseObject>)observableEmitter));
    }

    public void processRequest(Server server, Api api, RequestObject requestObject, ObservableEmitter<ResponseObject> observableEmitter) {
        WebClient webClient = this.apiRegistry.getClient(server, api, WebClient.class);
        long startTime = System.currentTimeMillis();
        switch (api.getMethod()) {
            case "GET": {
                webClient.get().uri(api.getUrlForRequestObject(requestObject, this.stringHelper), new Object[0]).headers(this.consumerHeaders(requestObject, api.getHeaders())).retrieve().bodyToMono(byte[].class).doOnError(this.onErrorConsumer(server, api, observableEmitter, startTime)).subscribe(this.consumer(server, api, observableEmitter, startTime));
                break;
            }
            case "DELETE": {
                webClient.delete().uri(api.getUrlForRequestObject(requestObject, this.stringHelper), new Object[0]).headers(this.consumerHeaders(requestObject, api.getHeaders())).retrieve().bodyToMono(byte[].class).doOnError(this.onErrorConsumer(server, api, observableEmitter, startTime)).subscribe(this.consumer(server, api, observableEmitter, startTime));
                break;
            }
            case "POST": {
                ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(api.getUrlForRequestObject(requestObject, this.stringHelper), new Object[0])).headers(this.consumerHeaders(requestObject, api.getHeaders()))).bodyValue((Object)requestObject.getBody()).retrieve().bodyToMono(byte[].class).doOnError(this.onErrorConsumer(server, api, observableEmitter, startTime)).subscribe(this.consumer(server, api, observableEmitter, startTime));
                break;
            }
            case "PUT": {
                System.out.println("Putting data " + new String(requestObject.getBody()));
                ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.put().uri(api.getUrlForRequestObject(requestObject, this.stringHelper), new Object[0])).headers(this.consumerHeaders(requestObject, api.getHeaders()))).bodyValue((Object)requestObject.getBody()).retrieve().bodyToMono(byte[].class).doOnError(this.onErrorConsumer(server, api, observableEmitter, startTime)).subscribe(this.consumer(server, api, observableEmitter, startTime));
                break;
            }
            default: {
                observableEmitter.onError((Throwable)new RuntimeException("Api has a invalid HTTP method: " + api.getMethod()));
            }
        }
    }

    private Consumer<byte[]> consumer(Server server, Api api, ObservableEmitter<ResponseObject> observableEmitter, long startTime) {
        return data -> {
            this.metrics.observe(server.getName() + "_" + api.getName() + "_http_client_time", (double)(System.currentTimeMillis() - startTime));
            ResponseObject responseObject = new ResponseObject();
            responseObject.setBody((byte[])data);
            responseObject.setStatusCode(200);
            observableEmitter.onNext((Object)responseObject);
            observableEmitter.onComplete();
        };
    }

    private Consumer<Throwable> onErrorConsumer(Server server, Api api, ObservableEmitter<ResponseObject> observableEmitter, long startTime) {
        return throwable -> {
            this.metrics.observe(server.getName() + "_" + api.getName() + "_http_client_error_time", (double)(System.currentTimeMillis() - startTime));
            log.trace("Got error for server={}, api={}", new Object[]{server, api, throwable});
            ResponseObject responseObject = this.httpResponseProcessor.processException(server, api, (Throwable)throwable);
            EasyHttpExceptions.EasyHttpRequestException exception = EasyHttpExceptions.convert(responseObject.getStatusCode(), throwable, responseObject);
            observableEmitter.onError((Throwable)exception);
        };
    }

    private Consumer<HttpHeaders> consumerHeaders(RequestObject requestObject, StringObjectMap apiHeaders) {
        return httpHeaders -> {
            requestObject.preProcessHeaders(apiHeaders);
            requestObject.getHeaders().forEach((key, value) -> httpHeaders.add(key, this.stringHelper.stringify(value)));
        };
    }

    @Override
    public void shutdown() {
    }
}

