/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.helper;

import io.github.devlibx.easy.http.IApiConfigPreProcessor;
import io.github.devlibx.easy.http.config.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyApiConfigPreProcessor
implements IApiConfigPreProcessor {
    private static final Logger log = LoggerFactory.getLogger(ConcurrencyApiConfigPreProcessor.class);

    @Override
    public void process(String name, Api api) {
        if (api.getRps() <= 0) {
            return;
        }
        int rps = api.getRps();
        int timeout = api.getTimeout();
        float throughputPerSec = 1000.0f / (float)timeout;
        float _concurrency = (float)rps / throughputPerSec;
        int concurrency = (int)Math.floor(_concurrency);
        api.setConcurrency(concurrency);
        log.debug("Updated concurrency - name={}, rps={}, timeout={}, throughputPerSec={} concurrency={}", new Object[]{name, rps, timeout, Float.valueOf(throughputPerSec), concurrency});
    }
}

