/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import java.util.Arrays;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ResponseObject {
    private byte[] body;
    private int statusCode;
    @JsonIgnore
    private boolean success;
    @JsonIgnore
    private Throwable exception;

    public Map<String, Object> convertAsMap() {
        if (this.body == null) {
            return null;
        }
        return JsonUtils.convertAsMap((String)new String(this.body));
    }

    public String getBodyAsString() {
        if (this.body == null) {
            return null;
        }
        return new String(this.body);
    }

    public static ResponseObjectBuilder builder() {
        return new ResponseObjectBuilder();
    }

    public byte[] getBody() {
        return this.body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @JsonIgnore
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @JsonIgnore
    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseObject)) {
            return false;
        }
        ResponseObject other = (ResponseObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getBody());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseObject(body=" + Arrays.toString(this.getBody()) + ", statusCode=" + this.getStatusCode() + ", success=" + this.isSuccess() + ", exception=" + this.getException() + ")";
    }

    public ResponseObject(byte[] body, int statusCode, boolean success, Throwable exception) {
        this.body = body;
        this.statusCode = statusCode;
        this.success = success;
        this.exception = exception;
    }

    public ResponseObject() {
    }

    public static class ResponseObjectBuilder {
        private byte[] body;
        private int statusCode;
        private boolean success;
        private Throwable exception;

        ResponseObjectBuilder() {
        }

        public ResponseObjectBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public ResponseObjectBuilder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @JsonIgnore
        public ResponseObjectBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        @JsonIgnore
        public ResponseObjectBuilder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public ResponseObject build() {
            return new ResponseObject(this.body, this.statusCode, this.success, this.exception);
        }

        public String toString() {
            return "ResponseObject.ResponseObjectBuilder(body=" + Arrays.toString(this.body) + ", statusCode=" + this.statusCode + ", success=" + this.success + ", exception=" + this.exception + ")";
        }
    }
}

