/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import io.vavr.Function0;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Call<R> {
    private String server;
    private String api;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Map<String, Object> pathParams;
    private MultivaluedMap<String, Object> queryParam;
    private Object body;
    private Class<R> responseClass;
    private IResponseBuilderFunc<R> responseBuilder;
    private Function0<byte[]> requestBodyFunc;

    private Call() {
    }

    public byte[] getBodyAsByteArray() {
        return (byte[])this.requestBodyFunc.apply();
    }

    public static <R> Builder<R> builder(Class<R> responseClass) {
        return new Builder<R>(responseClass);
    }

    public String getServer() {
        return this.server;
    }

    public String getApi() {
        return this.api;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getPathParams() {
        return this.pathParams;
    }

    public MultivaluedMap<String, Object> getQueryParam() {
        return this.queryParam;
    }

    public Object getBody() {
        return this.body;
    }

    public Class<R> getResponseClass() {
        return this.responseClass;
    }

    public IResponseBuilderFunc<R> getResponseBuilder() {
        return this.responseBuilder;
    }

    public Function0<byte[]> getRequestBodyFunc() {
        return this.requestBodyFunc;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setPathParams(Map<String, Object> pathParams) {
        this.pathParams = pathParams;
    }

    public void setQueryParam(MultivaluedMap<String, Object> queryParam) {
        this.queryParam = queryParam;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setResponseClass(Class<R> responseClass) {
        this.responseClass = responseClass;
    }

    public void setResponseBuilder(IResponseBuilderFunc<R> responseBuilder) {
        this.responseBuilder = responseBuilder;
    }

    public void setRequestBodyFunc(Function0<byte[]> requestBodyFunc) {
        this.requestBodyFunc = requestBodyFunc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Call)) {
            return false;
        }
        Call other = (Call)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        Map<String, Object> this$headers = this.getHeaders();
        Map<String, Object> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Object> this$pathParams = this.getPathParams();
        Map<String, Object> other$pathParams = other.getPathParams();
        if (this$pathParams == null ? other$pathParams != null : !((Object)this$pathParams).equals(other$pathParams)) {
            return false;
        }
        MultivaluedMap<String, Object> this$queryParam = this.getQueryParam();
        MultivaluedMap<String, Object> other$queryParam = other.getQueryParam();
        if (this$queryParam == null ? other$queryParam != null : !this$queryParam.equals(other$queryParam)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Class<R> this$responseClass = this.getResponseClass();
        Class<R> other$responseClass = other.getResponseClass();
        if (this$responseClass == null ? other$responseClass != null : !this$responseClass.equals(other$responseClass)) {
            return false;
        }
        IResponseBuilderFunc<R> this$responseBuilder = this.getResponseBuilder();
        IResponseBuilderFunc<R> other$responseBuilder = other.getResponseBuilder();
        if (this$responseBuilder == null ? other$responseBuilder != null : !this$responseBuilder.equals(other$responseBuilder)) {
            return false;
        }
        Function0<byte[]> this$requestBodyFunc = this.getRequestBodyFunc();
        Function0<byte[]> other$requestBodyFunc = other.getRequestBodyFunc();
        return !(this$requestBodyFunc == null ? other$requestBodyFunc != null : !this$requestBodyFunc.equals(other$requestBodyFunc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Call;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        Map<String, Object> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Object> $pathParams = this.getPathParams();
        result = result * 59 + ($pathParams == null ? 43 : ((Object)$pathParams).hashCode());
        MultivaluedMap<String, Object> $queryParam = this.getQueryParam();
        result = result * 59 + ($queryParam == null ? 43 : $queryParam.hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Class<R> $responseClass = this.getResponseClass();
        result = result * 59 + ($responseClass == null ? 43 : $responseClass.hashCode());
        IResponseBuilderFunc<R> $responseBuilder = this.getResponseBuilder();
        result = result * 59 + ($responseBuilder == null ? 43 : $responseBuilder.hashCode());
        Function0<byte[]> $requestBodyFunc = this.getRequestBodyFunc();
        result = result * 59 + ($requestBodyFunc == null ? 43 : $requestBodyFunc.hashCode());
        return result;
    }

    public String toString() {
        return "Call(server=" + this.getServer() + ", api=" + this.getApi() + ", headers=" + this.getHeaders() + ", pathParams=" + this.getPathParams() + ", queryParam=" + this.getQueryParam() + ", body=" + this.getBody() + ", responseClass=" + this.getResponseClass() + ", responseBuilder=" + this.getResponseBuilder() + ", requestBodyFunc=" + this.getRequestBodyFunc() + ")";
    }

    public static class Builder<R> {
        private String server;
        private String api;
        private Map<String, Object> headers;
        private Map<String, Object> pathParams;
        private MultivaluedMap<String, Object> queryParam;
        private Object body;
        private final Class<R> responseClass;
        private IResponseBuilderFunc<R> responseBuilder;
        private Function0<byte[]> requestBodyFunc;

        public Builder(Class<R> responseClass) {
            this.responseClass = responseClass;
            this.responseBuilder = bytes -> {
                if (bytes != null) {
                    String str = new String(bytes);
                    return JsonUtils.readObject((String)str, (Class)responseClass);
                }
                return null;
            };
            this.requestBodyFunc = (Function0 & Serializable)() -> {
                if (this.body == null) {
                    return null;
                }
                if (this.body instanceof byte[]) {
                    return (byte[])this.body;
                }
                String _body = JsonUtils.asJson((Object)this.body);
                if (_body != null) {
                    return _body.getBytes();
                }
                return null;
            };
        }

        public Builder<R> withResponseBuilder(IResponseBuilderFunc<R> responseBuilder) {
            this.responseBuilder = responseBuilder;
            return this;
        }

        private void validate() {
            if (Strings.isNullOrEmpty((String)this.server) || Strings.isNullOrEmpty((String)this.api)) {
                throw new IllegalArgumentException("server and api must be set to create a valid call objetc");
            }
        }

        public Call<R> build() {
            this.validate();
            Call call = new Call();
            call.server = this.server;
            call.api = this.api;
            call.headers = this.headers;
            call.pathParams = this.pathParams;
            call.queryParam = this.queryParam;
            call.body = this.body;
            call.responseClass = this.responseClass;
            call.responseBuilder = this.responseBuilder;
            call.requestBodyFunc = this.requestBodyFunc;
            return call;
        }

        public Builder<R> withServerAndApi(String server, String api) {
            this.server = server;
            this.api = api;
            return this;
        }

        public Builder<R> withRequestBodyFunc(Function0<byte[]> requestBodyFunc) {
            this.requestBodyFunc = requestBodyFunc;
            return this;
        }

        public Builder<R> withBody(Object body) {
            this.body = body;
            return this;
        }

        public Builder<R> asContentTypeJson() {
            this.getHeaders().put("Content-Type", "application/json");
            return this;
        }

        public Builder<R> asContentTypeProtoBuffer() {
            this.getHeaders().put("Content-Type", "application/x-protobuf");
            return this;
        }

        public Builder<R> asContentTypeProtoBufferJson() {
            this.getHeaders().put("Content-Type", "application/x-protobuf-json-format");
            return this;
        }

        public Builder<R> addPathParam(String key, Object value) {
            this.getPathParams().put(key, String.format("%s", value));
            return this;
        }

        public Builder<R> addPathParams(Object ... params) {
            if (params.length % 2 != 0) {
                throw new RuntimeException("params count must be even");
            }
            for (int i = 0; i < params.length; i += 2) {
                this.getPathParams().put(String.format("%s", params[i]), String.format("%s", params[i + 1]));
            }
            return this;
        }

        public Builder<R> addPathParams(Map<String, Object> pathParams) {
            this.getPathParams().putAll(pathParams);
            return this;
        }

        public Builder<R> addHeader(String key, Object value) {
            this.getHeaders().put(key, String.format("%s", value));
            return this;
        }

        public Builder<R> addHeaders(Object ... headers) {
            if (headers.length % 2 != 0) {
                throw new RuntimeException("headers count must be even");
            }
            for (int i = 0; i < headers.length; i += 2) {
                this.getHeaders().put(String.format("%s", headers[i]), String.format("%s", headers[i + 1]));
            }
            return this;
        }

        public Builder<R> addHeaders(Map<String, Object> headers) {
            this.getHeaders().putAll(headers);
            return this;
        }

        public Builder<R> addQueryParam(String key, Object value) {
            this.getQueryParam().add((Object)key, (Object)String.format("%s", value));
            return this;
        }

        public Builder<R> addQueryParams(Object ... queryParams) {
            if (queryParams.length % 2 != 0) {
                throw new RuntimeException("params count must be even");
            }
            for (int i = 0; i < queryParams.length; i += 2) {
                this.getQueryParam().add((Object)String.format("%s", queryParams[i]), (Object)String.format("%s", queryParams[i + 1]));
            }
            return this;
        }

        public Builder<R> addQueryParams(MultivaluedHashMap<String, Object> queryParams) {
            this.getQueryParam().putAll(queryParams);
            return this;
        }

        public Builder<R> addQueryParams(Map<String, Object> queryParams) {
            queryParams.forEach((key, value) -> this.getQueryParam().add(key, (Object)String.format("%s", value)));
            return this;
        }

        private Map<String, Object> getHeaders() {
            if (this.headers == null) {
                this.headers = new HashMap<String, Object>();
            }
            return this.headers;
        }

        private Map<String, Object> getPathParams() {
            if (this.pathParams == null) {
                this.pathParams = new HashMap<String, Object>();
            }
            return this.pathParams;
        }

        private MultivaluedMap<String, Object> getQueryParam() {
            if (this.queryParam == null) {
                this.queryParam = new MultivaluedHashMap();
            }
            return this.queryParam;
        }
    }

    public static interface IResponseBuilderFunc<R> {
        public R apply(byte[] var1) throws Exception;
    }
}

