/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.lock;

import com.google.inject.ImplementedBy;
import io.github.devlibx.easy.lock.IDistributedLock;
import io.github.devlibx.easy.lock.IDistributedLockIdResolver;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementedBy(value=NoOpDistributedLockService.class)
public interface IDistributedLockService {
    public static final String NO_OP_LOCK_NAME = "__no_op_lock_name__";

    public void initialize();

    public void shutdown();

    public IDistributedLock getLock(String var1);

    public static class NoOpDistributedLockIdResolver
    implements IDistributedLockIdResolver {
        @Override
        public IDistributedLock.LockRequest createLockRequest(MethodInvocation invocation, Object[] arguments) {
            return IDistributedLock.LockRequest.builder().lockId(UUID.randomUUID().toString()).build();
        }
    }

    public static class ExistingLockWithNoOp
    extends NoOpLock {
        private final Lock existingLock;

        public ExistingLockWithNoOp(Lock existingLock) {
            this.existingLock = existingLock;
        }

        public Lock getExistingLock() {
            return this.existingLock;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExistingLockWithNoOp)) {
                return false;
            }
            ExistingLockWithNoOp other = (ExistingLockWithNoOp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Lock this$existingLock = this.getExistingLock();
            Lock other$existingLock = other.getExistingLock();
            return !(this$existingLock == null ? other$existingLock != null : !this$existingLock.equals(other$existingLock));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExistingLockWithNoOp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Lock $existingLock = this.getExistingLock();
            result = result * 59 + ($existingLock == null ? 43 : $existingLock.hashCode());
            return result;
        }

        public String toString() {
            return "IDistributedLockService.ExistingLockWithNoOp(existingLock=" + this.getExistingLock() + ")";
        }
    }

    public static class NoOpLock
    implements Lock {
        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            return null;
        }
    }

    public static class NoOpDistributedLock
    implements IDistributedLock {
        private static final Logger log = LoggerFactory.getLogger(NoOpDistributedLock.class);

        @Override
        public Lock achieveLock(IDistributedLock.LockRequest request) {
            log.warn("NoOpDistributedLock - (no lock is taken - it is no-op implementation): request={}", (Object)request);
            return new NoOpLock();
        }

        @Override
        public void releaseLock(Lock lock, IDistributedLock.LockRequest lockRequest) {
        }
    }

    public static class NoOpDistributedLockService
    implements IDistributedLockService {
        @Override
        public void initialize() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public IDistributedLock getLock(String name) {
            return new NoOpDistributedLock();
        }
    }
}

