/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.AbstractDynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.AttributeTransformer;
import com.amazonaws.services.dynamodbv2.datamodeling.BatchLoadContext;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTableMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTransactionLoadExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTransactionWriteExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.KeyPair;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedParallelScanList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import com.amazonaws.services.dynamodbv2.datamodeling.ParallelScanTask;
import com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.ScanResultPage;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardModelFactories;
import com.amazonaws.services.dynamodbv2.datamodeling.TransactionLoadRequest;
import com.amazonaws.services.dynamodbv2.datamodeling.TransactionWriteRequest;
import com.amazonaws.services.dynamodbv2.datamodeling.UpdateExpressionGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.VersionAttributeConditionExpressionGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionCheck;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.Delete;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.Get;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.ItemResponse;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.Put;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.ReturnValuesOnConditionCheckFailure;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.services.dynamodbv2.model.TransactGetItem;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsResult;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItem;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.Update;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.util.VersionInfoUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamoDBMapper
extends AbstractDynamoDBMapper {
    private final AmazonDynamoDB db;
    private final DynamoDBMapperModelFactory models;
    private final S3Link.Factory s3Links;
    private final AttributeTransformer transformer;
    static final long MAX_BACKOFF_IN_MILLISECONDS = 3000L;
    static final int MAX_ITEMS_PER_BATCH = 25;
    static final int BATCH_GET_MAX_RETRY_COUNT_ALL_KEYS = 5;
    private static final String USER_AGENT = DynamoDBMapper.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_BATCH_OPERATION = DynamoDBMapper.class.getName() + "_batch_operation/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_TRANSACTION_OPERATION = DynamoDBMapper.class.getName() + "_transaction_operation/" + VersionInfoUtils.getVersion();
    private static final Log log = LogFactory.getLog(DynamoDBMapper.class);

    private static void failFastOnIncompatibleSubclass(Class<?> clazz) {
        while (clazz != DynamoDBMapper.class) {
            Object[] classOverride = new Class[]{Class.class, Map.class};
            Object[] nameOverride = new Class[]{String.class, String.class, Map.class};
            for (Method method : clazz.getDeclaredMethods()) {
                Object[] params;
                if (!method.getName().equals("transformAttributes") || !Arrays.equals(params = method.getParameterTypes(), classOverride) && !Arrays.equals(params, nameOverride)) continue;
                throw new IllegalStateException("The deprecated transformAttributes method is no longer supported as of 1.9.0. Use an AttributeTransformer to inject custom attribute transformation logic.");
            }
            clazz = clazz.getSuperclass();
        }
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB) {
        this(dynamoDB, DynamoDBMapperConfig.DEFAULT, null, null);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config) {
        this(dynamoDB, config, null, null);
    }

    public DynamoDBMapper(AmazonDynamoDB ddb, AWSCredentialsProvider s3CredentialProvider) {
        this(ddb, DynamoDBMapperConfig.DEFAULT, s3CredentialProvider);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AttributeTransformer transformer) {
        this(dynamoDB, config, transformer, null);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AWSCredentialsProvider s3CredentialProvider) {
        this(dynamoDB, config, null, DynamoDBMapper.validate(s3CredentialProvider));
    }

    private static AWSCredentialsProvider validate(AWSCredentialsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("s3 credentials provider must not be null");
        }
        return provider;
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config, AttributeTransformer transformer, AWSCredentialsProvider s3CredentialsProvider) {
        super(config);
        DynamoDBMapper.failFastOnIncompatibleSubclass(this.getClass());
        this.db = dynamoDB;
        this.transformer = transformer;
        this.s3Links = S3Link.Factory.of(s3CredentialsProvider);
        this.models = StandardModelFactories.of(this.s3Links);
    }

    @Override
    public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> clazz, DynamoDBMapperConfig config) {
        return this.models.getTableFactory(config).getTable(clazz);
    }

    @Override
    public <T> T load(T keyObject, DynamoDBMapperConfig config) {
        Class<?> clazz = keyObject.getClass();
        config = this.mergeConfig(config);
        DynamoDBMapperTableModel<?> model = this.getTableModel(clazz, config);
        String tableName = this.getTableName(clazz, keyObject, config);
        GetItemRequest rq = (GetItemRequest)new GetItemRequest().withRequestMetricCollector(config.getRequestMetricCollector());
        Map<String, AttributeValue> key = model.convertKey(keyObject);
        rq.setKey(key);
        rq.setTableName(tableName);
        rq.setConsistentRead(config.getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT);
        GetItemResult item = this.db.getItem(DynamoDBMapper.applyUserAgent(rq));
        Map<String, AttributeValue> itemAttributes = item.getItem();
        if (itemAttributes == null) {
            return null;
        }
        Object object = this.privateMarshallIntoObject(this.toParameters(itemAttributes, clazz, tableName, config));
        return (T)object;
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        DynamoDBMapperTableModel<T> model = this.getTableModel(clazz, config);
        T keyObject = model.createKey(hashKey, rangeKey);
        return this.load(keyObject, config);
    }

    @Override
    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        String tableName = this.getTableName(clazz, config);
        return this.privateMarshallIntoObject(this.toParameters(itemAttributes, clazz, tableName, config));
    }

    private <T> T privateMarshallIntoObject(AttributeTransformer.Parameters<T> parameters) {
        Class<T> clazz = parameters.getModelClass();
        Map<String, AttributeValue> values = this.untransformAttributes(parameters);
        DynamoDBMapperTableModel<T> model = this.getTableModel(clazz, parameters.getMapperConfig());
        return model.unconvert(values);
    }

    @Override
    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ArrayList<T> result = new ArrayList<T>(itemAttributes.size());
        for (Map<String, AttributeValue> item : itemAttributes) {
            result.add(this.marshallIntoObject(clazz, item));
        }
        return result;
    }

    final <T> List<T> marshallIntoObjects(List<AttributeTransformer.Parameters<T>> parameters) {
        ArrayList<T> result = new ArrayList<T>(parameters.size());
        for (AttributeTransformer.Parameters<T> entry : parameters) {
            result.add(this.privateMarshallIntoObject(entry));
        }
        return result;
    }

    @Override
    public <T> void save(T object, DynamoDBSaveExpression saveExpression, DynamoDBMapperConfig config) {
        DynamoDBMapperConfig finalConfig = this.mergeConfig(config);
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, object, finalConfig);
        DynamoDBMapperTableModel<?> model = this.getTableModel(clazz, finalConfig);
        boolean usePut = finalConfig.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER || finalConfig.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.PUT || DynamoDBMapper.anyKeyGeneratable(model, object, finalConfig.getSaveBehavior());
        SaveObjectHandler saveObjectHandler = usePut ? new SaveObjectHandler(this, clazz, object, tableName, finalConfig, saveExpression){
            {
                DynamoDBMapper dynamoDBMapper = x0;
                dynamoDBMapper.getClass();
                super(clazz, object, tableName, saveConfig, saveExpression);
            }

            @Override
            protected void onPrimaryKeyAttributeValue(String attributeName, AttributeValue keyAttributeValue) {
                this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withValue(keyAttributeValue).withAction("PUT"));
            }

            @Override
            protected void onNullNonKeyAttribute(String attributeName) {
            }

            @Override
            protected void executeLowLevelRequest() {
                this.doPutItem();
            }
        } : new SaveObjectHandler(this, clazz, object, tableName, finalConfig, saveExpression){
            {
                DynamoDBMapper dynamoDBMapper = x0;
                dynamoDBMapper.getClass();
                super(clazz, object, tableName, saveConfig, saveExpression);
            }

            @Override
            protected void onPrimaryKeyAttributeValue(String attributeName, AttributeValue keyAttributeValue) {
                this.getPrimaryKeyAttributeValues().put(attributeName, keyAttributeValue);
            }

            @Override
            protected void onNonKeyAttribute(String attributeName, AttributeValue currentValue) {
                if (this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.APPEND_SET && (currentValue.getBS() != null || currentValue.getNS() != null || currentValue.getSS() != null)) {
                    this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("ADD"));
                    return;
                }
                super.onNonKeyAttribute(attributeName, currentValue);
            }

            @Override
            protected void onNullNonKeyAttribute(String attributeName) {
                if (this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.UPDATE_SKIP_NULL_ATTRIBUTES || this.getLocalSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.APPEND_SET) {
                    return;
                }
                this.getAttributeValueUpdates().put(attributeName, new AttributeValueUpdate().withAction("DELETE"));
            }

            @Override
            protected void executeLowLevelRequest() {
                UpdateItemResult updateItemResult = this.doUpdateItem();
                if (updateItemResult.getAttributes() == null || updateItemResult.getAttributes().isEmpty()) {
                    for (String keyAttributeName : this.getPrimaryKeyAttributeValues().keySet()) {
                        this.getAttributeValueUpdates().put(keyAttributeName, new AttributeValueUpdate().withValue(this.getPrimaryKeyAttributeValues().get(keyAttributeName)).withAction("PUT"));
                    }
                    this.doPutItem();
                }
            }
        };
        saveObjectHandler.execute();
    }

    @Override
    public <T> void delete(T object, DynamoDBDeleteExpression deleteExpression, DynamoDBMapperConfig config) {
        Iterator<DynamoDBMapperFieldModel<?, Object>> iterator;
        config = this.mergeConfig(config);
        Class<?> clazz = object.getClass();
        DynamoDBMapperTableModel<?> model = this.getTableModel(clazz, config);
        String tableName = this.getTableName(clazz, object, config);
        Map<String, AttributeValue> key = model.convertKey(object);
        HashMap<String, ExpectedAttributeValue> internalAssertions = new HashMap<String, ExpectedAttributeValue>();
        if (config.getSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER && model.versioned() && (iterator = model.versions().iterator()).hasNext()) {
            DynamoDBMapperFieldModel<?, Object> field = iterator.next();
            AttributeValue current = field.getAndConvert(object);
            if (current == null) {
                internalAssertions.put(field.name(), new ExpectedAttributeValue(false));
            } else {
                internalAssertions.put(field.name(), new ExpectedAttributeValue(true).withValue(current));
            }
        }
        DeleteItemRequest req = (DeleteItemRequest)new DeleteItemRequest().withKey(key).withTableName(tableName).withExpected(internalAssertions).withRequestMetricCollector(config.getRequestMetricCollector());
        if (deleteExpression != null) {
            String conditionalExpression = deleteExpression.getConditionExpression();
            if (conditionalExpression != null) {
                if (internalAssertions != null && !internalAssertions.isEmpty()) {
                    throw new SdkClientException("Condition Expressions cannot be used if a versioned attribute is present");
                }
                req = req.withConditionExpression(conditionalExpression).withExpressionAttributeNames(deleteExpression.getExpressionAttributeNames()).withExpressionAttributeValues(deleteExpression.getExpressionAttributeValues());
            }
            req = req.withExpected(DynamoDBMapper.mergeExpectedAttributeValueConditions(internalAssertions, deleteExpression.getExpected(), deleteExpression.getConditionalOperator())).withConditionalOperator(deleteExpression.getConditionalOperator());
        }
        this.db.deleteItem(DynamoDBMapper.applyUserAgent(req));
    }

    @Override
    public void transactionWrite(TransactionWriteRequest transactionWriteRequest, DynamoDBMapperConfig config) {
        if (transactionWriteRequest == null || DynamoDBMapper.isNullOrEmpty(transactionWriteRequest.getTransactionWriteOperations())) {
            throw new SdkClientException("Input request is null or empty");
        }
        DynamoDBMapperConfig finalConfig = this.mergeConfig(config);
        List<TransactionWriteRequest.TransactionWriteOperation> writeOperations = transactionWriteRequest.getTransactionWriteOperations();
        LinkedList<ValueUpdate> inMemoryUpdates = new LinkedList<ValueUpdate>();
        TransactWriteItemsRequest transactWriteItemsRequest = new TransactWriteItemsRequest();
        ArrayList<TransactWriteItem> transactWriteItems = new ArrayList<TransactWriteItem>();
        transactWriteItemsRequest.setClientRequestToken(transactionWriteRequest.getIdempotencyToken());
        for (TransactionWriteRequest.TransactionWriteOperation writeOperation : writeOperations) {
            transactWriteItems.add(this.generateTransactWriteItem(writeOperation, inMemoryUpdates, finalConfig));
        }
        transactWriteItemsRequest.setTransactItems(transactWriteItems);
        this.db.transactWriteItems(DynamoDBMapper.applyTransactionOperationUserAgent(transactWriteItemsRequest));
        for (ValueUpdate update : inMemoryUpdates) {
            update.apply();
        }
    }

    @Override
    public List<Object> transactionLoad(TransactionLoadRequest transactionLoadRequest, DynamoDBMapperConfig config) {
        if (transactionLoadRequest == null || DynamoDBMapper.isNullOrEmpty(transactionLoadRequest.getObjectsToLoad())) {
            return new ArrayList<Object>();
        }
        DynamoDBMapperConfig finalConfig = this.mergeConfig(config);
        List<Object> objectsToLoad = transactionLoadRequest.getObjectsToLoad();
        List<DynamoDBTransactionLoadExpression> transactionLoadExpressions = transactionLoadRequest.getObjectLoadExpressions();
        ArrayList<TransactGetItem> transactGetItems = new ArrayList<TransactGetItem>();
        ArrayList classList = new ArrayList();
        ArrayList<String> tableNameList = new ArrayList<String>();
        for (int i = 0; i < objectsToLoad.size(); ++i) {
            Object objectToLoad = objectsToLoad.get(i);
            DynamoDBTransactionLoadExpression expressionForLoad = transactionLoadExpressions.get(i);
            Class<?> clazz = objectToLoad.getClass();
            String tableName = this.getTableName(clazz, objectToLoad, finalConfig);
            tableNameList.add(tableName);
            classList.add(clazz);
            DynamoDBMapperTableModel<?> model = this.getTableModel(clazz, finalConfig);
            Map<String, AttributeValue> key = model.convertKey(objectToLoad);
            TransactGetItem transactGetItem = new TransactGetItem();
            Get getItem = new Get();
            getItem.setTableName(tableName);
            getItem.setKey(key);
            if (expressionForLoad != null) {
                getItem.setExpressionAttributeNames(expressionForLoad.getExpressionAttributeNames());
                getItem.setProjectionExpression(expressionForLoad.getProjectionExpression());
            }
            transactGetItem.setGet(getItem);
            transactGetItems.add(transactGetItem);
        }
        TransactGetItemsRequest transactGetItemsRequest = new TransactGetItemsRequest();
        transactGetItemsRequest.withTransactItems(transactGetItems);
        TransactGetItemsResult transactGetItemsResult = this.db.transactGetItems(DynamoDBMapper.applyTransactionOperationUserAgent(transactGetItemsRequest));
        List<ItemResponse> responseItems = transactGetItemsResult.getResponses();
        ArrayList<Object> resultObjects = new ArrayList<Object>();
        for (int i = 0; i < responseItems.size(); ++i) {
            if (responseItems.get(i).getItem() == null) {
                resultObjects.add(null);
                continue;
            }
            resultObjects.add(this.privateMarshallIntoObject(this.toParameters(responseItems.get(i).getItem(), (Class)classList.get(i), (String)tableNameList.get(i), finalConfig)));
        }
        return resultObjects;
    }

    @Override
    public List<FailedBatch> batchWrite(Iterable<? extends Object> objectsToWrite, Iterable<? extends Object> objectsToDelete, DynamoDBMapperConfig config) {
        String tableName;
        Class<?> clazz;
        config = this.mergeConfig(config);
        LinkedList<FailedBatch> totalFailedBatches = new LinkedList<FailedBatch>();
        StringListMap<WriteRequest> requestItems = new StringListMap<WriteRequest>();
        LinkedList<ValueUpdate> inMemoryUpdates = new LinkedList<ValueUpdate>();
        for (Object object : objectsToWrite) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, object, config);
            HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
            DynamoDBMapperTableModel<?> model = this.getTableModel(clazz, config);
            for (DynamoDBMapperFieldModel<Object, Object> dynamoDBMapperFieldModel : model.fields()) {
                Object currentValue = null;
                if (DynamoDBMapper.canGenerate(model, object, config.getSaveBehavior(), dynamoDBMapperFieldModel) && !dynamoDBMapperFieldModel.versioned()) {
                    currentValue = dynamoDBMapperFieldModel.convert(dynamoDBMapperFieldModel.generate(dynamoDBMapperFieldModel.get(object)));
                    inMemoryUpdates.add(new ValueUpdate(dynamoDBMapperFieldModel, (AttributeValue)currentValue, object));
                } else {
                    currentValue = dynamoDBMapperFieldModel.convert(dynamoDBMapperFieldModel.get(object));
                }
                if (currentValue == null) continue;
                attributeValues.put(dynamoDBMapperFieldModel.name(), (AttributeValue)currentValue);
            }
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new LinkedList());
            }
            AttributeTransformer.Parameters<?> parameters = this.toParameters(attributeValues, clazz, tableName, config);
            requestItems.add(tableName, new WriteRequest(new PutRequest(this.transformAttributes(parameters))));
        }
        for (Object object : objectsToDelete) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, object, config);
            DynamoDBMapperTableModel<?> model = this.getTableModel(clazz, config);
            Map<String, AttributeValue> key = model.convertKey(object);
            requestItems.add(tableName, new WriteRequest(new DeleteRequest(key)));
        }
        for (StringListMap stringListMap : requestItems.subMaps(25, true)) {
            List<FailedBatch> failedBatches = this.writeOneBatch(stringListMap, config.getBatchWriteRetryStrategy());
            if (failedBatches == null) continue;
            totalFailedBatches.addAll(failedBatches);
            if (!this.containsThrottlingException(failedBatches)) continue;
            DynamoDBMapper.pause(config.getBatchWriteRetryStrategy().getDelayBeforeRetryUnprocessedItems(Collections.unmodifiableMap(stringListMap), 0));
        }
        for (ValueUpdate valueUpdate : inMemoryUpdates) {
            valueUpdate.apply();
        }
        return totalFailedBatches;
    }

    private List<FailedBatch> writeOneBatch(StringListMap<WriteRequest> batch, DynamoDBMapperConfig.BatchWriteRetryStrategy batchWriteRetryStrategy) {
        LinkedList<FailedBatch> failedBatches = new LinkedList<FailedBatch>();
        FailedBatch failedBatch = this.doBatchWriteItemWithRetry(batch, batchWriteRetryStrategy);
        if (failedBatch != null) {
            if (failedBatch.isRequestEntityTooLarge()) {
                if (failedBatch.size() == 1) {
                    failedBatches.add(failedBatch);
                } else {
                    for (StringListMap<WriteRequest> subBatch : batch.subMaps(2, false)) {
                        failedBatches.addAll(this.writeOneBatch(subBatch, batchWriteRetryStrategy));
                    }
                }
            } else {
                failedBatches.add(failedBatch);
            }
        }
        return failedBatches;
    }

    private boolean containsThrottlingException(List<FailedBatch> failedBatches) {
        for (FailedBatch failedBatch : failedBatches) {
            if (!failedBatch.isThrottling()) continue;
            return true;
        }
        return false;
    }

    private FailedBatch doBatchWriteItemWithRetry(Map<String, List<WriteRequest>> batch, DynamoDBMapperConfig.BatchWriteRetryStrategy batchWriteRetryStrategy) {
        BatchWriteItemResult result = null;
        int retries = 0;
        int maxRetries = batchWriteRetryStrategy.getMaxRetryOnUnprocessedItems(Collections.unmodifiableMap(batch));
        FailedBatch failedBatch = null;
        Map<String, List<WriteRequest>> pendingItems = batch;
        while (true) {
            try {
                result = this.db.batchWriteItem(DynamoDBMapper.applyBatchOperationUserAgent(new BatchWriteItemRequest().withRequestItems(pendingItems)));
            }
            catch (Exception e) {
                failedBatch = new FailedBatch();
                failedBatch.setUnprocessedItems(pendingItems);
                failedBatch.setException(e);
                return failedBatch;
            }
            pendingItems = result.getUnprocessedItems();
            if (pendingItems.size() <= 0) break;
            if (maxRetries >= 0 && retries >= maxRetries) {
                failedBatch = new FailedBatch();
                failedBatch.setUnprocessedItems(pendingItems);
                failedBatch.setException(null);
                return failedBatch;
            }
            DynamoDBMapper.pause(batchWriteRetryStrategy.getDelayBeforeRetryUnprocessedItems(Collections.unmodifiableMap(pendingItems), retries));
            ++retries;
        }
        return failedBatch;
    }

    @Override
    public Map<String, List<Object>> batchLoad(Iterable<? extends Object> itemsToGet, DynamoDBMapperConfig config) {
        boolean consistentReads;
        boolean bl = consistentReads = (config = this.mergeConfig(config)).getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT;
        if (itemsToGet == null) {
            return new HashMap<String, List<Object>>();
        }
        HashMap<String, KeysAndAttributes> requestItems = new HashMap<String, KeysAndAttributes>();
        HashMap classesByTableName = new HashMap();
        HashMap<String, List<Object>> resultSet = new HashMap<String, List<Object>>();
        int count = 0;
        for (Object object : itemsToGet) {
            Class<?> clazz = object.getClass();
            DynamoDBMapperTableModel<?> model = this.getTableModel(clazz, config);
            String tableName = this.getTableName(clazz, object, config);
            classesByTableName.put(tableName, clazz);
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new KeysAndAttributes().withConsistentRead(consistentReads).withKeys(new LinkedList<Map<String, AttributeValue>>()));
            }
            ((KeysAndAttributes)requestItems.get(tableName)).getKeys().add(model.convertKey(object));
            if (++count != 100) continue;
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet, config);
            requestItems.clear();
            count = 0;
        }
        if (count > 0) {
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet, config);
        }
        return resultSet;
    }

    @Override
    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ArrayList keys = new ArrayList();
        if (itemsToGet != null) {
            for (Class<?> clazz : itemsToGet.keySet()) {
                if (itemsToGet.get(clazz) == null) continue;
                DynamoDBMapperTableModel<?> model = this.getTableModel(clazz, config);
                for (KeyPair keyPair : itemsToGet.get(clazz)) {
                    keys.add(model.createKey(keyPair.getHashKey(), keyPair.getRangeKey()));
                }
            }
        }
        return this.batchLoad(keys, config);
    }

    private void processBatchGetRequest(Map<String, Class<?>> classesByTableName, Map<String, KeysAndAttributes> requestItems, Map<String, List<Object>> resultSet, DynamoDBMapperConfig config) {
        BatchGetItemResult batchGetItemResult = null;
        BatchGetItemRequest batchGetItemRequest = (BatchGetItemRequest)new BatchGetItemRequest().withRequestMetricCollector(config.getRequestMetricCollector());
        batchGetItemRequest.setRequestItems(requestItems);
        DynamoDBMapperConfig.BatchLoadRetryStrategy batchLoadStrategy = config.getBatchLoadRetryStrategy();
        BatchLoadContext batchLoadContext = new BatchLoadContext(batchGetItemRequest);
        int retries = 0;
        do {
            if (batchGetItemResult != null) {
                batchLoadContext.setRetriesAttempted(++retries);
                if (!DynamoDBMapper.isNullOrEmpty(batchGetItemResult.getUnprocessedKeys())) {
                    DynamoDBMapper.pause(batchLoadStrategy.getDelayBeforeNextRetry(batchLoadContext));
                    batchGetItemRequest.setRequestItems(batchGetItemResult.getUnprocessedKeys());
                }
            }
            batchGetItemResult = this.db.batchGetItem(DynamoDBMapper.applyBatchOperationUserAgent(batchGetItemRequest));
            Map<String, List<Map<String, AttributeValue>>> responses = batchGetItemResult.getResponses();
            for (String tableName : responses.keySet()) {
                List<Object> objects = null;
                objects = resultSet.get(tableName) != null ? resultSet.get(tableName) : new LinkedList();
                Class<?> clazz = classesByTableName.get(tableName);
                for (Map<String, AttributeValue> item : responses.get(tableName)) {
                    AttributeTransformer.Parameters<?> parameters = this.toParameters(item, clazz, tableName, config);
                    objects.add(this.privateMarshallIntoObject(parameters));
                }
                resultSet.put(tableName, objects);
            }
            batchLoadContext.setBatchGetItemResult(batchGetItemResult);
        } while (batchLoadStrategy.shouldRetry(batchLoadContext));
        if (!DynamoDBMapper.isNullOrEmpty(batchGetItemResult.getUnprocessedKeys())) {
            throw new BatchGetItemException("The BatchGetItemResult has unprocessed keys after max retry attempts. Catch the BatchGetItemException to get the list of unprocessed keys.", batchGetItemResult.getUnprocessedKeys(), resultSet);
        }
    }

    private static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    private static <T> boolean isNullOrEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    private static <T> boolean anyKeyGeneratable(DynamoDBMapperTableModel<T> model, T object, DynamoDBMapperConfig.SaveBehavior saveBehavior) {
        for (DynamoDBMapperFieldModel<T, Object> field : model.keys()) {
            if (!DynamoDBMapper.canGenerate(model, object, saveBehavior, field)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean canGenerate(DynamoDBMapperTableModel<T> model, T object, DynamoDBMapperConfig.SaveBehavior saveBehavior, DynamoDBMapperFieldModel<T, Object> field) {
        if (field.getGenerateStrategy() == null) {
            return false;
        }
        if (field.getGenerateStrategy() == DynamoDBAutoGenerateStrategy.ALWAYS) {
            return true;
        }
        if (field.get(object) != null) {
            return false;
        }
        if (field.keyType() != null || field.indexed()) {
            return true;
        }
        if (saveBehavior == DynamoDBMapperConfig.SaveBehavior.CLOBBER || saveBehavior == DynamoDBMapperConfig.SaveBehavior.UPDATE || saveBehavior == DynamoDBMapperConfig.SaveBehavior.PUT) {
            return true;
        }
        return DynamoDBMapper.anyKeyGeneratable(model, object, saveBehavior);
    }

    @Override
    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResult scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
        return new PaginatedScanList<T>(this, clazz, this.db, scanRequest, scanResult, config.getPaginationLoadingStrategy(), config);
    }

    @Override
    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDBScanExpression scanExpression, int totalSegments, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        List<ScanRequest> parallelScanRequests = this.createParallelScanRequestsFromExpression(clazz, scanExpression, totalSegments, config);
        ParallelScanTask parallelScanTask = new ParallelScanTask(this.db, parallelScanRequests);
        return new PaginatedParallelScanList<T>(this, clazz, this.db, parallelScanTask, config.getPaginationLoadingStrategy(), config);
    }

    @Override
    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResult scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
        ScanResultPage<T> result = new ScanResultPage<T>();
        List<AttributeTransformer.Parameters<T>> parameters = this.toParameters(scanResult.getItems(), clazz, scanRequest.getTableName(), config);
        result.setResults(this.marshallIntoObjects(parameters));
        result.setLastEvaluatedKey(scanResult.getLastEvaluatedKey());
        result.setCount(scanResult.getCount());
        result.setScannedCount(scanResult.getScannedCount());
        result.setConsumedCapacity(scanResult.getConsumedCapacity());
        return result;
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResult queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
        return new PaginatedQueryList<T>(this, clazz, this.db, queryRequest, queryResult, config.getPaginationLoadingStrategy(), config);
    }

    @Override
    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResult queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
        QueryResultPage<T> result = new QueryResultPage<T>();
        List<AttributeTransformer.Parameters<T>> parameters = this.toParameters(queryResult.getItems(), clazz, queryRequest.getTableName(), config);
        result.setResults(this.marshallIntoObjects(parameters));
        result.setLastEvaluatedKey(queryResult.getLastEvaluatedKey());
        result.setCount(queryResult.getCount());
        result.setScannedCount(queryResult.getScannedCount());
        result.setConsumedCapacity(queryResult.getConsumedCapacity());
        return result;
    }

    @Override
    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        scanRequest.setSelect(Select.COUNT);
        int count = 0;
        ScanResult scanResult = null;
        do {
            scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
            count += scanResult.getCount().intValue();
            scanRequest.setExclusiveStartKey(scanResult.getLastEvaluatedKey());
        } while (scanResult.getLastEvaluatedKey() != null);
        return count;
    }

    @Override
    public <T> int count(Class<T> clazz, DynamoDBQueryExpression<T> queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        queryRequest.setSelect(Select.COUNT);
        int count = 0;
        QueryResult queryResult = null;
        do {
            queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
            count += queryResult.getCount().intValue();
            queryRequest.setExclusiveStartKey(queryResult.getLastEvaluatedKey());
        } while (queryResult.getLastEvaluatedKey() != null);
        return count;
    }

    private ScanRequest createScanRequestFromExpression(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(this.getTableName(clazz, config));
        scanRequest.setIndexName(scanExpression.getIndexName());
        scanRequest.setScanFilter(scanExpression.getScanFilter());
        scanRequest.setLimit(scanExpression.getLimit());
        scanRequest.setExclusiveStartKey(scanExpression.getExclusiveStartKey());
        scanRequest.setTotalSegments(scanExpression.getTotalSegments());
        scanRequest.setSegment(scanExpression.getSegment());
        scanRequest.setConditionalOperator(scanExpression.getConditionalOperator());
        scanRequest.setFilterExpression(scanExpression.getFilterExpression());
        scanRequest.setExpressionAttributeNames(scanExpression.getExpressionAttributeNames());
        scanRequest.setExpressionAttributeValues(scanExpression.getExpressionAttributeValues());
        scanRequest.setRequestMetricCollector(config.getRequestMetricCollector());
        scanRequest.setSelect(scanExpression.getSelect());
        scanRequest.setProjectionExpression(scanExpression.getProjectionExpression());
        scanRequest.setReturnConsumedCapacity(scanExpression.getReturnConsumedCapacity());
        scanRequest.setConsistentRead(scanExpression.isConsistentRead());
        return DynamoDBMapper.applyUserAgent(scanRequest);
    }

    private List<ScanRequest> createParallelScanRequestsFromExpression(Class<?> clazz, DynamoDBScanExpression scanExpression, int totalSegments, DynamoDBMapperConfig config) {
        if (totalSegments < 1) {
            throw new IllegalArgumentException("Parallel scan should have at least one scan segment.");
        }
        if (scanExpression.getExclusiveStartKey() != null) {
            log.info("The ExclusiveStartKey parameter specified in the DynamoDBScanExpression is ignored, since the individual parallel scan request on each segment is applied on a separate key scope.");
        }
        if (scanExpression.getSegment() != null || scanExpression.getTotalSegments() != null) {
            log.info("The Segment and TotalSegments parameters specified in the DynamoDBScanExpression are ignored.");
        }
        LinkedList<ScanRequest> parallelScanRequests = new LinkedList<ScanRequest>();
        for (int segment = 0; segment < totalSegments; ++segment) {
            ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
            parallelScanRequests.add(scanRequest.withSegment(segment).withTotalSegments(totalSegments).withExclusiveStartKey(null));
        }
        return parallelScanRequests;
    }

    protected <T> QueryRequest createQueryRequestFromExpression(Class<T> clazz, DynamoDBQueryExpression<T> xpress, DynamoDBMapperConfig config) {
        DynamoDBMapperTableModel<T> model = this.getTableModel(clazz, config);
        QueryRequest req = new QueryRequest();
        req.setConsistentRead(xpress.isConsistentRead());
        req.setTableName(this.getTableName(clazz, xpress.getHashKeyValues(), config));
        req.setIndexName(xpress.getIndexName());
        req.setKeyConditionExpression(xpress.getKeyConditionExpression());
        DynamoDBMapper.processKeyConditions(req, xpress, model);
        req.withScanIndexForward(xpress.isScanIndexForward()).withLimit(xpress.getLimit()).withExclusiveStartKey(xpress.getExclusiveStartKey()).withQueryFilter(xpress.getQueryFilter()).withConditionalOperator(xpress.getConditionalOperator()).withSelect(xpress.getSelect()).withProjectionExpression(xpress.getProjectionExpression()).withFilterExpression(xpress.getFilterExpression()).withExpressionAttributeNames(xpress.getExpressionAttributeNames()).withExpressionAttributeValues(xpress.getExpressionAttributeValues()).withReturnConsumedCapacity(xpress.getReturnConsumedCapacity()).withRequestMetricCollector(config.getRequestMetricCollector());
        return DynamoDBMapper.applyUserAgent(req);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> void processKeyConditions(QueryRequest queryRequest, DynamoDBQueryExpression<T> expression, DynamoDBMapperTableModel<T> model) {
        boolean userProvidedGSI;
        LinkedHashMap<String, Condition> hashKeyConditions = new LinkedHashMap<String, Condition>();
        if (expression.getHashKeyValues() != null) {
            for (DynamoDBMapperFieldModel<T, Object> field : model.fields()) {
                Object value;
                if (field.keyType() != KeyType.HASH && field.globalSecondaryIndexNames(KeyType.HASH).isEmpty() || (value = field.get(expression.getHashKeyValues())) == null) continue;
                hashKeyConditions.put(field.name(), field.eq(value));
            }
        }
        Map<String, Condition> rangeKeyConditions = expression.getRangeKeyConditions();
        String keyCondExpression = queryRequest.getKeyConditionExpression();
        if (keyCondExpression == null) {
            if (DynamoDBMapper.isNullOrEmpty(hashKeyConditions)) {
                throw new IllegalArgumentException("Illegal query expression: No hash key condition is found in the query");
            }
        } else {
            if (!DynamoDBMapper.isNullOrEmpty(hashKeyConditions)) {
                throw new IllegalArgumentException("Illegal query expression: Either the hash key conditions or the key condition expression must be specified but not both.");
            }
            if (DynamoDBMapper.isNullOrEmpty(rangeKeyConditions)) return;
            throw new IllegalArgumentException("Illegal query expression: The range key conditions can only be specified when the key condition expression is not specified.");
        }
        if (rangeKeyConditions != null && rangeKeyConditions.size() > 1) {
            throw new IllegalArgumentException("Illegal query expression: Conditions on multiple range keys (" + rangeKeyConditions.keySet().toString() + ") are found in the query. DynamoDB service only accepts up to ONE range key condition.");
        }
        boolean hasRangeKeyCondition = rangeKeyConditions != null && !rangeKeyConditions.isEmpty();
        String userProvidedIndexName = queryRequest.getIndexName();
        String primaryHashKeyName = model.hashKey().name();
        boolean hasPrimaryHashKeyCondition = false;
        HashMap annotatedGSIsOnHashKeys = new HashMap();
        String hashKeyNameForThisQuery = null;
        boolean hasPrimaryRangeKeyCondition = false;
        HashSet<String> annotatedLSIsOnRangeKey = new HashSet<String>();
        HashSet<String> annotatedGSIsOnRangeKey = new HashSet<String>();
        String rangeKeyNameForThisQuery = null;
        if (hasRangeKeyCondition) {
            Iterator<String> iterator = rangeKeyConditions.keySet().iterator();
            while (iterator.hasNext()) {
                String rangeKeyName;
                rangeKeyNameForThisQuery = rangeKeyName = iterator.next();
                DynamoDBMapperFieldModel rk = model.field(rangeKeyName);
                if (rk.keyType() == KeyType.RANGE) {
                    hasPrimaryRangeKeyCondition = true;
                }
                annotatedLSIsOnRangeKey.addAll(rk.localSecondaryIndexNames());
                annotatedGSIsOnRangeKey.addAll(rk.globalSecondaryIndexNames(KeyType.RANGE));
            }
            if (!hasPrimaryRangeKeyCondition && annotatedLSIsOnRangeKey.isEmpty() && annotatedGSIsOnRangeKey.isEmpty()) {
                throw new DynamoDBMappingException("The query contains a condition on a range key (" + rangeKeyNameForThisQuery + ") that is not annotated with either @DynamoDBRangeKey or @DynamoDBIndexRangeKey.");
            }
        }
        boolean userProvidedLSIWithRangeKeyCondition = userProvidedIndexName != null && annotatedLSIsOnRangeKey.contains(userProvidedIndexName);
        boolean hashOnlyLSIQuery = userProvidedIndexName != null && !hasRangeKeyCondition && model.localSecondaryIndex(userProvidedIndexName) != null;
        boolean userProvidedLSI = userProvidedLSIWithRangeKeyCondition || hashOnlyLSIQuery;
        boolean userProvidedGSIWithRangeKeyCondition = userProvidedIndexName != null && annotatedGSIsOnRangeKey.contains(userProvidedIndexName);
        boolean hashOnlyGSIQuery = userProvidedIndexName != null && !hasRangeKeyCondition && model.globalSecondaryIndex(userProvidedIndexName) != null;
        boolean bl = userProvidedGSI = userProvidedGSIWithRangeKeyCondition || hashOnlyGSIQuery;
        if (userProvidedLSI && userProvidedGSI) {
            throw new DynamoDBMappingException("Invalid query: Index \"" + userProvidedIndexName + "\" is annotateded as both a LSI and a GSI for attribute.");
        }
        for (String hashKeyName : hashKeyConditions.keySet()) {
            DynamoDBMapperFieldModel hk;
            List<String> annotatedGSINames;
            if (hashKeyName.equals(primaryHashKeyName)) {
                hasPrimaryHashKeyCondition = true;
            }
            annotatedGSIsOnHashKeys.put(hashKeyName, (annotatedGSINames = (hk = model.field(hashKeyName)).globalSecondaryIndexNames(KeyType.HASH)) == null ? new HashSet() : new HashSet<String>(annotatedGSINames));
            if (userProvidedIndexName == null) continue;
            boolean foundHashKeyConditionValidWithUserProvidedIndex = false;
            if (userProvidedLSI && hashKeyName.equals(primaryHashKeyName)) {
                foundHashKeyConditionValidWithUserProvidedIndex = true;
            } else if (userProvidedGSI && annotatedGSINames != null && annotatedGSINames.contains(userProvidedIndexName)) {
                foundHashKeyConditionValidWithUserProvidedIndex = true;
            }
            if (!foundHashKeyConditionValidWithUserProvidedIndex) continue;
            if (hashKeyNameForThisQuery != null) {
                throw new IllegalArgumentException("Ambiguous query expression: More than one hash key EQ conditions (" + hashKeyNameForThisQuery + ", " + hashKeyName + ") are applicable to the specified index (" + userProvidedIndexName + "). Please provide only one of them in the query expression.");
            }
            hashKeyNameForThisQuery = hashKeyName;
        }
        HashMap<String, Condition> keyConditions = new HashMap<String, Condition>();
        if (userProvidedIndexName != null) {
            if (hasRangeKeyCondition && !userProvidedLSI && !userProvidedGSI) {
                throw new IllegalArgumentException("Illegal query expression: No range key condition is applicable to the specified index (" + userProvidedIndexName + "). ");
            }
            if (hashKeyNameForThisQuery == null) {
                throw new IllegalArgumentException("Illegal query expression: No hash key condition is applicable to the specified index (" + userProvidedIndexName + "). ");
            }
            keyConditions.put(hashKeyNameForThisQuery, (Condition)hashKeyConditions.get(hashKeyNameForThisQuery));
            if (hasRangeKeyCondition) {
                keyConditions.putAll(rangeKeyConditions);
            }
        } else if (hasRangeKeyCondition) {
            String inferredIndexName = null;
            hashKeyNameForThisQuery = null;
            if (hasPrimaryHashKeyCondition && hasPrimaryRangeKeyCondition) {
                hashKeyNameForThisQuery = primaryHashKeyName;
            } else {
                for (String hashKeyName : annotatedGSIsOnHashKeys.keySet()) {
                    boolean foundValidQueryExpressionWithInferredIndex = false;
                    String indexNameInferredByThisHashKey = null;
                    if (hashKeyName.equals(primaryHashKeyName) && annotatedLSIsOnRangeKey.size() == 1) {
                        foundValidQueryExpressionWithInferredIndex = true;
                        indexNameInferredByThisHashKey = (String)annotatedLSIsOnRangeKey.iterator().next();
                    }
                    Set annotatedGSIsOnHashKey = (Set)annotatedGSIsOnHashKeys.get(hashKeyName);
                    annotatedGSIsOnHashKey.retainAll(annotatedGSIsOnRangeKey);
                    if (annotatedGSIsOnHashKey.size() == 1) {
                        if (foundValidQueryExpressionWithInferredIndex) {
                            hashKeyNameForThisQuery = hashKeyName;
                            inferredIndexName = indexNameInferredByThisHashKey;
                        }
                        foundValidQueryExpressionWithInferredIndex = true;
                        indexNameInferredByThisHashKey = (String)annotatedGSIsOnHashKey.iterator().next();
                    }
                    if (!foundValidQueryExpressionWithInferredIndex) continue;
                    if (hashKeyNameForThisQuery != null) {
                        throw new IllegalArgumentException("Ambiguous query expression: Found multiple valid queries: (Hash: \"" + hashKeyNameForThisQuery + "\", Range: \"" + rangeKeyNameForThisQuery + "\", Index: \"" + inferredIndexName + "\") and (Hash: \"" + hashKeyName + "\", Range: \"" + rangeKeyNameForThisQuery + "\", Index: \"" + indexNameInferredByThisHashKey + "\").");
                    }
                    hashKeyNameForThisQuery = hashKeyName;
                    inferredIndexName = indexNameInferredByThisHashKey;
                }
            }
            if (hashKeyNameForThisQuery == null) throw new IllegalArgumentException("Illegal query expression: Cannot infer the index name from the query expression.");
            keyConditions.put(hashKeyNameForThisQuery, (Condition)hashKeyConditions.get(hashKeyNameForThisQuery));
            keyConditions.putAll(rangeKeyConditions);
            queryRequest.setIndexName(inferredIndexName);
        } else if (hashKeyConditions.size() > 1) {
            if (!hasPrimaryHashKeyCondition) throw new IllegalArgumentException("Ambiguous query expression: More than one index hash key EQ conditions (" + hashKeyConditions.keySet() + ") are applicable to the query. Please provide only one of them in the query expression, or specify the appropriate index name.");
            keyConditions.put(primaryHashKeyName, (Condition)hashKeyConditions.get(primaryHashKeyName));
        } else {
            String hashKeyName;
            hashKeyName = (String)annotatedGSIsOnHashKeys.keySet().iterator().next();
            if (!hasPrimaryHashKeyCondition) {
                if (((Set)annotatedGSIsOnHashKeys.get(hashKeyName)).size() == 1) {
                    queryRequest.setIndexName((String)((Set)annotatedGSIsOnHashKeys.get(hashKeyName)).iterator().next());
                } else {
                    if (((Set)annotatedGSIsOnHashKeys.get(hashKeyName)).size() <= 1) throw new IllegalArgumentException("Illegal query expression: No GSI is found in the @DynamoDBIndexHashKey annotation for attribute \"" + hashKeyName + "\".");
                    throw new IllegalArgumentException("Ambiguous query expression: More than one GSIs (" + annotatedGSIsOnHashKeys.get(hashKeyName) + ") are applicable to the query. Please specify one of them in your query expression.");
                }
            }
            keyConditions.putAll(hashKeyConditions);
        }
        queryRequest.setKeyConditions(keyConditions);
    }

    private <T> AttributeTransformer.Parameters<T> toParameters(Map<String, AttributeValue> attributeValues, Class<T> modelClass, String tableName, DynamoDBMapperConfig mapperConfig) {
        return this.toParameters(attributeValues, false, modelClass, tableName, mapperConfig);
    }

    private <T> AttributeTransformer.Parameters<T> toParameters(Map<String, AttributeValue> attributeValues, boolean partialUpdate, Class<T> modelClass, String tableName, DynamoDBMapperConfig mapperConfig) {
        return new TransformerParameters<T>(this.getTableModel(modelClass, mapperConfig), attributeValues, partialUpdate, modelClass, mapperConfig, tableName);
    }

    final <T> List<AttributeTransformer.Parameters<T>> toParameters(List<Map<String, AttributeValue>> attributeValues, Class<T> modelClass, String tableName, DynamoDBMapperConfig mapperConfig) {
        if (attributeValues == null) {
            return Collections.emptyList();
        }
        ArrayList<AttributeTransformer.Parameters<T>> rval = new ArrayList<AttributeTransformer.Parameters<T>>(attributeValues.size());
        for (Map<String, AttributeValue> item : attributeValues) {
            rval.add(this.toParameters(item, modelClass, tableName, mapperConfig));
        }
        return rval;
    }

    private Map<String, AttributeValue> untransformAttributes(AttributeTransformer.Parameters<?> parameters) {
        if (this.transformer != null) {
            return this.transformer.untransform(parameters);
        }
        return parameters.getAttributeValues();
    }

    private Map<String, AttributeValue> transformAttributes(AttributeTransformer.Parameters<?> parameters) {
        if (this.transformer != null) {
            return this.transformer.transform(parameters);
        }
        return parameters.getAttributeValues();
    }

    private static Map<String, ExpectedAttributeValue> mergeExpectedAttributeValueConditions(Map<String, ExpectedAttributeValue> internalAssertions, Map<String, ExpectedAttributeValue> userProvidedConditions, String userProvidedConditionOperator) {
        if ((internalAssertions == null || internalAssertions.isEmpty()) && (userProvidedConditions == null || userProvidedConditions.isEmpty())) {
            return null;
        }
        if (internalAssertions == null) {
            return new HashMap<String, ExpectedAttributeValue>(userProvidedConditions);
        }
        if (userProvidedConditions == null) {
            return new HashMap<String, ExpectedAttributeValue>(internalAssertions);
        }
        HashMap<String, ExpectedAttributeValue> mergedExpectedValues = new HashMap<String, ExpectedAttributeValue>(internalAssertions);
        for (String attrName : userProvidedConditions.keySet()) {
            mergedExpectedValues.remove(attrName);
        }
        if (ConditionalOperator.OR.toString().equals(userProvidedConditionOperator) && !mergedExpectedValues.isEmpty()) {
            throw new IllegalArgumentException("Unable to assert the value of the fields " + mergedExpectedValues.keySet() + ", since the expected value conditions cannot be combined with user-specified conditions joined by \"OR\". You can use SaveBehavior.CLOBBER to skip the assertion on these fields.");
        }
        mergedExpectedValues.putAll(userProvidedConditions);
        return mergedExpectedValues;
    }

    static <X extends AmazonWebServiceRequest> X applyUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    static <X extends AmazonWebServiceRequest> X applyBatchOperationUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT_BATCH_OPERATION);
        return request;
    }

    static <X extends AmazonWebServiceRequest> X applyTransactionOperationUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT_TRANSACTION_OPERATION);
        return request;
    }

    @Override
    public S3ClientCache getS3ClientCache() {
        return this.s3Links.getS3ClientCache();
    }

    @Override
    public S3Link createS3Link(Region s3region, String bucketName, String key) {
        return this.s3Links.createS3Link(s3region, bucketName, key);
    }

    @Override
    public S3Link createS3Link(String s3region, String bucketName, String key) {
        return this.s3Links.createS3Link(s3region, bucketName, key);
    }

    @Override
    public <T> CreateTableRequest generateCreateTableRequest(Class<T> clazz, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        DynamoDBMapperTableModel<T> model = this.getTableModel(clazz, config);
        CreateTableRequest request = new CreateTableRequest();
        request.setTableName(this.getTableName(clazz, config));
        request.withKeySchema(new KeySchemaElement(model.hashKey().name(), KeyType.HASH));
        if (model.rangeKeyIfExists() != null) {
            request.withKeySchema(new KeySchemaElement(model.rangeKey().name(), KeyType.RANGE));
        }
        request.setGlobalSecondaryIndexes(model.globalSecondaryIndexes());
        request.setLocalSecondaryIndexes(model.localSecondaryIndexes());
        for (DynamoDBMapperFieldModel<T, Object> field : model.fields()) {
            if (field.keyType() == null && !field.indexed()) continue;
            request.withAttributeDefinitions(new AttributeDefinition().withAttributeType(ScalarAttributeType.valueOf(field.attributeType().name())).withAttributeName(field.name()));
        }
        return request;
    }

    @Override
    public <T> DeleteTableRequest generateDeleteTableRequest(Class<T> clazz, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        DeleteTableRequest deleteTableRequest = new DeleteTableRequest();
        deleteTableRequest.setTableName(this.getTableName(clazz, config));
        return deleteTableRequest;
    }

    public <T, H, R> DynamoDBTableMapper<T, H, R> newTableMapper(Class<T> clazz) {
        DynamoDBMapperConfig config = this.mergeConfig(null);
        return new DynamoDBTableMapper(this.db, this, config, this.getTableModel(clazz, config));
    }

    private static void pause(long delay) {
        if (delay <= 0L) {
            return;
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SdkClientException(e.getMessage(), e);
        }
    }

    private TransactWriteItem generateTransactWriteItem(TransactionWriteRequest.TransactionWriteOperation transactionWriteOperation, List<ValueUpdate> inMemoryUpdates, DynamoDBMapperConfig config) {
        Object objectToWrite = transactionWriteOperation.getObject();
        DynamoDBTransactionWriteExpression writeExpression = transactionWriteOperation.getDynamoDBTransactionWriteExpression();
        ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure = transactionWriteOperation.getReturnValuesOnConditionCheckFailure();
        TransactionWriteRequest.TransactionWriteOperationType operationType = transactionWriteOperation.getTransactionWriteOperationType();
        Class<?> clazz = objectToWrite.getClass();
        String tableName = this.getTableName(clazz, objectToWrite, config);
        HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
        DynamoDBMapperTableModel<Object> model = this.getTableModel(clazz, config);
        VersionAttributeConditionExpressionGenerator versionAttributeConditionExpressionGenerator = new VersionAttributeConditionExpressionGenerator();
        for (DynamoDBMapperFieldModel<Object, Object> dynamoDBMapperFieldModel : model.fields()) {
            Object currentValue = null;
            if (dynamoDBMapperFieldModel.versioned()) {
                if (writeExpression != null) {
                    throw new SdkClientException("A transactional write operation may not also specify a condition expression if a versioned attribute is present on the model of the item.");
                }
                Object fieldValue = dynamoDBMapperFieldModel.get(objectToWrite);
                versionAttributeConditionExpressionGenerator.appendVersionAttributeToConditionExpression(dynamoDBMapperFieldModel, fieldValue);
                currentValue = dynamoDBMapperFieldModel.convert(dynamoDBMapperFieldModel.generate(dynamoDBMapperFieldModel.get(objectToWrite)));
                inMemoryUpdates.add(new ValueUpdate(dynamoDBMapperFieldModel, (AttributeValue)currentValue, objectToWrite));
            } else if (DynamoDBMapper.canGenerate(model, objectToWrite, DynamoDBMapperConfig.SaveBehavior.CLOBBER, dynamoDBMapperFieldModel)) {
                currentValue = dynamoDBMapperFieldModel.convert(dynamoDBMapperFieldModel.generate(dynamoDBMapperFieldModel.get(objectToWrite)));
                inMemoryUpdates.add(new ValueUpdate(dynamoDBMapperFieldModel, (AttributeValue)currentValue, objectToWrite));
            } else {
                currentValue = dynamoDBMapperFieldModel.convert(dynamoDBMapperFieldModel.get(objectToWrite));
            }
            if (currentValue == null && dynamoDBMapperFieldModel.keyType() != null) {
                throw new DynamoDBMappingException(clazz.getSimpleName() + "[" + dynamoDBMapperFieldModel.name() + "]; null or empty value for primary key");
            }
            if (currentValue == null) continue;
            attributeValues.put(dynamoDBMapperFieldModel.name(), (AttributeValue)currentValue);
        }
        DynamoDBTransactionWriteExpression versionAttributeConditionExpression = versionAttributeConditionExpressionGenerator.getVersionAttributeConditionExpression();
        if (versionAttributeConditionExpression.getConditionExpression() != null) {
            writeExpression = versionAttributeConditionExpression;
        }
        AttributeTransformer.Parameters<?> parameters = this.toParameters(attributeValues, clazz, tableName, config);
        Map<String, AttributeValue> attributeValueMap = this.transformAttributes(parameters);
        TransactWriteItem transactWriteItem = new TransactWriteItem();
        switch (operationType) {
            case Put: {
                transactWriteItem.setPut(this.generatePut(tableName, attributeValueMap, returnValuesOnConditionCheckFailure, writeExpression));
                break;
            }
            case Update: {
                transactWriteItem.setUpdate(this.generateUpdate(model, tableName, attributeValueMap, returnValuesOnConditionCheckFailure, writeExpression));
                break;
            }
            case ConditionCheck: {
                transactWriteItem.setConditionCheck(this.generateConditionCheck(model, tableName, objectToWrite, returnValuesOnConditionCheckFailure, writeExpression));
                break;
            }
            case Delete: {
                transactWriteItem.setDelete(this.generateDelete(model, tableName, objectToWrite, returnValuesOnConditionCheckFailure, writeExpression));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operationType: " + (Object)((Object)operationType) + " for object: " + model.convertKey(objectToWrite) + " of type: " + clazz);
            }
        }
        return transactWriteItem;
    }

    private Put generatePut(String tableName, Map<String, AttributeValue> attributeValueMap, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure, DynamoDBTransactionWriteExpression writeExpression) {
        Put put = new Put();
        put.setItem(attributeValueMap);
        put.setTableName(tableName);
        if (returnValuesOnConditionCheckFailure != null) {
            put.setReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure.toString());
        }
        if (writeExpression != null) {
            if (writeExpression.getConditionExpression() != null) {
                put.setConditionExpression(writeExpression.getConditionExpression());
            }
            if (!DynamoDBMapper.isNullOrEmpty(writeExpression.getExpressionAttributeNames())) {
                put.setExpressionAttributeNames(writeExpression.getExpressionAttributeNames());
            }
            if (!DynamoDBMapper.isNullOrEmpty(writeExpression.getExpressionAttributeValues())) {
                put.setExpressionAttributeValues(writeExpression.getExpressionAttributeValues());
            }
        }
        return put;
    }

    private Update generateUpdate(DynamoDBMapperTableModel<Object> model, String tableName, Map<String, AttributeValue> attributeValueMap, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure, DynamoDBTransactionWriteExpression writeExpression) {
        Update update = new Update();
        HashMap<String, String> expressionAttributeNamesMap = new HashMap<String, String>();
        HashMap<String, AttributeValue> expressionsAttributeValuesMap = new HashMap<String, AttributeValue>();
        if (returnValuesOnConditionCheckFailure != null) {
            update.setReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure.toString());
        }
        if (writeExpression != null) {
            if (writeExpression.getConditionExpression() != null) {
                update.setConditionExpression(writeExpression.getConditionExpression());
            }
            if (!DynamoDBMapper.isNullOrEmpty(writeExpression.getExpressionAttributeNames())) {
                expressionAttributeNamesMap.putAll(writeExpression.getExpressionAttributeNames());
            }
            if (!DynamoDBMapper.isNullOrEmpty(writeExpression.getExpressionAttributeValues())) {
                expressionsAttributeValuesMap.putAll(writeExpression.getExpressionAttributeValues());
            }
        }
        HashMap<String, AttributeValue> keyAttributeValueMap = new HashMap<String, AttributeValue>();
        HashMap<String, AttributeValue> nonKeyNonNullAttributeValueMap = new HashMap<String, AttributeValue>(attributeValueMap);
        ArrayList<String> nullValuedNonKeyAttributeNames = new ArrayList<String>();
        for (DynamoDBMapperFieldModel<Object, Object> field : model.fields()) {
            if (field.keyType() != null) {
                keyAttributeValueMap.put(field.name(), (AttributeValue)nonKeyNonNullAttributeValueMap.remove(field.name()));
                continue;
            }
            if (nonKeyNonNullAttributeValueMap.get(field.name()) != null) continue;
            nullValuedNonKeyAttributeNames.add(field.name());
            nonKeyNonNullAttributeValueMap.remove(field.name());
        }
        Iterator iterator = nonKeyNonNullAttributeValueMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (nonKeyNonNullAttributeValueMap.get(key) != null) continue;
            nullValuedNonKeyAttributeNames.add(key);
            iterator.remove();
        }
        update.setTableName(tableName);
        update.setUpdateExpression(new UpdateExpressionGenerator().generateUpdateExpressionAndUpdateAttributeMaps(expressionAttributeNamesMap, expressionsAttributeValuesMap, nonKeyNonNullAttributeValueMap, nullValuedNonKeyAttributeNames));
        update.setKey(keyAttributeValueMap);
        if (expressionAttributeNamesMap.size() > 0) {
            update.setExpressionAttributeNames(expressionAttributeNamesMap);
        }
        if (expressionsAttributeValuesMap.size() > 0) {
            update.setExpressionAttributeValues(expressionsAttributeValuesMap);
        }
        return update;
    }

    private ConditionCheck generateConditionCheck(DynamoDBMapperTableModel<Object> model, String tableName, Object objectToConditionCheck, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure, DynamoDBTransactionWriteExpression writeExpression) {
        ConditionCheck conditionCheck = new ConditionCheck();
        conditionCheck.setKey(model.convertKey(objectToConditionCheck));
        conditionCheck.setTableName(tableName);
        if (returnValuesOnConditionCheckFailure != null) {
            conditionCheck.setReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure.toString());
        }
        if (writeExpression != null) {
            conditionCheck.setConditionExpression(writeExpression.getConditionExpression());
            if (!DynamoDBMapper.isNullOrEmpty(writeExpression.getExpressionAttributeNames())) {
                conditionCheck.setExpressionAttributeNames(writeExpression.getExpressionAttributeNames());
            }
            if (!DynamoDBMapper.isNullOrEmpty(writeExpression.getExpressionAttributeValues())) {
                conditionCheck.setExpressionAttributeValues(writeExpression.getExpressionAttributeValues());
            }
        }
        return conditionCheck;
    }

    private Delete generateDelete(DynamoDBMapperTableModel<Object> model, String tableName, Object objectToDelete, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure, DynamoDBTransactionWriteExpression writeExpression) {
        Delete delete = new Delete();
        delete.setKey(model.convertKey(objectToDelete));
        delete.setTableName(tableName);
        if (returnValuesOnConditionCheckFailure != null) {
            delete.setReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure.toString());
        }
        if (writeExpression != null) {
            if (writeExpression.getConditionExpression() != null) {
                delete.setConditionExpression(writeExpression.getConditionExpression());
            }
            if (!DynamoDBMapper.isNullOrEmpty(writeExpression.getExpressionAttributeNames())) {
                delete.setExpressionAttributeNames(writeExpression.getExpressionAttributeNames());
            }
            if (!DynamoDBMapper.isNullOrEmpty(writeExpression.getExpressionAttributeValues())) {
                delete.setExpressionAttributeValues(writeExpression.getExpressionAttributeValues());
            }
        }
        return delete;
    }

    public static final class BatchGetItemException
    extends SdkClientException {
        private final Map<String, KeysAndAttributes> unprocessedKeys;
        private final Map<String, List<Object>> responses;

        public BatchGetItemException(String message, Map<String, KeysAndAttributes> unprocessedKeys, Map<String, List<Object>> responses) {
            super(message);
            this.unprocessedKeys = unprocessedKeys;
            this.responses = responses;
        }

        public Map<String, KeysAndAttributes> getUnprocessedKeys() {
            return this.unprocessedKeys;
        }

        public Map<String, List<Object>> getResponses() {
            return this.responses;
        }
    }

    static final class StringListMap<T>
    extends LinkedHashMap<String, List<T>> {
        private static final long serialVersionUID = -1L;

        StringListMap() {
        }

        public List<T> getPutIfNotExists(String key) {
            LinkedList list = (LinkedList)this.get(key);
            if (list == null) {
                list = new LinkedList();
                this.put(key, list);
            }
            return list;
        }

        public boolean add(String key, T value) {
            return this.getPutIfNotExists(key).add(value);
        }

        public List<StringListMap<T>> subMaps(int size, boolean perMap) {
            LinkedList<StringListMap<T>> maps = new LinkedList<StringListMap<T>>();
            int index = 0;
            int count = 0;
            for (Map.Entry entry : this.entrySet()) {
                for (Object value : (List)entry.getValue()) {
                    if (index == maps.size()) {
                        maps.add(new StringListMap<T>());
                    }
                    maps.get(index).add((String)entry.getKey(), value);
                    index = perMap ? ++count / size : ++index % size;
                }
            }
            return maps;
        }
    }

    public static class FailedBatch {
        private Map<String, List<WriteRequest>> unprocessedItems;
        private Exception exception;

        public void setUnprocessedItems(Map<String, List<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = unprocessedItems;
        }

        public Map<String, List<WriteRequest>> getUnprocessedItems() {
            return this.unprocessedItems;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        private final boolean isRequestEntityTooLarge() {
            return this.exception instanceof AmazonServiceException && RetryUtils.isRequestEntityTooLargeException((AmazonServiceException)this.exception);
        }

        private final boolean isThrottling() {
            return this.exception instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)this.exception);
        }

        private final int size() {
            int size = 0;
            for (List<WriteRequest> values : this.unprocessedItems.values()) {
                size += values.size();
            }
            return size;
        }
    }

    private static class TransformerParameters<T>
    implements AttributeTransformer.Parameters<T> {
        private final DynamoDBMapperTableModel<T> model;
        private final Map<String, AttributeValue> attributeValues;
        private final boolean partialUpdate;
        private final Class<T> modelClass;
        private final DynamoDBMapperConfig mapperConfig;
        private final String tableName;

        public TransformerParameters(DynamoDBMapperTableModel<T> model, Map<String, AttributeValue> attributeValues, boolean partialUpdate, Class<T> modelClass, DynamoDBMapperConfig mapperConfig, String tableName) {
            this.model = model;
            this.attributeValues = Collections.unmodifiableMap(attributeValues);
            this.partialUpdate = partialUpdate;
            this.modelClass = modelClass;
            this.mapperConfig = mapperConfig;
            this.tableName = tableName;
        }

        @Override
        public Map<String, AttributeValue> getAttributeValues() {
            return this.attributeValues;
        }

        @Override
        public boolean isPartialUpdate() {
            return this.partialUpdate;
        }

        @Override
        public Class<T> getModelClass() {
            return this.modelClass;
        }

        @Override
        public DynamoDBMapperConfig getMapperConfig() {
            return this.mapperConfig;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public String getHashKeyName() {
            return this.model.hashKey().name();
        }

        @Override
        public String getRangeKeyName() {
            return this.model.rangeKeyIfExists() == null ? null : this.model.rangeKey().name();
        }
    }

    private final class ValueUpdate {
        private final DynamoDBMapperFieldModel<Object, Object> field;
        private final AttributeValue newValue;
        private final Object target;

        public ValueUpdate(DynamoDBMapperFieldModel<Object, Object> field, AttributeValue newValue, Object target) {
            this.field = field;
            this.newValue = newValue;
            this.target = target;
        }

        public void apply() {
            this.field.set(this.target, this.field.unconvert(this.newValue));
        }
    }

    protected abstract class SaveObjectHandler {
        protected final Object object;
        protected final Class<?> clazz;
        private final String tableName;
        private final DynamoDBMapperConfig saveConfig;
        private final Map<String, AttributeValue> primaryKeys;
        private final Map<String, AttributeValueUpdate> updateValues;
        private final Map<String, ExpectedAttributeValue> internalExpectedValueAssertions;
        protected final Map<String, ExpectedAttributeValue> userProvidedExpectedValueConditions;
        protected final String userProvidedConditionOperator;
        private final List<ValueUpdate> inMemoryUpdates;

        public SaveObjectHandler(Class<?> clazz, Object object, String tableName, DynamoDBMapperConfig saveConfig, DynamoDBSaveExpression saveExpression) {
            this.clazz = clazz;
            this.object = object;
            this.tableName = tableName;
            this.saveConfig = saveConfig;
            if (saveExpression != null) {
                this.userProvidedExpectedValueConditions = saveExpression.getExpected();
                this.userProvidedConditionOperator = saveExpression.getConditionalOperator();
            } else {
                this.userProvidedExpectedValueConditions = null;
                this.userProvidedConditionOperator = null;
            }
            this.updateValues = new HashMap<String, AttributeValueUpdate>();
            this.internalExpectedValueAssertions = new HashMap<String, ExpectedAttributeValue>();
            this.inMemoryUpdates = new LinkedList<ValueUpdate>();
            this.primaryKeys = new HashMap<String, AttributeValue>();
        }

        public void execute() {
            DynamoDBMapperTableModel<?> model = DynamoDBMapper.this.getTableModel(this.clazz, this.saveConfig);
            for (DynamoDBMapperFieldModel<Object, Object> dynamoDBMapperFieldModel : model.fields()) {
                if (DynamoDBMapper.canGenerate(model, this.object, this.getLocalSaveBehavior(), dynamoDBMapperFieldModel)) {
                    if (dynamoDBMapperFieldModel.keyType() != null || dynamoDBMapperFieldModel.indexed()) {
                        this.onAutoGenerateAssignableKey(dynamoDBMapperFieldModel);
                        continue;
                    }
                    if (dynamoDBMapperFieldModel.versioned()) {
                        this.onVersionAttribute(dynamoDBMapperFieldModel);
                        continue;
                    }
                    this.onAutoGenerate(dynamoDBMapperFieldModel);
                    continue;
                }
                if (dynamoDBMapperFieldModel.keyType() != null) {
                    Object newAttributeValue = dynamoDBMapperFieldModel.convert(dynamoDBMapperFieldModel.get(this.object));
                    if (newAttributeValue == null) {
                        throw new DynamoDBMappingException(this.clazz.getSimpleName() + "[" + dynamoDBMapperFieldModel.name() + "]; null or empty value for primary key");
                    }
                    this.onPrimaryKeyAttributeValue(dynamoDBMapperFieldModel.name(), (AttributeValue)newAttributeValue);
                    continue;
                }
                Object currentValue = dynamoDBMapperFieldModel.convert(dynamoDBMapperFieldModel.get(this.object));
                if (currentValue != null) {
                    this.onNonKeyAttribute(dynamoDBMapperFieldModel.name(), (AttributeValue)currentValue);
                    continue;
                }
                this.onNullNonKeyAttribute(dynamoDBMapperFieldModel.name());
            }
            this.executeLowLevelRequest();
            for (ValueUpdate valueUpdate : this.inMemoryUpdates) {
                valueUpdate.apply();
            }
        }

        protected abstract void onPrimaryKeyAttributeValue(String var1, AttributeValue var2);

        protected void onNonKeyAttribute(String attributeName, AttributeValue currentValue) {
            this.updateValues.put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("PUT"));
        }

        protected abstract void onNullNonKeyAttribute(String var1);

        protected abstract void executeLowLevelRequest();

        protected DynamoDBMapperConfig.SaveBehavior getLocalSaveBehavior() {
            return this.saveConfig.getSaveBehavior();
        }

        protected String getTableName() {
            return this.tableName;
        }

        protected Map<String, AttributeValue> getPrimaryKeyAttributeValues() {
            return this.primaryKeys;
        }

        protected Map<String, AttributeValueUpdate> getAttributeValueUpdates() {
            return this.updateValues;
        }

        protected Map<String, ExpectedAttributeValue> mergeExpectedAttributeValueConditions() {
            return DynamoDBMapper.mergeExpectedAttributeValueConditions(this.internalExpectedValueAssertions, this.userProvidedExpectedValueConditions, this.userProvidedConditionOperator);
        }

        protected List<ValueUpdate> getInMemoryUpdates() {
            return this.inMemoryUpdates;
        }

        protected UpdateItemResult doUpdateItem() {
            UpdateItemRequest req = (UpdateItemRequest)new UpdateItemRequest().withTableName(this.getTableName()).withKey(this.getPrimaryKeyAttributeValues()).withAttributeUpdates(this.transformAttributeUpdates(this.clazz, this.getTableName(), this.getPrimaryKeyAttributeValues(), this.getAttributeValueUpdates(), this.saveConfig)).withExpected(this.mergeExpectedAttributeValueConditions()).withConditionalOperator(this.userProvidedConditionOperator).withReturnValues(ReturnValue.ALL_NEW).withRequestMetricCollector(this.saveConfig.getRequestMetricCollector());
            return DynamoDBMapper.this.db.updateItem(DynamoDBMapper.applyUserAgent(req));
        }

        protected PutItemResult doPutItem() {
            Map attributeValues = this.convertToItem(this.getAttributeValueUpdates());
            attributeValues = DynamoDBMapper.this.transformAttributes(DynamoDBMapper.this.toParameters(attributeValues, this.clazz, this.getTableName(), this.saveConfig));
            PutItemRequest req = (PutItemRequest)new PutItemRequest().withTableName(this.getTableName()).withItem(attributeValues).withExpected(this.mergeExpectedAttributeValueConditions()).withConditionalOperator(this.userProvidedConditionOperator).withRequestMetricCollector(this.saveConfig.getRequestMetricCollector());
            return DynamoDBMapper.this.db.putItem(DynamoDBMapper.applyUserAgent(req));
        }

        private void onAutoGenerate(DynamoDBMapperFieldModel<Object, Object> field) {
            Object value = field.convert(field.generate(field.get(this.object)));
            this.updateValues.put(field.name(), new AttributeValueUpdate().withAction("PUT").withValue((AttributeValue)value));
            this.inMemoryUpdates.add(new ValueUpdate(field, (AttributeValue)value, this.object));
        }

        private void onAutoGenerateAssignableKey(DynamoDBMapperFieldModel<Object, Object> field) {
            this.onAutoGenerate(field);
            if (this.getLocalSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER && !this.internalExpectedValueAssertions.containsKey(field.name()) && field.getGenerateStrategy() != DynamoDBAutoGenerateStrategy.ALWAYS) {
                this.internalExpectedValueAssertions.put(field.name(), new ExpectedAttributeValue().withExists(false));
            }
        }

        private void onVersionAttribute(DynamoDBMapperFieldModel<Object, Object> field) {
            if (this.getLocalSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER && !this.internalExpectedValueAssertions.containsKey(field.name())) {
                Object current = field.get(this.object);
                if (current == null) {
                    this.internalExpectedValueAssertions.put(field.name(), new ExpectedAttributeValue().withExists(false));
                } else {
                    this.internalExpectedValueAssertions.put(field.name(), new ExpectedAttributeValue().withExists(true).withValue((AttributeValue)field.convert(current)));
                }
            }
            this.onAutoGenerate(field);
        }

        private Map<String, AttributeValue> convertToItem(Map<String, AttributeValueUpdate> putValues) {
            HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
            for (Map.Entry<String, AttributeValueUpdate> entry : putValues.entrySet()) {
                String attributeName = entry.getKey();
                AttributeValue attributeValue = entry.getValue().getValue();
                String attributeAction = entry.getValue().getAction();
                if (attributeValue == null || AttributeAction.DELETE.toString().equals(attributeAction)) continue;
                map.put(attributeName, attributeValue);
            }
            return map;
        }

        private Map<String, AttributeValueUpdate> transformAttributeUpdates(Class<?> clazz, String tableName, Map<String, AttributeValue> keys, Map<String, AttributeValueUpdate> updateValues, DynamoDBMapperConfig config) {
            Map item = this.convertToItem(updateValues);
            HashSet<String> keysAdded = new HashSet<String>();
            for (Map.Entry<String, AttributeValue> e : keys.entrySet()) {
                if (item.containsKey(e.getKey())) continue;
                keysAdded.add(e.getKey());
                item.put((String)e.getKey(), (AttributeValue)e.getValue());
            }
            AttributeTransformer.Parameters parameters = DynamoDBMapper.this.toParameters(item, true, clazz, tableName, config);
            String hashKey = parameters.getHashKeyName();
            if (!item.containsKey(hashKey)) {
                item.put(hashKey, keys.get(hashKey));
            }
            item = DynamoDBMapper.this.transformAttributes(parameters);
            for (Map.Entry entry : item.entrySet()) {
                if (keysAdded.contains(entry.getKey())) continue;
                AttributeValueUpdate update = updateValues.get(entry.getKey());
                if (update != null) {
                    update.getValue().withB(((AttributeValue)entry.getValue()).getB()).withBS(((AttributeValue)entry.getValue()).getBS()).withN(((AttributeValue)entry.getValue()).getN()).withNS(((AttributeValue)entry.getValue()).getNS()).withS(((AttributeValue)entry.getValue()).getS()).withSS(((AttributeValue)entry.getValue()).getSS()).withM(((AttributeValue)entry.getValue()).getM()).withL(((AttributeValue)entry.getValue()).getL()).withNULL(((AttributeValue)entry.getValue()).getNULL()).withBOOL(((AttributeValue)entry.getValue()).getBOOL());
                    continue;
                }
                updateValues.put((String)entry.getKey(), new AttributeValueUpdate((AttributeValue)entry.getValue(), "PUT"));
            }
            return updateValues;
        }
    }
}

