/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.LowLevelResultListener;
import com.amazonaws.services.dynamodbv2.document.internal.PageBasedCollection;
import com.amazonaws.services.dynamodbv2.document.internal.PageIterable;
import com.amazonaws.services.dynamodbv2.model.Capacity;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.util.HashMap;
import java.util.Map;

public abstract class ItemCollection<R>
extends PageBasedCollection<Item, R> {
    private int accumulatedItemCount;
    private int accumulatedScannedCount;
    private ConsumedCapacity accumulatedConsumedCapacity;

    protected final void accumulateStats(ConsumedCapacity consumedCapacity, Integer count, Integer scannedCount) {
        if (consumedCapacity != null) {
            if (this.accumulatedConsumedCapacity == null) {
                this.accumulatedConsumedCapacity = new ConsumedCapacity();
                this.accumulatedConsumedCapacity.setCapacityUnits(consumedCapacity.getCapacityUnits());
                this.accumulatedConsumedCapacity.setGlobalSecondaryIndexes(this.clone(consumedCapacity.getGlobalSecondaryIndexes()));
                this.accumulatedConsumedCapacity.setLocalSecondaryIndexes(this.clone(consumedCapacity.getLocalSecondaryIndexes()));
                this.accumulatedConsumedCapacity.setTable(this.clone(consumedCapacity.getTable()));
                this.accumulatedConsumedCapacity.setTableName(consumedCapacity.getTableName());
            } else {
                Double capunit = this.accumulatedConsumedCapacity.getCapacityUnits();
                Double delta = consumedCapacity.getCapacityUnits();
                if (capunit == null) {
                    this.accumulatedConsumedCapacity.setCapacityUnits(delta);
                } else {
                    this.accumulatedConsumedCapacity.setCapacityUnits(capunit + (delta == null ? 0.0 : delta));
                }
                Map<String, Capacity> gsi = this.accumulatedConsumedCapacity.getGlobalSecondaryIndexes();
                if (gsi == null) {
                    this.accumulatedConsumedCapacity.setGlobalSecondaryIndexes(this.clone(consumedCapacity.getGlobalSecondaryIndexes()));
                } else {
                    this.accumulatedConsumedCapacity.setGlobalSecondaryIndexes(this.add(consumedCapacity.getGlobalSecondaryIndexes(), this.accumulatedConsumedCapacity.getGlobalSecondaryIndexes()));
                }
                Map<String, Capacity> lsi = this.accumulatedConsumedCapacity.getLocalSecondaryIndexes();
                if (lsi == null) {
                    this.accumulatedConsumedCapacity.setLocalSecondaryIndexes(this.clone(consumedCapacity.getLocalSecondaryIndexes()));
                } else {
                    this.accumulatedConsumedCapacity.setLocalSecondaryIndexes(this.add(consumedCapacity.getLocalSecondaryIndexes(), this.accumulatedConsumedCapacity.getLocalSecondaryIndexes()));
                }
                Capacity tableCapacity = this.accumulatedConsumedCapacity.getTable();
                if (tableCapacity == null) {
                    this.accumulatedConsumedCapacity.setTable(this.clone(consumedCapacity.getTable()));
                } else {
                    this.accumulatedConsumedCapacity.setTable(this.add(consumedCapacity.getTable(), this.accumulatedConsumedCapacity.getTable()));
                }
            }
        }
        if (count != null) {
            this.accumulatedItemCount += count.intValue();
        }
        if (scannedCount != null) {
            this.accumulatedScannedCount += scannedCount.intValue();
        }
    }

    private Map<String, Capacity> add(Map<String, Capacity> from, Map<String, Capacity> to) {
        if (to == null) {
            return this.clone(from);
        }
        if (from != null) {
            for (Map.Entry<String, Capacity> entryFrom : from.entrySet()) {
                String key = entryFrom.getKey();
                Capacity tocap = to.get(key);
                Capacity fromcap = entryFrom.getValue();
                if (tocap == null) {
                    to.put(key, this.clone(fromcap));
                    continue;
                }
                to.put(key, new Capacity().withCapacityUnits(this.doubleOf(tocap) + this.doubleOf(fromcap)));
            }
        }
        return to;
    }

    private Capacity add(Capacity from, Capacity to) {
        return new Capacity().withCapacityUnits(this.doubleOf(from) + this.doubleOf(to));
    }

    private Map<String, Capacity> clone(Map<String, Capacity> capacityMap) {
        if (capacityMap == null) {
            return null;
        }
        HashMap<String, Capacity> clone = new HashMap<String, Capacity>(capacityMap.size());
        for (Map.Entry<String, Capacity> e : capacityMap.entrySet()) {
            clone.put(e.getKey(), this.clone(e.getValue()));
        }
        return clone;
    }

    private Capacity clone(Capacity capacity) {
        return capacity == null ? null : new Capacity().withCapacityUnits(capacity.getCapacityUnits());
    }

    private double doubleOf(Capacity cap) {
        if (cap == null) {
            return 0.0;
        }
        Double val2 = cap.getCapacityUnits();
        return val2 == null ? 0.0 : val2;
    }

    @Deprecated
    public int getTotalCount() {
        return this.getAccumulatedItemCount();
    }

    public int getAccumulatedItemCount() {
        return this.accumulatedItemCount;
    }

    @Deprecated
    public int getTotalScannedCount() {
        return this.getAccumulatedScannedCount();
    }

    public int getAccumulatedScannedCount() {
        return this.accumulatedScannedCount;
    }

    @Deprecated
    public ConsumedCapacity getTotalConsumedCapacity() {
        return this.getAccumulatedConsumedCapacity();
    }

    public ConsumedCapacity getAccumulatedConsumedCapacity() {
        return this.accumulatedConsumedCapacity;
    }

    @Override
    public PageIterable<Item, R> pages() {
        return super.pages();
    }

    @Override
    public abstract Integer getMaxResultSize();

    @Override
    public R getLastLowLevelResult() {
        return super.getLastLowLevelResult();
    }

    @Override
    public LowLevelResultListener<R> registerLowLevelResultListener(LowLevelResultListener<R> listener) {
        return super.registerLowLevelResultListener(listener);
    }
}

