/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.utils;

import com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazonaws.services.dynamodbv2.document.utils.FluentArrayList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValueList
extends FluentArrayList<Object> {
    private static final long serialVersionUID = 1L;

    public ValueList(int initialCapacity) {
        super(initialCapacity);
    }

    public ValueList(Object ... elements) {
        super(elements);
    }

    public ValueList() {
    }

    public ValueList(Collection<?> c) {
        super(c);
    }

    public ValueList appendAll(Object ... elements) {
        super.appendAll(elements);
        return this;
    }

    public ValueList appendString(String val2) {
        super.append(val2);
        return this;
    }

    public ValueList appendNumber(BigDecimal val2) {
        super.append(val2);
        return this;
    }

    public ValueList appendNumber(Number val2) {
        super.append(InternalUtils.toBigDecimal(val2));
        return this;
    }

    public ValueList appendInt(int val2) {
        return this.appendNumber(val2);
    }

    public ValueList appendLong(long val2) {
        return this.appendNumber(val2);
    }

    public ValueList appendBinary(byte[] val2) {
        super.append(val2);
        return this;
    }

    public ValueList appendStringSet(Set<String> val2) {
        super.append(val2);
        return this;
    }

    public ValueList appendStringSet(String ... val2) {
        super.append(new LinkedHashSet<String>(Arrays.asList(val2)));
        return this;
    }

    public ValueList appendNumberSet(Set<BigDecimal> val2) {
        super.append(val2);
        return this;
    }

    public ValueList appendNumberSet(BigDecimal ... val2) {
        super.append(new LinkedHashSet<BigDecimal>(Arrays.asList(val2)));
        return this;
    }

    public ValueList appendNumberSet(Number ... val2) {
        super.append(InternalUtils.toBigDecimalSet(val2));
        return this;
    }

    public ValueList appendBinarySet(Set<byte[]> val2) {
        super.append(val2);
        return this;
    }

    public ValueList appendBinarySet(byte[] ... val2) {
        super.append(new LinkedHashSet(Arrays.asList(val2)));
        return this;
    }

    public ValueList appendList(List<?> val2) {
        super.append(new ArrayList(val2));
        return this;
    }

    public ValueList appendList(Object ... vals) {
        super.append(new ArrayList<Object>(Arrays.asList(vals)));
        return this;
    }

    public ValueList appendMap(Map<String, ?> val2) {
        super.append(val2);
        return this;
    }

    public ValueList appendBoolean(boolean val2) {
        super.append(val2);
        return this;
    }

    public ValueList appendNull() {
        super.append(null);
        return this;
    }

    public ValueList append(Object val2) {
        if (val2 == this) {
            throw new IllegalArgumentException("Self reference is not allowed");
        }
        super.append(val2);
        return this;
    }
}

