/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.utils;

import com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazonaws.services.dynamodbv2.document.internal.ItemValueConformer;
import com.amazonaws.services.dynamodbv2.document.utils.FluentHashMap;
import com.amazonaws.util.json.Jackson;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValueMap
extends FluentHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final ItemValueConformer valueConformer = new ItemValueConformer();

    public ValueMap withString(String key, String val2) {
        super.put(key, val2);
        return this;
    }

    public ValueMap withNumber(String key, BigDecimal val2) {
        super.put(key, val2);
        return this;
    }

    public ValueMap withNumber(String key, Number val2) {
        super.put(key, InternalUtils.toBigDecimal(val2));
        return this;
    }

    public ValueMap withInt(String key, int val2) {
        return this.withNumber(key, val2);
    }

    public ValueMap withLong(String key, long val2) {
        return this.withNumber(key, val2);
    }

    public ValueMap withBinary(String key, byte[] val2) {
        super.put(key, val2);
        return this;
    }

    public ValueMap withStringSet(String key, Set<String> val2) {
        super.put(key, val2);
        return this;
    }

    public ValueMap withStringSet(String key, String ... val2) {
        super.put(key, new LinkedHashSet<String>(Arrays.asList(val2)));
        return this;
    }

    public ValueMap withNumberSet(String key, Set<BigDecimal> val2) {
        super.put(key, val2);
        return this;
    }

    public ValueMap withNumberSet(String key, BigDecimal ... val2) {
        super.put(key, new LinkedHashSet<BigDecimal>(Arrays.asList(val2)));
        return this;
    }

    public ValueMap withNumberSet(String key, Number ... val2) {
        super.put(key, InternalUtils.toBigDecimalSet(val2));
        return this;
    }

    public ValueMap withBinarySet(String key, Set<byte[]> val2) {
        super.put(key, val2);
        return this;
    }

    public ValueMap withBinarySet(String key, byte[] ... val2) {
        super.put(key, new LinkedHashSet(Arrays.asList(val2)));
        return this;
    }

    public ValueMap withList(String key, List<?> val2) {
        super.put(key, val2 == null ? null : new ArrayList(val2));
        return this;
    }

    public ValueMap withList(String key, Object ... vals) {
        super.put(key, vals == null ? null : new ArrayList<Object>(Arrays.asList(vals)));
        return this;
    }

    public ValueMap withMap(String key, Map<String, ?> val2) {
        super.put(key, val2);
        return this;
    }

    public ValueMap withBoolean(String key, boolean val2) {
        super.put(key, val2);
        return this;
    }

    public ValueMap withNull(String key) {
        super.put(key, null);
        return this;
    }

    public ValueMap withJSON(String key, String jsonValue) {
        super.put(key, valueConformer.transform(Jackson.fromJsonString(jsonValue, Object.class)));
        return this;
    }

    public ValueMap with(String key, Object val2) {
        if (val2 == this) {
            throw new IllegalArgumentException("Self reference is not allowed");
        }
        super.put(key, val2);
        return this;
    }
}

