/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.xspec;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.services.dynamodbv2.xspec.ArrayIndexElement;
import com.amazonaws.services.dynamodbv2.xspec.NamedElement;
import com.amazonaws.services.dynamodbv2.xspec.PathElement;
import com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;
import com.amazonaws.services.dynamodbv2.xspec.UnitOfExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

@Immutable
final class Path
extends UnitOfExpression {
    private final List<PathElement> elements;

    Path(String path) {
        this.elements = this.parse(path);
    }

    private List<PathElement> parse(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        String[] split2 = path.split(Pattern.quote("."));
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        for (String element : split2) {
            int index = element.indexOf(91);
            if (index == -1) {
                elements.add(new NamedElement(element));
                continue;
            }
            if (index == 0) {
                throw new IllegalArgumentException("Bogus path: " + path);
            }
            elements.add(new NamedElement(element.substring(0, index)));
            do {
                if ((index = (element = element.substring(index + 1)).indexOf(93)) == -1) {
                    throw new IllegalArgumentException("Bogus path: " + path);
                }
                int arrayIndex = Integer.parseInt(element.substring(0, index));
                elements.add(new ArrayIndexElement(arrayIndex));
                element = element.substring(index + 1);
                index = element.indexOf(91);
                if (index <= 0) continue;
                throw new IllegalArgumentException("Bogus path: " + path);
            } while (index != -1);
            if (element.isEmpty()) continue;
            throw new IllegalArgumentException("Bogus path: " + path);
        }
        return elements;
    }

    @Override
    String asSubstituted(SubstitutionContext context) {
        StringBuffer sb = new StringBuffer();
        for (PathElement e : this.elements) {
            if (sb.length() == 0) {
                sb.append(e.asToken(context));
                continue;
            }
            sb.append(e.asNestedToken(context));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (PathElement e : this.elements) {
            if (sb.length() == 0) {
                sb.append(e.toString());
                continue;
            }
            sb.append(e.asNestedPath());
        }
        return sb.toString();
    }

    List<PathElement> getElements() {
        return this.elements;
    }
}

