/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper;

import com.google.common.base.Strings;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import io.gitbub.devlibx.easy.helper.string.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHttpServer {
    private static final Logger log = LoggerFactory.getLogger(LocalHttpServer.class);
    public volatile int port;
    private volatile boolean keepRunning;
    private final CountDownLatch waitForServerStartLatch = new CountDownLatch(1);
    private final CountDownLatch waitForServerStopLatch = new CountDownLatch(1);

    public static void main(String[] args) {
        LocalHttpServer localHttpServer = new LocalHttpServer();
        localHttpServer.startServer();
    }

    public void stopServer() {
        this.keepRunning = false;
        try {
            this.waitForServerStopLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void startServerInThread() {
        new Thread(this::startServer).start();
        try {
            this.waitForServerStartLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void startServer() {
        HttpServer server = null;
        this.port = 9123;
        while (this.port < 9130) {
            try {
                server = HttpServer.create(new InetSocketAddress(this.port), 0);
                log.debug("Using port={} for test server", (Object)this.port);
                break;
            }
            catch (Exception e) {
                log.debug("Port= {} is not free, try next", (Object)this.port);
                ++this.port;
            }
        }
        if (server == null) {
            throw new RuntimeException("Could not run http server");
        }
        server.createContext("/delay", new DelayHttpHandler());
        server.start();
        this.waitForServerStartLatch.countDown();
        log.trace("HTTP Server at port {} started", (Object)this.port);
        this.keepRunning = true;
        while (this.keepRunning) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        server.stop(1);
        log.trace("HTTP Server at port {} stopped", (Object)this.port);
        this.waitForServerStopLatch.countDown();
    }

    public static Map<String, String> splitQuery(String query) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return query_pairs;
    }

    private static class DelayHttpHandler
    implements HttpHandler {
        private DelayHttpHandler() {
        }

        @Override
        public void handle(HttpExchange t) {
            try (OutputStream os = t.getResponseBody();
                 InputStream in = t.getRequestBody();){
                Map<String, String> qp = LocalHttpServer.splitQuery(t.getRequestURI().getQuery());
                int sleep = Integer.parseInt(qp.get("delay"));
                log.debug("HTTP Request - {} # Sleep for {} ms", (Object)t.getRequestURI(), (Object)sleep);
                if (sleep > 0) {
                    Thread.sleep(sleep);
                }
                String requestBody = null;
                try {
                    requestBody = IOUtils.toString(in, Charset.defaultCharset());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Headers headers = t.getRequestHeaders();
                String headerString = null;
                if (headers != null) {
                    HashMap h2 = new HashMap();
                    headers.forEach(h2::put);
                    headerString = JsonUtils.asJson(h2);
                }
                String response = null;
                if ("GET".equals(t.getRequestMethod())) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("method", "get");
                    data.put("data", "some data");
                    if (!Strings.isNullOrEmpty(requestBody)) {
                        data.put("request_body", requestBody);
                    }
                    if (!Strings.isNullOrEmpty(headerString)) {
                        data.put("headers", headerString);
                    }
                    data.putAll(qp);
                    response = new StringHelper().stringify(data);
                } else if ("POST".equals(t.getRequestMethod())) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("method", "post");
                    data.put("data", "some data");
                    if (!Strings.isNullOrEmpty(requestBody)) {
                        data.put("request_body", requestBody);
                    }
                    if (!Strings.isNullOrEmpty(headerString)) {
                        data.put("headers", headerString);
                    }
                    data.putAll(qp);
                    response = new StringHelper().stringify(data);
                } else if ("PUT".equals(t.getRequestMethod())) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("method", "put");
                    data.put("data", "some data");
                    if (!Strings.isNullOrEmpty(requestBody)) {
                        data.put("request_body", requestBody);
                    }
                    if (!Strings.isNullOrEmpty(headerString)) {
                        data.put("headers", headerString);
                    }
                    data.putAll(qp);
                    response = new StringHelper().stringify(data);
                } else if ("DELETE".equals(t.getRequestMethod())) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("method", "delete");
                    data.put("data", "some data");
                    if (!Strings.isNullOrEmpty(requestBody)) {
                        data.put("request_body", requestBody);
                    }
                    if (!Strings.isNullOrEmpty(headerString)) {
                        data.put("headers", headerString);
                    }
                    data.putAll(qp);
                    response = new StringHelper().stringify(data);
                }
                if (qp.containsKey("status")) {
                    t.sendResponseHeaders(Integer.parseInt(qp.get("status")), response.length());
                } else {
                    t.sendResponseHeaders(200, response.length());
                }
                t.getResponseHeaders().add("Content-Type", "application/json");
                os.write(response.getBytes());
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    log.error("Got some IOException error in http server");
                }
                log.error("Got some error in http server : {}", (Object)e.getMessage());
            }
        }
    }
}

