/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelThread {
    private static final Logger log = LoggerFactory.getLogger(ParallelThread.class);
    private final int count;
    private final String name;

    public ParallelThread(int count, String name) {
        this.count = count;
        this.name = name;
    }

    public void execute(Runnable runnable) {
        CountDownLatch sync = new CountDownLatch(this.count);
        CountDownLatch waitForAllToComplete = new CountDownLatch(this.count);
        AtomicBoolean b = new AtomicBoolean();
        for (int i = 0; i < this.count; ++i) {
            new Thread(() -> {
                sync.countDown();
                try {
                    sync.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    AtomicBoolean atomicBoolean = b;
                    synchronized (atomicBoolean) {
                        if (!b.get()) {
                            log.info("({}) all {} threads started to make a burst calls", (Object)this.name, (Object)this.count);
                        }
                        b.set(true);
                    }
                }
                finally {
                    AtomicBoolean atomicBoolean = b;
                    synchronized (atomicBoolean) {
                        if (!b.get()) {
                            log.info("({}) all {} threads started to make a burst calls", (Object)this.name, (Object)this.count);
                        }
                        b.set(true);
                    }
                }
                try {
                    runnable.run();
                }
                finally {
                    waitForAllToComplete.countDown();
                }
            }).start();
        }
        try {
            waitForAllToComplete.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getCount() {
        return this.count;
    }
}

