/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.calendar;

import io.gitbub.devlibx.easy.helper.calendar.KeyGenerator;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class CalendarMap<T> {
    private Map<String, T> data = new HashMap<String, T>();

    public CalendarMap(DateTime from, int days) {
        KeyGenerator keyGenerator = new KeyGenerator();
        keyGenerator.generateKeyForLastNDaysFrom(from, days).forEach(key -> this.data.put((String)key, (T)null));
    }

    public CalendarMap(int days) {
        this(DateTime.now(), days);
    }

    public static <T> CalendarMap<T> forThisMonth(Class<T> cls) {
        DateTime time = DateTime.now();
        return CalendarMap.forMonth(time, cls);
    }

    public static <T> CalendarMap<T> forMonth(DateTime time, Class<T> cls) {
        return new CalendarMap<T>(time, time.getDayOfMonth());
    }

    public void executeForKey(String key, Callback<T> processFunc) {
        if (this.data.containsKey(key)) {
            processFunc.process(key, this.data.get(key), false);
        } else {
            processFunc.process(key, null, true);
        }
    }

    public void executeForKey(KeyGenerator.IKeyFunc keyFunc, DateTime time, Callback<T> processFunc) {
        String key = keyFunc.generate(time);
        if (this.data.containsKey(key)) {
            T t = processFunc.process(key, this.data.get(key), false);
            this.data.put(key, t);
        } else {
            processFunc.process(key, null, true);
        }
    }

    public void executeForKey(DateTime time, Callback<T> processFunc) {
        KeyGenerator.IKeyFunc keyFunc = new KeyGenerator.IKeyFunc(){

            @Override
            public String generate(DateTime time) {
                return KeyGenerator.IKeyFunc.super.generate(time);
            }
        };
        this.executeForKey(keyFunc, time, processFunc);
    }

    public synchronized void executeForAll(Callback<T> processFunc) {
        HashMap newData = new HashMap();
        this.data.forEach((key, value) -> {
            Object t = processFunc.process((String)key, (Object)value, false);
            newData.put((String)key, (Object)t);
        });
        this.data = newData;
    }

    public T getDataByKey(String key) {
        return this.data.getOrDefault(key, null);
    }

    public T getDataByTime(DateTime time) {
        KeyGenerator.IKeyFunc keyFunc = new KeyGenerator.IKeyFunc(){

            @Override
            public String generate(DateTime time) {
                return KeyGenerator.IKeyFunc.super.generate(time);
            }
        };
        String key = keyFunc.generate(time);
        return this.getDataByKey(key);
    }

    public boolean add(String key, T t) {
        if (this.data.containsKey(key)) {
            this.data.put(key, t);
            return true;
        }
        return false;
    }

    public boolean add(DateTime time, T t) {
        KeyGenerator.IKeyFunc keyFunc = new KeyGenerator.IKeyFunc(){

            @Override
            public String generate(DateTime time) {
                return KeyGenerator.IKeyFunc.super.generate(time);
            }
        };
        String key = keyFunc.generate(time);
        return this.add(key, t);
    }

    public Map<String, T> getData() {
        return this.data;
    }

    public static interface Callback<T> {
        public T process(String var1, T var2, boolean var3);
    }
}

