/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.calendar;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class KeyGenerator {
    public List<String> generateKeyForLastNDaysFrom(DateTime from, int days) {
        return this.generateKeyForLastNDaysFrom(from, days, new IKeyFunc(){

            @Override
            public String generate(DateTime time) {
                return IKeyFunc.super.generate(time);
            }
        });
    }

    public List<String> generateKeyForLastNDaysFrom(DateTime from, int days, IKeyFunc keyFunc) {
        ArrayList<String> keys = new ArrayList<String>();
        DateTime to = from.minusDays(days);
        while (to.isBefore(from)) {
            to = to.plusDays(1);
            keys.add(keyFunc.generate(to));
        }
        return keys;
    }

    public static interface IKeyFunc {
        default public String generate(DateTime time) {
            int month = time.getMonthOfYear();
            int day = time.getDayOfMonth();
            return month + "-" + day;
        }
    }
}

