/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.file;

import io.gitbub.devlibx.easy.helper.yaml.YamlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);

    public static InputStream readStream(String file) {
        log.info("Reading file=[{}] from path={}", (Object)file, (Object)Thread.currentThread().getContextClassLoader().getResource(file));
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
    }

    public static String read(String file) {
        try {
            log.info("Reading file=[{}] from path={}", (Object)file, (Object)Thread.currentThread().getContextClassLoader().getResource(file));
            return IOUtils.toString(FileHelper.readStream(file), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFileFromResourcePath(String file) {
        try {
            InputStream in = YamlUtils.class.getResourceAsStream(file);
            if (in != null) {
                return IOUtils.toString(in, Charset.defaultCharset());
            }
            throw new RuntimeException("did not find file=" + file + " in resources");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

