/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.map;

import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;

public class StringObjectMap
extends HashMap<String, Object> {
    public static StringObjectMap from(Map<String, Object> map) {
        StringObjectMap extendedMap = new StringObjectMap();
        if (map != null) {
            extendedMap.putAll(map);
        }
        return extendedMap;
    }

    public <T> T get(String key, Class<T> cls) {
        return (T)this.get(key);
    }

    public Integer getInt(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new RuntimeException("Value with key " + key + " is not a integer");
    }

    public Integer getInt(String key, int defaultValue) {
        Integer value = this.getInt(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Long getLong(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new RuntimeException("Value with key " + key + " is not a long");
    }

    public Float getFloat(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        throw new RuntimeException("Value with key " + key + " is not a float");
    }

    public Double getDouble(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new RuntimeException("Value with key " + key + " is not a double");
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new RuntimeException("Value with key " + key + " is not a boolean");
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean value = this.getBoolean(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public UUID getUUID(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return UUID.fromString((String)value);
        }
        throw new RuntimeException("Value with key " + key + " is not a uuid");
    }

    public <T> List<T> getList(String key, Class<T> cls) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof String) {
            return JsonUtils.readList((String)value, cls);
        }
        throw new RuntimeException("Value with key " + key + " is not a uuid");
    }

    public void put(String key, Object value, String key1, Object value1) {
        this.put(key, value);
        this.put(key1, value1);
    }

    public void put(String key, Object value, String key1, Object value1, String key2, Object value2) {
        this.put(key, value);
        this.put(key1, value1);
        this.put(key2, value2);
    }

    public void put(String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        this.put(key, value);
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
    }

    public void put(String key, Object value, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        this.put(key, value);
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key3, value4);
    }

    public <T> T get(String key1, String key2, Class<T> cls) {
        StringObjectMap subMap = this.getStringObjectMap(key1);
        if (subMap == null) {
            return null;
        }
        return subMap.get(key2, cls);
    }

    public <T> T get(String key1, String key2, String key3, Class<T> cls) {
        StringObjectMap subMap = this.getStringObjectMap(key1);
        if (subMap == null) {
            return null;
        }
        StringObjectMap subMap1 = subMap.getStringObjectMap(key2);
        return subMap1 == null ? null : (T)subMap1.get(key3, cls);
    }

    public <T> T get(String key1, String key2, String key3, String key4, Class<T> cls) {
        StringObjectMap subMap = this.getStringObjectMap(key1);
        if (subMap == null) {
            return null;
        }
        StringObjectMap subMap1 = subMap.getStringObjectMap(key2);
        if (subMap1 == null) {
            return null;
        }
        StringObjectMap subMap2 = subMap1.getStringObjectMap(key3);
        return subMap2 == null ? null : (T)subMap2.get(key4, cls);
    }

    public DateTime getDateTimeFromMiles(String key1) {
        Object result = this.get(key1);
        if (result == null) {
            return null;
        }
        if (result instanceof DateTime) {
            return (DateTime)result;
        }
        if (result instanceof Date) {
            return new DateTime((Date)result);
        }
        if (result instanceof Number) {
            DateTime eventTime = new DateTime(((Number)result).longValue());
            return new DateTime(eventTime);
        }
        if (result instanceof String) {
            long val2 = Long.parseLong((String)result);
            DateTime eventTime = new DateTime(val2);
            return new DateTime(eventTime);
        }
        return null;
    }

    public DateTime getDateTimeFromMiles(String key1, String key2) {
        StringObjectMap subMap = this.getStringObjectMap(key1);
        if (subMap == null) {
            return null;
        }
        return subMap.getDateTimeFromMiles(key2);
    }

    public DateTime getDateTimeFromMiles(String key1, String key2, String key3) {
        StringObjectMap subMap = this.getStringObjectMap(key1);
        if (subMap == null) {
            return null;
        }
        StringObjectMap subMap1 = subMap.getStringObjectMap(key2);
        if (subMap1 == null) {
            return null;
        }
        return subMap1.getDateTimeFromMiles(key3);
    }

    public DateTime getDateTimeFromMilesOrNow(String key1) {
        return this.getDateTimeFromMilesOrDefault(key1, DateTime.now());
    }

    public DateTime getDateTimeFromMilesOrNow(String key1, String key2) {
        return this.getDateTimeFromMilesOrDefault(key1, key2, DateTime.now());
    }

    public DateTime getDateTimeFromMilesOrNow(String key1, String key2, String key3) {
        return this.getDateTimeFromMilesOrDefault(key1, key2, key3, DateTime.now());
    }

    public DateTime getDateTimeFromMilesOrDefault(String key1, DateTime defaultValue) {
        DateTime t = this.getDateTimeFromMiles(key1);
        return t == null ? defaultValue : t;
    }

    public DateTime getDateTimeFromMilesOrDefault(String key1, String key2, DateTime defaultValue) {
        DateTime t = this.getDateTimeFromMiles(key1, key2);
        return t == null ? defaultValue : t;
    }

    public DateTime getDateTimeFromMilesOrDefault(String key1, String key2, String key3, DateTime defaultValue) {
        DateTime t = this.getDateTimeFromMiles(key1, key2, key3);
        return t == null ? defaultValue : t;
    }

    public StringObjectMap getStringObjectMap(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof StringObjectMap) {
            return (StringObjectMap)value;
        }
        if (value instanceof Map) {
            StringObjectMap map = new StringObjectMap();
            map.putAll((Map)value);
            return map;
        }
        return null;
    }

    public <K, V> Map<K, V> getMap(String key, Class<K> kClass, Class<V> vClass) {
        return (Map)this.get(key);
    }

    public <K, V> Map<K, V> getMap(String key, String key1, Class<K> kClass, Class<V> vClass) {
        return this.get(key, key1, Map.class);
    }

    public static StringObjectMap of(String key, Object value) {
        StringObjectMap map = new StringObjectMap();
        map.put(key, value);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7, String key8, Object value8) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        map.put(key8, value8);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7, String key8, Object value8, String key9, Object value9) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        map.put(key8, value8);
        map.put(key9, value9);
        return map;
    }

    public static StringObjectMap of(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7, String key8, Object value8, String key9, Object value9, String key10, Object value10) {
        StringObjectMap map = new StringObjectMap();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        map.put(key8, value8);
        map.put(key9, value9);
        map.put(key10, value10);
        return map;
    }

    public <T> T path(String separator, String key, Class<T> cls) {
        if (separator.equals(".")) {
            separator = "\\.";
        }
        StringObjectMap map = this;
        String[] tokens = key.split(separator);
        int len = tokens.length;
        for (int i = 0; i < len - 1; ++i) {
            if ((map = map.getStringObjectMap(tokens[i])) != null) continue;
            return null;
        }
        return map.get(tokens[len - 1], cls);
    }

    public <T> T path(String key, Class<T> cls) {
        return this.path(".", key, cls);
    }

    public boolean isPathValueEqual(String key, Object value) {
        return Objects.equals(this.path(".", key, Object.class), value);
    }

    public boolean isPathValueTrue(String key) {
        return Objects.equals(this.path(".", key, Boolean.class), true);
    }

    public boolean isPathValueFalse(String key) {
        return Objects.equals(this.path(".", key, Boolean.class), false);
    }
}

