/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.metrics;

import com.google.inject.ImplementedBy;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementedBy(value=NoOpMetrics.class)
public interface IMetrics {
    public <T> T getRegistry(Class<T> var1);

    public void inc(String var1, String ... var2);

    default public void inc(String name, long count, String ... labels) {
        this.inc(name, labels);
    }

    public <T> T time(String var1, Callable<T> var2, String ... var3);

    default public void observe(String name, double amt) {
    }

    default public void observe(String name, double amt, String ... labelNames) {
    }

    public void registerCounter(String var1, String var2, String ... var3);

    public void registerTimer(String var1, String var2, String ... var3);

    public static class InvalidRegistryTypeFoundException
    extends RuntimeException {
        public InvalidRegistryTypeFoundException(String message) {
            super(message);
        }
    }

    public static class MetricsLogger {
        public void printf(String format, Object ... args) {
            System.out.printf(format, args);
        }
    }

    public static class NoOpMetricsLogger
    implements IMetricsLogger {
        @Override
        public void printf(String format, Object ... args) {
        }
    }

    public static interface IMetricsLogger {
        public void printf(String var1, Object ... var2);
    }

    public static class ConsoleOutputMetrics
    implements IMetrics {
        private static final Logger log = LoggerFactory.getLogger(ConsoleOutputMetrics.class);

        @Override
        public <T> T getRegistry(Class<T> cls) {
            return null;
        }

        @Override
        public void inc(String name, String ... labels) {
            log.debug("increment metrics={}", (Object)name);
        }

        @Override
        public <T> T time(String name, Callable<T> callable, String ... labels) {
            long start = System.currentTimeMillis();
            try {
                T t = callable.call();
                return t;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                log.debug("time taken by metrics={} is {}", (Object)name, (Object)(System.currentTimeMillis() - start));
            }
        }

        @Override
        public void observe(String name, double amt) {
            log.debug("time taken by metrics={} is {}", (Object)name, (Object)amt);
        }

        @Override
        public void registerCounter(String name, String help, String ... labelNames) {
        }

        @Override
        public void registerTimer(String name, String help, String ... labelNames) {
        }
    }

    public static class NoOpMetrics
    implements IMetrics {
        @Override
        public <T> T getRegistry(Class<T> cls) {
            return null;
        }

        @Override
        public void inc(String name, String ... labels) {
        }

        @Override
        public <T> T time(String name, Callable<T> callable, String ... labels) {
            try {
                return callable.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void registerCounter(String name, String help, String ... labelNames) {
        }

        @Override
        public void registerTimer(String name, String help, String ... labelNames) {
        }
    }
}

