/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.pid;

public class MiniPID {
    private double P = 0.0;
    private double I = 0.0;
    private double D = 0.0;
    private double F = 0.0;
    private double maxIOutput = 0.0;
    private double maxError = 0.0;
    private double errorSum = 0.0;
    private double maxOutput = 0.0;
    private double minOutput = 0.0;
    private double setpoint = 0.0;
    private double lastActual = 0.0;
    private boolean firstRun = true;
    private boolean reversed = false;
    private double outputRampRate = 0.0;
    private double lastOutput = 0.0;
    private double outputFilter = 0.0;
    private double setpointRange = 0.0;

    public MiniPID(double p, double i, double d) {
        this.P = p;
        this.I = i;
        this.D = d;
        this.checkSigns();
    }

    public MiniPID(double p, double i, double d, double f) {
        this.P = p;
        this.I = i;
        this.D = d;
        this.F = f;
        this.checkSigns();
    }

    public void setP(double p) {
        this.P = p;
        this.checkSigns();
    }

    public void setI(double i) {
        if (this.I != 0.0) {
            this.errorSum = this.errorSum * this.I / i;
        }
        if (this.maxIOutput != 0.0) {
            this.maxError = this.maxIOutput / i;
        }
        this.I = i;
        this.checkSigns();
    }

    public void setD(double d) {
        this.D = d;
        this.checkSigns();
    }

    public void setF(double f) {
        this.F = f;
        this.checkSigns();
    }

    public void setPID(double p, double i, double d) {
        this.P = p;
        this.D = d;
        this.setI(i);
        this.checkSigns();
    }

    public void setPID(double p, double i, double d, double f) {
        this.P = p;
        this.D = d;
        this.F = f;
        this.setI(i);
        this.checkSigns();
    }

    public void setMaxIOutput(double maximum) {
        this.maxIOutput = maximum;
        if (this.I != 0.0) {
            this.maxError = this.maxIOutput / this.I;
        }
    }

    public void setOutputLimits(double output) {
        this.setOutputLimits(-output, output);
    }

    public void setOutputLimits(double minimum, double maximum) {
        if (maximum < minimum) {
            return;
        }
        this.maxOutput = maximum;
        this.minOutput = minimum;
        if (this.maxIOutput == 0.0 || this.maxIOutput > maximum - minimum) {
            this.setMaxIOutput(maximum - minimum);
        }
    }

    public void setDirection(boolean reversed) {
        this.reversed = reversed;
    }

    public void setSetpoint(double setpoint) {
        this.setpoint = setpoint;
    }

    public double getOutput(double actual, double setpoint) {
        this.setpoint = setpoint;
        if (this.setpointRange != 0.0) {
            setpoint = this.constrain(setpoint, actual - this.setpointRange, actual + this.setpointRange);
        }
        double error = setpoint - actual;
        double Foutput = this.F * setpoint;
        double Poutput = this.P * error;
        if (this.firstRun) {
            this.lastActual = actual;
            this.lastOutput = Poutput + Foutput;
            this.firstRun = false;
        }
        double Doutput = -this.D * (actual - this.lastActual);
        this.lastActual = actual;
        double Ioutput = this.I * this.errorSum;
        if (this.maxIOutput != 0.0) {
            Ioutput = this.constrain(Ioutput, -this.maxIOutput, this.maxIOutput);
        }
        double output = Foutput + Poutput + Ioutput + Doutput;
        this.errorSum = this.minOutput != this.maxOutput && !this.bounded(output, this.minOutput, this.maxOutput) ? error : (this.outputRampRate != 0.0 && !this.bounded(output, this.lastOutput - this.outputRampRate, this.lastOutput + this.outputRampRate) ? error : (this.maxIOutput != 0.0 ? this.constrain(this.errorSum + error, -this.maxError, this.maxError) : (this.errorSum += error)));
        if (this.outputRampRate != 0.0) {
            output = this.constrain(output, this.lastOutput - this.outputRampRate, this.lastOutput + this.outputRampRate);
        }
        if (this.minOutput != this.maxOutput) {
            output = this.constrain(output, this.minOutput, this.maxOutput);
        }
        if (this.outputFilter != 0.0) {
            output = this.lastOutput * this.outputFilter + output * (1.0 - this.outputFilter);
        }
        this.lastOutput = output;
        return output;
    }

    public double getOutput() {
        return this.getOutput(this.lastActual, this.setpoint);
    }

    public double getOutput(double actual) {
        return this.getOutput(actual, this.setpoint);
    }

    public void reset() {
        this.firstRun = true;
        this.errorSum = 0.0;
    }

    public void setOutputRampRate(double rate) {
        this.outputRampRate = rate;
    }

    public void setSetpointRange(double range) {
        this.setpointRange = range;
    }

    public void setOutputFilter(double strength) {
        if (strength == 0.0 || this.bounded(strength, 0.0, 1.0)) {
            this.outputFilter = strength;
        }
    }

    private double constrain(double value, double min2, double max) {
        if (value > max) {
            return max;
        }
        if (value < min2) {
            return min2;
        }
        return value;
    }

    private boolean bounded(double value, double min2, double max) {
        return min2 < value && value < max;
    }

    private void checkSigns() {
        if (this.reversed) {
            if (this.P > 0.0) {
                this.P *= -1.0;
            }
            if (this.I > 0.0) {
                this.I *= -1.0;
            }
            if (this.D > 0.0) {
                this.D *= -1.0;
            }
            if (this.F > 0.0) {
                this.F *= -1.0;
            }
        } else {
            if (this.P < 0.0) {
                this.P *= -1.0;
            }
            if (this.I < 0.0) {
                this.I *= -1.0;
            }
            if (this.D < 0.0) {
                this.D *= -1.0;
            }
            if (this.F < 0.0) {
                this.F *= -1.0;
            }
        }
    }
}

