/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.queue;

import io.gitbub.devlibx.easy.helper.queue.IRateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.time.Duration;

public class DefaultRateLimiter
implements IRateLimiter {
    private final RateLimiter rateLimiter;

    public DefaultRateLimiter(IRateLimiter.Config c) {
        RateLimiterConfig config = RateLimiterConfig.custom().timeoutDuration(Duration.ofSeconds(c.waitTimeToAcquirePermissionToExecuteInMs <= 0 ? Integer.MAX_VALUE : (long)c.waitTimeToAcquirePermissionToExecuteInMs)).limitRefreshPeriod(Duration.ofMillis(c.timeToResetPermissionBackToInitialValueInMs <= 0 ? 1000L : (long)c.timeToResetPermissionBackToInitialValueInMs)).limitForPeriod(c.limit <= 0 ? 100 : c.limit).build();
        RateLimiterRegistry registry = RateLimiterRegistry.of(config);
        this.rateLimiter = registry.rateLimiter("default");
    }

    @Override
    public void execute(Runnable runnable) {
        this.rateLimiter.executeRunnable(runnable);
    }
}

