/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.yaml;

import io.gitbub.devlibx.easy.helper.file.FileHelper;
import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import io.gitbub.devlibx.easy.helper.string.StringHelper;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlUtils {
    public static <T> T readYamlFromString(String content, Class<T> cls) {
        Yaml yaml = new Yaml();
        Map obj = (Map)yaml.load(content);
        return JsonUtils.readObject(new StringHelper().stringify(obj), cls);
    }

    public static <T> T readYamlFromCamelCaseString(String content, Class<T> cls) {
        Yaml yaml = new Yaml();
        Map obj = (Map)yaml.load(content);
        return JsonUtils.getCamelCase().readObject(new StringHelper().stringify(obj), cls);
    }

    public static <T> T readYamlCamelCase(String file, Class<T> cls) {
        Yaml yaml = new Yaml();
        Map obj = (Map)yaml.load(FileHelper.readStream(file));
        return JsonUtils.getCamelCase().readObject(new StringHelper().stringify(obj), cls);
    }

    public static <T> T readYaml(String file, Class<T> cls) {
        Yaml yaml = new Yaml();
        Map obj = (Map)yaml.load(FileHelper.readStream(file));
        return JsonUtils.getCamelCase().readObject(new StringHelper().stringify(obj), cls);
    }

    public static <T> T readYamlFromResourcePath(String file, Class<T> cls) {
        try {
            String configAsString = FileHelper.readFileFromResourcePath(file);
            Yaml yaml = new Yaml();
            Map obj = (Map)yaml.load(configAsString);
            return JsonUtils.getCamelCase().readObject(new StringHelper().stringify(obj), cls);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

