/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.ratelimit;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.easy.ratelimit.IRateLimitJob;
import io.github.devlibx.easy.ratelimit.RateType;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RateLimiterConfig {
    private boolean enabled;
    private Redis redis;
    private String name;
    private String prefix;
    private RateType rateType;
    private int rate;
    private int rateInterval;
    private TimeUnit rateIntervalUnit;
    private StringObjectMap rateLimitJobConfig;
    private StringObjectMap properties;

    @JsonIgnore
    public Optional<IRateLimitJob> getRateLimitJob() {
        if (this.rateLimitJobConfig == null || Strings.isNullOrEmpty(this.rateLimitJobConfig.getString("rate-limit-class")) || !this.rateLimitJobConfig.getBoolean("enabled", true).booleanValue()) {
            return Optional.empty();
        }
        try {
            Class<?> rateLimitJobClass = Class.forName(this.rateLimitJobConfig.getString("rate-limit-class"));
            return Optional.of((IRateLimitJob)rateLimitJobClass.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static boolean $default$enabled() {
        return true;
    }

    private static Redis $default$redis() {
        return new Redis();
    }

    private static RateType $default$rateType() {
        return RateType.OVERALL;
    }

    private static int $default$rate() {
        return 100;
    }

    private static int $default$rateInterval() {
        return 1;
    }

    private static TimeUnit $default$rateIntervalUnit() {
        return TimeUnit.SECONDS;
    }

    private static StringObjectMap $default$rateLimitJobConfig() {
        return new StringObjectMap();
    }

    private static StringObjectMap $default$properties() {
        return new StringObjectMap();
    }

    public static RateLimiterConfigBuilder builder() {
        return new RateLimiterConfigBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Redis getRedis() {
        return this.redis;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public RateType getRateType() {
        return this.rateType;
    }

    public int getRate() {
        return this.rate;
    }

    public int getRateInterval() {
        return this.rateInterval;
    }

    public TimeUnit getRateIntervalUnit() {
        return this.rateIntervalUnit;
    }

    public StringObjectMap getRateLimitJobConfig() {
        return this.rateLimitJobConfig;
    }

    public StringObjectMap getProperties() {
        return this.properties;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRedis(Redis redis) {
        this.redis = redis;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setRateType(RateType rateType) {
        this.rateType = rateType;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public void setRateInterval(int rateInterval) {
        this.rateInterval = rateInterval;
    }

    public void setRateIntervalUnit(TimeUnit rateIntervalUnit) {
        this.rateIntervalUnit = rateIntervalUnit;
    }

    public void setRateLimitJobConfig(StringObjectMap rateLimitJobConfig) {
        this.rateLimitJobConfig = rateLimitJobConfig;
    }

    public void setProperties(StringObjectMap properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimiterConfig)) {
            return false;
        }
        RateLimiterConfig other = (RateLimiterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getRate() != other.getRate()) {
            return false;
        }
        if (this.getRateInterval() != other.getRateInterval()) {
            return false;
        }
        Redis this$redis = this.getRedis();
        Redis other$redis = other.getRedis();
        if (this$redis == null ? other$redis != null : !((Object)this$redis).equals(other$redis)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        RateType this$rateType = this.getRateType();
        RateType other$rateType = other.getRateType();
        if (this$rateType == null ? other$rateType != null : !((Object)((Object)this$rateType)).equals((Object)other$rateType)) {
            return false;
        }
        TimeUnit this$rateIntervalUnit = this.getRateIntervalUnit();
        TimeUnit other$rateIntervalUnit = other.getRateIntervalUnit();
        if (this$rateIntervalUnit == null ? other$rateIntervalUnit != null : !((Object)((Object)this$rateIntervalUnit)).equals((Object)other$rateIntervalUnit)) {
            return false;
        }
        StringObjectMap this$rateLimitJobConfig = this.getRateLimitJobConfig();
        StringObjectMap other$rateLimitJobConfig = other.getRateLimitJobConfig();
        if (this$rateLimitJobConfig == null ? other$rateLimitJobConfig != null : !((Object)this$rateLimitJobConfig).equals(other$rateLimitJobConfig)) {
            return false;
        }
        StringObjectMap this$properties = this.getProperties();
        StringObjectMap other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RateLimiterConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getRate();
        result = result * 59 + this.getRateInterval();
        Redis $redis = this.getRedis();
        result = result * 59 + ($redis == null ? 43 : ((Object)$redis).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        RateType $rateType = this.getRateType();
        result = result * 59 + ($rateType == null ? 43 : ((Object)((Object)$rateType)).hashCode());
        TimeUnit $rateIntervalUnit = this.getRateIntervalUnit();
        result = result * 59 + ($rateIntervalUnit == null ? 43 : ((Object)((Object)$rateIntervalUnit)).hashCode());
        StringObjectMap $rateLimitJobConfig = this.getRateLimitJobConfig();
        result = result * 59 + ($rateLimitJobConfig == null ? 43 : ((Object)$rateLimitJobConfig).hashCode());
        StringObjectMap $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "RateLimiterConfig(enabled=" + this.isEnabled() + ", redis=" + this.getRedis() + ", name=" + this.getName() + ", prefix=" + this.getPrefix() + ", rateType=" + this.getRateType() + ", rate=" + this.getRate() + ", rateInterval=" + this.getRateInterval() + ", rateIntervalUnit=" + this.getRateIntervalUnit() + ", rateLimitJobConfig=" + this.getRateLimitJobConfig() + ", properties=" + this.getProperties() + ")";
    }

    public RateLimiterConfig() {
        this.enabled = RateLimiterConfig.$default$enabled();
        this.redis = RateLimiterConfig.$default$redis();
        this.rateType = RateLimiterConfig.$default$rateType();
        this.rate = RateLimiterConfig.$default$rate();
        this.rateInterval = RateLimiterConfig.$default$rateInterval();
        this.rateIntervalUnit = RateLimiterConfig.$default$rateIntervalUnit();
        this.rateLimitJobConfig = RateLimiterConfig.$default$rateLimitJobConfig();
        this.properties = RateLimiterConfig.$default$properties();
    }

    public RateLimiterConfig(boolean enabled, Redis redis, String name, String prefix, RateType rateType, int rate, int rateInterval, TimeUnit rateIntervalUnit, StringObjectMap rateLimitJobConfig, StringObjectMap properties) {
        this.enabled = enabled;
        this.redis = redis;
        this.name = name;
        this.prefix = prefix;
        this.rateType = rateType;
        this.rate = rate;
        this.rateInterval = rateInterval;
        this.rateIntervalUnit = rateIntervalUnit;
        this.rateLimitJobConfig = rateLimitJobConfig;
        this.properties = properties;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Redis {
        private String version;
        private String host;
        private int port;
        private String strategy;
        private int timeout;
        @JsonProperty(value="connect_timeout")
        private int connectTimeout;
        @JsonProperty(value="idle_connection_timeout")
        private int idleConnectionTimeout;
        @JsonProperty(value="ping_connection_interval")
        private int pingConnectionInterval;

        @JsonIgnore
        public Config getRedissonConfig() {
            Config config = new Config();
            if (Objects.equals(this.strategy, "single-server")) {
                String redisAddress = String.format("redis://%s:%s", this.host, this.port);
                ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setTimeout(this.timeout)).setConnectTimeout(this.connectTimeout)).setIdleConnectionTimeout(this.idleConnectionTimeout)).setPingConnectionInterval(this.pingConnectionInterval)).setAddress(redisAddress);
            } else if (Objects.equals(this.strategy, "localhost")) {
                String redisAddress = String.format("redis://%s:%s", this.host, this.port);
                ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setTimeout(this.timeout)).setConnectTimeout(this.connectTimeout)).setIdleConnectionTimeout(this.idleConnectionTimeout)).setPingConnectionInterval(this.pingConnectionInterval)).setAddress(redisAddress);
            }
            return config;
        }

        @JsonIgnore
        public String uniqueKey() {
            return this.host + "-" + this.port;
        }

        private static String $default$version() {
            return "v1";
        }

        private static String $default$host() {
            return "localhost";
        }

        private static int $default$port() {
            return 6379;
        }

        private static String $default$strategy() {
            return "single-server";
        }

        private static int $default$timeout() {
            return 3000;
        }

        private static int $default$connectTimeout() {
            return 10000;
        }

        private static int $default$idleConnectionTimeout() {
            return 10000;
        }

        private static int $default$pingConnectionInterval() {
            return 30000;
        }

        public static RedisBuilder builder() {
            return new RedisBuilder();
        }

        public String getVersion() {
            return this.version;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public int getIdleConnectionTimeout() {
            return this.idleConnectionTimeout;
        }

        public int getPingConnectionInterval() {
            return this.pingConnectionInterval;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        @JsonProperty(value="connect_timeout")
        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        @JsonProperty(value="idle_connection_timeout")
        public void setIdleConnectionTimeout(int idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
        }

        @JsonProperty(value="ping_connection_interval")
        public void setPingConnectionInterval(int pingConnectionInterval) {
            this.pingConnectionInterval = pingConnectionInterval;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Redis)) {
                return false;
            }
            Redis other = (Redis)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getTimeout() != other.getTimeout()) {
                return false;
            }
            if (this.getConnectTimeout() != other.getConnectTimeout()) {
                return false;
            }
            if (this.getIdleConnectionTimeout() != other.getIdleConnectionTimeout()) {
                return false;
            }
            if (this.getPingConnectionInterval() != other.getPingConnectionInterval()) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$strategy = this.getStrategy();
            String other$strategy = other.getStrategy();
            return !(this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Redis;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            result = result * 59 + this.getTimeout();
            result = result * 59 + this.getConnectTimeout();
            result = result * 59 + this.getIdleConnectionTimeout();
            result = result * 59 + this.getPingConnectionInterval();
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $strategy = this.getStrategy();
            result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
            return result;
        }

        public String toString() {
            return "RateLimiterConfig.Redis(version=" + this.getVersion() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", strategy=" + this.getStrategy() + ", timeout=" + this.getTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ", idleConnectionTimeout=" + this.getIdleConnectionTimeout() + ", pingConnectionInterval=" + this.getPingConnectionInterval() + ")";
        }

        public Redis() {
            this.version = Redis.$default$version();
            this.host = Redis.$default$host();
            this.port = Redis.$default$port();
            this.strategy = Redis.$default$strategy();
            this.timeout = Redis.$default$timeout();
            this.connectTimeout = Redis.$default$connectTimeout();
            this.idleConnectionTimeout = Redis.$default$idleConnectionTimeout();
            this.pingConnectionInterval = Redis.$default$pingConnectionInterval();
        }

        public Redis(String version, String host, int port, String strategy, int timeout, int connectTimeout, int idleConnectionTimeout, int pingConnectionInterval) {
            this.version = version;
            this.host = host;
            this.port = port;
            this.strategy = strategy;
            this.timeout = timeout;
            this.connectTimeout = connectTimeout;
            this.idleConnectionTimeout = idleConnectionTimeout;
            this.pingConnectionInterval = pingConnectionInterval;
        }

        public static class RedisBuilder {
            private boolean version$set;
            private String version$value;
            private boolean host$set;
            private String host$value;
            private boolean port$set;
            private int port$value;
            private boolean strategy$set;
            private String strategy$value;
            private boolean timeout$set;
            private int timeout$value;
            private boolean connectTimeout$set;
            private int connectTimeout$value;
            private boolean idleConnectionTimeout$set;
            private int idleConnectionTimeout$value;
            private boolean pingConnectionInterval$set;
            private int pingConnectionInterval$value;

            RedisBuilder() {
            }

            public RedisBuilder version(String version) {
                this.version$value = version;
                this.version$set = true;
                return this;
            }

            public RedisBuilder host(String host) {
                this.host$value = host;
                this.host$set = true;
                return this;
            }

            public RedisBuilder port(int port) {
                this.port$value = port;
                this.port$set = true;
                return this;
            }

            public RedisBuilder strategy(String strategy) {
                this.strategy$value = strategy;
                this.strategy$set = true;
                return this;
            }

            public RedisBuilder timeout(int timeout) {
                this.timeout$value = timeout;
                this.timeout$set = true;
                return this;
            }

            @JsonProperty(value="connect_timeout")
            public RedisBuilder connectTimeout(int connectTimeout) {
                this.connectTimeout$value = connectTimeout;
                this.connectTimeout$set = true;
                return this;
            }

            @JsonProperty(value="idle_connection_timeout")
            public RedisBuilder idleConnectionTimeout(int idleConnectionTimeout) {
                this.idleConnectionTimeout$value = idleConnectionTimeout;
                this.idleConnectionTimeout$set = true;
                return this;
            }

            @JsonProperty(value="ping_connection_interval")
            public RedisBuilder pingConnectionInterval(int pingConnectionInterval) {
                this.pingConnectionInterval$value = pingConnectionInterval;
                this.pingConnectionInterval$set = true;
                return this;
            }

            public Redis build() {
                String version$value = this.version$value;
                if (!this.version$set) {
                    version$value = Redis.$default$version();
                }
                String host$value = this.host$value;
                if (!this.host$set) {
                    host$value = Redis.$default$host();
                }
                int port$value = this.port$value;
                if (!this.port$set) {
                    port$value = Redis.$default$port();
                }
                String strategy$value = this.strategy$value;
                if (!this.strategy$set) {
                    strategy$value = Redis.$default$strategy();
                }
                int timeout$value = this.timeout$value;
                if (!this.timeout$set) {
                    timeout$value = Redis.$default$timeout();
                }
                int connectTimeout$value = this.connectTimeout$value;
                if (!this.connectTimeout$set) {
                    connectTimeout$value = Redis.$default$connectTimeout();
                }
                int idleConnectionTimeout$value = this.idleConnectionTimeout$value;
                if (!this.idleConnectionTimeout$set) {
                    idleConnectionTimeout$value = Redis.$default$idleConnectionTimeout();
                }
                int pingConnectionInterval$value = this.pingConnectionInterval$value;
                if (!this.pingConnectionInterval$set) {
                    pingConnectionInterval$value = Redis.$default$pingConnectionInterval();
                }
                return new Redis(version$value, host$value, port$value, strategy$value, timeout$value, connectTimeout$value, idleConnectionTimeout$value, pingConnectionInterval$value);
            }

            public String toString() {
                return "RateLimiterConfig.Redis.RedisBuilder(version$value=" + this.version$value + ", host$value=" + this.host$value + ", port$value=" + this.port$value + ", strategy$value=" + this.strategy$value + ", timeout$value=" + this.timeout$value + ", connectTimeout$value=" + this.connectTimeout$value + ", idleConnectionTimeout$value=" + this.idleConnectionTimeout$value + ", pingConnectionInterval$value=" + this.pingConnectionInterval$value + ")";
            }
        }
    }

    public static class RateLimiterConfigBuilder {
        private boolean enabled$set;
        private boolean enabled$value;
        private boolean redis$set;
        private Redis redis$value;
        private String name;
        private String prefix;
        private boolean rateType$set;
        private RateType rateType$value;
        private boolean rate$set;
        private int rate$value;
        private boolean rateInterval$set;
        private int rateInterval$value;
        private boolean rateIntervalUnit$set;
        private TimeUnit rateIntervalUnit$value;
        private boolean rateLimitJobConfig$set;
        private StringObjectMap rateLimitJobConfig$value;
        private boolean properties$set;
        private StringObjectMap properties$value;

        RateLimiterConfigBuilder() {
        }

        public RateLimiterConfigBuilder enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        public RateLimiterConfigBuilder redis(Redis redis) {
            this.redis$value = redis;
            this.redis$set = true;
            return this;
        }

        public RateLimiterConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RateLimiterConfigBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public RateLimiterConfigBuilder rateType(RateType rateType) {
            this.rateType$value = rateType;
            this.rateType$set = true;
            return this;
        }

        public RateLimiterConfigBuilder rate(int rate) {
            this.rate$value = rate;
            this.rate$set = true;
            return this;
        }

        public RateLimiterConfigBuilder rateInterval(int rateInterval) {
            this.rateInterval$value = rateInterval;
            this.rateInterval$set = true;
            return this;
        }

        public RateLimiterConfigBuilder rateIntervalUnit(TimeUnit rateIntervalUnit) {
            this.rateIntervalUnit$value = rateIntervalUnit;
            this.rateIntervalUnit$set = true;
            return this;
        }

        public RateLimiterConfigBuilder rateLimitJobConfig(StringObjectMap rateLimitJobConfig) {
            this.rateLimitJobConfig$value = rateLimitJobConfig;
            this.rateLimitJobConfig$set = true;
            return this;
        }

        public RateLimiterConfigBuilder properties(StringObjectMap properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        public RateLimiterConfig build() {
            boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = RateLimiterConfig.$default$enabled();
            }
            Redis redis$value = this.redis$value;
            if (!this.redis$set) {
                redis$value = RateLimiterConfig.$default$redis();
            }
            RateType rateType$value = this.rateType$value;
            if (!this.rateType$set) {
                rateType$value = RateLimiterConfig.$default$rateType();
            }
            int rate$value = this.rate$value;
            if (!this.rate$set) {
                rate$value = RateLimiterConfig.$default$rate();
            }
            int rateInterval$value = this.rateInterval$value;
            if (!this.rateInterval$set) {
                rateInterval$value = RateLimiterConfig.$default$rateInterval();
            }
            TimeUnit rateIntervalUnit$value = this.rateIntervalUnit$value;
            if (!this.rateIntervalUnit$set) {
                rateIntervalUnit$value = RateLimiterConfig.$default$rateIntervalUnit();
            }
            StringObjectMap rateLimitJobConfig$value = this.rateLimitJobConfig$value;
            if (!this.rateLimitJobConfig$set) {
                rateLimitJobConfig$value = RateLimiterConfig.$default$rateLimitJobConfig();
            }
            StringObjectMap properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = RateLimiterConfig.$default$properties();
            }
            return new RateLimiterConfig(enabled$value, redis$value, this.name, this.prefix, rateType$value, rate$value, rateInterval$value, rateIntervalUnit$value, rateLimitJobConfig$value, properties$value);
        }

        public String toString() {
            return "RateLimiterConfig.RateLimiterConfigBuilder(enabled$value=" + this.enabled$value + ", redis$value=" + this.redis$value + ", name=" + this.name + ", prefix=" + this.prefix + ", rateType$value=" + this.rateType$value + ", rate$value=" + this.rate$value + ", rateInterval$value=" + this.rateInterval$value + ", rateIntervalUnit$value=" + this.rateIntervalUnit$value + ", rateLimitJobConfig$value=" + this.rateLimitJobConfig$value + ", properties$value=" + this.properties$value + ")";
        }
    }
}

