/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.ratelimit.impl;

import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.Safe;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.github.devlibx.easy.ratelimit.IRateLimiter;
import io.github.devlibx.easy.ratelimit.IRateLimiterFactory;
import io.github.devlibx.easy.ratelimit.RateLimiterConfig;
import io.github.devlibx.easy.ratelimit.RateLimiterFactoryConfig;
import io.github.devlibx.easy.ratelimit.redis.RedisBasedRateLimiter;
import io.github.devlibx.easy.ratelimit.redis.RedisBasedRateLimiterV2;
import io.github.devlibx.easy.ratelimit.redis.RedisBasedRateLimiterV3;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class RateLimiterFactory
implements IRateLimiterFactory {
    private final RateLimiterFactoryConfig rateLimiterFactoryConfig;
    private final IMetrics metrics;
    private final Map<String, IRateLimiter> rateLimiterMap;

    @Inject
    public RateLimiterFactory(RateLimiterFactoryConfig rateLimiterFactoryConfig, IMetrics metrics) {
        this.rateLimiterFactoryConfig = rateLimiterFactoryConfig;
        this.metrics = metrics;
        this.rateLimiterMap = new HashMap<String, IRateLimiter>();
    }

    @Override
    public void start() {
        if (this.rateLimiterFactoryConfig.isEnabled()) {
            this.rateLimiterFactoryConfig.getRateLimiters().forEach((name, rateLimiterConfig) -> {
                IRateLimiter rateLimiter;
                rateLimiterConfig.setName((String)name);
                if (Strings.isNullOrEmpty(rateLimiterConfig.getPrefix())) {
                    rateLimiterConfig.setPrefix(this.rateLimiterFactoryConfig.getPrefix());
                }
                if (rateLimiterConfig.getRedis() != null) {
                    rateLimiter = Objects.equals(rateLimiterConfig.getRedis().getVersion(), "v2") ? new RedisBasedRateLimiterV2((RateLimiterConfig)rateLimiterConfig, this.metrics) : (Objects.equals(rateLimiterConfig.getRedis().getVersion(), "v3") ? new RedisBasedRateLimiterV3((RateLimiterConfig)rateLimiterConfig, this.metrics) : new RedisBasedRateLimiter((RateLimiterConfig)rateLimiterConfig, this.metrics));
                    rateLimiter.start();
                    boolean result = false;
                    int count = 3;
                    while (count-- >= 0 && !result) {
                        result = rateLimiter.trySetRate(rateLimiterConfig.getRate());
                    }
                } else {
                    throw new RuntimeException("Only redis type is support for rate limit");
                }
                this.rateLimiterMap.put((String)name, rateLimiter);
            });
        }
    }

    @Override
    public void stop() {
        Safe.safe(() -> this.rateLimiterMap.forEach((name, rateLimiter) -> Safe.safe(rateLimiter::stop, "failed to stop rate limiter: " + name)));
    }

    @Override
    public Optional<IRateLimiter> get(String name) {
        if (this.rateLimiterMap.containsKey(name)) {
            return Optional.ofNullable(this.rateLimiterMap.get(name));
        }
        return Optional.empty();
    }
}

