/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.ratelimit.job.ddb;

import ch.qos.logback.classic.Level;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.LoggingHelper;
import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.gitbub.devlibx.easy.helper.yaml.YamlUtils;
import io.github.devlibx.easy.ratelimit.IRateLimiter;
import io.github.devlibx.easy.ratelimit.IRateLimiterFactory;
import io.github.devlibx.easy.ratelimit.RateLimiterFactoryConfig;
import io.github.devlibx.easy.ratelimit.impl.RateLimiterFactory;
import io.github.devlibx.easy.ratelimit.job.ddb.DynamoDbWriteRateLimitJob;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public class DoNotUseExample {
    public static void main(String[] args) throws Exception {
        LoggingHelper.setupLogging();
        LoggingHelper.getLogger(DynamoDbWriteRateLimitJob.class).setLevel(Level.DEBUG);
        String rateLimiterName = "example-config-normal";
        String testFilePath = args[0];
        String content = FileUtils.readFileToString(new File(testFilePath), Charset.defaultCharset());
        final RateLimiterFactoryConfig rateLimiterFactoryConfig = YamlUtils.readYamlFromString((String)content, Config.class).config;
        Injector injector = Guice.createInjector(new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(IRateLimiterFactory.class).to(RateLimiterFactory.class).in(Scopes.SINGLETON);
                this.bind(IMetrics.class).to(IMetrics.NoOpMetrics.class);
                this.bind(RateLimiterFactoryConfig.class).toInstance(rateLimiterFactoryConfig);
            }
        });
        ApplicationContext.setInjector(injector);
        IRateLimiterFactory rateLimiterFactory = injector.getInstance(IRateLimiterFactory.class);
        rateLimiterFactory.start();
        AmazonDynamoDB client = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withRegion(Regions.AP_SOUTH_1)).build();
        DynamoDB dynamoDB = new DynamoDB(client);
        Table table = dynamoDB.getTable(rateLimiterFactoryConfig.getRateLimiters().get(rateLimiterName).getRateLimitJobConfig().getString("table"));
        for (int i = 0; i < 1000000; ++i) {
            Data data = Data.builder().id("id_" + i).data("data_" + i).build();
            rateLimiterFactory.get(rateLimiterName).ifPresent(IRateLimiter::acquire);
            table.putItem(Item.fromJSON(JsonUtils.asJson(data)));
            System.out.println("Write done - " + i);
        }
    }

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Config {
        @JsonProperty(value="rate_limit_factory")
        private RateLimiterFactoryConfig config;
    }

    private static class Data {
        private String id;
        private String data;

        Data(String id, String data) {
            this.id = id;
            this.data = data;
        }

        public static DataBuilder builder() {
            return new DataBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getData() {
            return this.data;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setData(String data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "DoNotUseExample.Data(id=" + this.getId() + ", data=" + this.getData() + ")";
        }

        public static class DataBuilder {
            private String id;
            private String data;

            DataBuilder() {
            }

            public DataBuilder id(String id) {
                this.id = id;
                return this;
            }

            public DataBuilder data(String data) {
                this.data = data;
                return this;
            }

            public Data build() {
                return new Data(this.id, this.data);
            }

            public String toString() {
                return "DoNotUseExample.Data.DataBuilder(id=" + this.id + ", data=" + this.data + ")";
            }
        }
    }
}

