/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.ratelimit.job.ddb;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.easy.ratelimit.IRateLimitJob;
import io.github.devlibx.easy.ratelimit.IRateLimiter;
import io.github.devlibx.easy.ratelimit.IRateLimiterFactory;
import io.github.devlibx.easy.ratelimit.RateLimiterConfig;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDbWriteRateLimitJob
implements IRateLimitJob {
    private static final Logger log = LoggerFactory.getLogger(DynamoDbWriteRateLimitJob.class);
    private RateLimiterConfig rateLimiterConfig;
    private StringObjectMap config;
    private Table dynamoTable;
    private String tableName;
    private final AtomicBoolean keepRunning = new AtomicBoolean(true);

    @Override
    public void startRateLimitJob(RateLimiterConfig rateLimiterConfig) {
        try {
            this.internalStartRateLimitJob(rateLimiterConfig);
            new Thread(() -> {
                while (this.keepRunning.get()) {
                    try {
                        this.updateRateLimit(rateLimiterConfig);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        int sleep = rateLimiterConfig.getRateLimitJobConfig().getInt("refresh-time-in-sec", 5);
                        Thread.sleep((long)sleep * 1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopRateLimitJob() {
        this.keepRunning.set(false);
    }

    public void internalStartRateLimitJob(RateLimiterConfig rateLimiterConfig) {
        AmazonDynamoDB client;
        this.rateLimiterConfig = rateLimiterConfig;
        this.config = rateLimiterConfig.getRateLimitJobConfig();
        if (!Strings.isNullOrEmpty(this.config.getString("AWS_ACCESS_KEY_ID"))) {
            BasicSessionCredentials bc = new BasicSessionCredentials(this.config.getString("AWS_ACCESS_KEY_ID"), this.config.getString("AWS_SECRET_ACCESS_KEY"), this.config.getString("AWS_SESSION_TOKEN"));
            client = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials(new AWSStaticCredentialsProvider(bc))).withRegion(Regions.valueOf(this.config.getString("region", "AP_SOUTH_1")))).build();
        } else {
            client = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withRegion(Regions.AP_SOUTH_1)).build();
        }
        DynamoDB dynamoDB = new DynamoDB(client);
        this.tableName = this.config.getString("table");
        this.dynamoTable = dynamoDB.getTable(this.config.getString("table"));
    }

    private void updateRateLimit(RateLimiterConfig rateLimiterConfig) {
        ApplicationContext.getInstance(IRateLimiterFactory.class).get(rateLimiterConfig.getName()).ifPresent(rateLimiter -> {
            if (rateLimiterConfig.isEnabled()) {
                if (this.config.getBoolean("rate-limit-by-write", true).booleanValue()) {
                    this.setWriteLimit((IRateLimiter)rateLimiter);
                } else {
                    this.setReadLimit((IRateLimiter)rateLimiter);
                }
            }
        });
    }

    private void setWriteLimit(IRateLimiter rateLimiter) {
        try {
            TableDescription table_info = this.dynamoTable.describe();
            long value = table_info.getProvisionedThroughput().getWriteCapacityUnits();
            if (value > 0L) {
                float rateLimitFactor = this.config.getFloat("rate-limit-factor") != null ? this.config.getFloat("rate-limit-factor").floatValue() : 0.8f;
                long finalValue = (long)((float)value * rateLimitFactor);
                log.debug("set ratelimit for DDB write table={} with value={}, factor={}, rateLimitUsed={}", this.tableName, value, Float.valueOf(rateLimitFactor), finalValue);
                rateLimiter.trySetRate(value);
            } else {
                log.warn("(OnDemand table) will not set ratelimit for DDB write table={} with rateLimitUsed={}", (Object)this.tableName, (Object)rateLimiter.debug());
            }
        }
        catch (Exception e) {
            log.error("failed to setup write rate limiter: table={}", (Object)this.tableName, (Object)e);
        }
    }

    private void setReadLimit(IRateLimiter rateLimiter) {
        try {
            TableDescription table_info = this.dynamoTable.describe();
            long value = table_info.getProvisionedThroughput().getReadCapacityUnits();
            if (value > 0L) {
                float rateLimitFactor = this.config.getFloat("rate-limit-factor") != null ? this.config.getFloat("rate-limit-factor").floatValue() : 0.8f;
                long finalValue = (long)((float)value * rateLimitFactor);
                log.debug("set ratelimit for DDB read table={} with value={}, factor={}, rateLimitUsed={}", this.tableName, value, Float.valueOf(rateLimitFactor), finalValue);
                rateLimiter.trySetRate(value);
            } else {
                log.warn("(OnDemand table) will not set ratelimit for DDB read table={} with rateLimitUsed={}", (Object)this.tableName, (Object)rateLimiter.debug());
            }
        }
        catch (Exception e) {
            log.error("failed to setup read rate limiter: table={}", (Object)this.tableName, (Object)e);
        }
    }
}

