/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.ratelimit.redis;

import io.github.devlibx.easy.ratelimit.RateLimiterConfig;
import io.github.devlibx.easy.ratelimit.redis.RedissonExt;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public interface IRedissonProvider {
    public RedissonClient get(RateLimiterConfig.Redis var1);

    public static class DefaultRedissonProvider
    implements IRedissonProvider {
        private final Lock lock = new ReentrantLock();
        private final Map<String, RedissonClient> redissonClientMap = new HashMap<String, RedissonClient>();

        @Override
        public RedissonClient get(RateLimiterConfig.Redis redis) {
            this.lock.lock();
            try {
                RedissonClient redissonClient = this.redissonClientMap.computeIfAbsent(redis.uniqueKey(), key -> {
                    Config redissonConfig = redis.getRedissonConfig();
                    if (Objects.equals(redis.getVersion(), "v1")) {
                        return Redisson.create(redissonConfig);
                    }
                    if (Objects.equals(redis.getVersion(), "v2")) {
                        return RedissonExt.create(redissonConfig);
                    }
                    if (Objects.equals(redis.getVersion(), "v3")) {
                        return RedissonExt.create(redissonConfig);
                    }
                    return Redisson.create(redissonConfig);
                });
                return redissonClient;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

