/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.ratelimit.redis;

import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.Safe;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.github.devlibx.easy.ratelimit.IRateLimiter;
import io.github.devlibx.easy.ratelimit.RateLimiterConfig;
import io.github.devlibx.easy.ratelimit.redis.IRedissonProvider;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisBasedRateLimiter
implements IRateLimiter {
    private static final Logger log = LoggerFactory.getLogger(RedisBasedRateLimiter.class);
    private final RateLimiterConfig rateLimiterConfig;
    private final IMetrics metrics;
    private RedissonClient redissonClient;
    private RRateLimiter limiter;
    private final Lock limiterLock;
    private final CircuitBreaker circuitBreaker;

    @Inject
    public RedisBasedRateLimiter(RateLimiterConfig rateLimiterConfig, IMetrics metrics) {
        this.rateLimiterConfig = rateLimiterConfig;
        this.metrics = metrics;
        this.limiterLock = new ReentrantLock();
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(rateLimiterConfig.getProperties().getInt("circuit-breaker-config-failureRateThreshold", 50).intValue()).minimumNumberOfCalls(rateLimiterConfig.getProperties().getInt("circuit-breaker-config-minimumNumberOfCalls", 10)).enableAutomaticTransitionFromOpenToHalfOpen().build();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of(circuitBreakerConfig);
        this.circuitBreaker = circuitBreakerRegistry.circuitBreaker(rateLimiterConfig.getName());
    }

    @Override
    public void start() {
        if (this.rateLimiterConfig.getRedis() != null) {
            IRedissonProvider redissonProvider;
            try {
                redissonProvider = ApplicationContext.getInstance(IRedissonProvider.class);
            }
            catch (Exception e) {
                redissonProvider = new IRedissonProvider.DefaultRedissonProvider();
            }
            this.redissonClient = redissonProvider.get(this.rateLimiterConfig.getRedis());
            this.limiter = this.redissonClient.getRateLimiter(this.rateLimiterConfig.getName());
            if (this.limiter != null) {
                try {
                    this.limiter.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            throw new RuntimeException("redis property must be set to use redis based rate limiter");
        }
        this.limiter = this.redissonClient.getRateLimiter(this.rateLimiterConfig.getName());
        this.applyRate(this.limiter);
        this.rateLimiterConfig.getRateLimitJob().ifPresent(rateLimitJob -> rateLimitJob.startRateLimitJob(this.rateLimiterConfig));
    }

    private boolean applyRate(RRateLimiter limiter) {
        if (limiter == null) {
            return false;
        }
        return limiter.trySetRate(RateType.valueOf(this.rateLimiterConfig.getRateType().name()), this.rateLimiterConfig.getRate(), this.rateLimiterConfig.getRateInterval(), this.convert(this.rateLimiterConfig.getRateIntervalUnit()));
    }

    @Override
    public boolean trySetRate(long rate) {
        this.rateLimiterConfig.setRate((int)rate);
        this.safeDeleteRateLimit();
        this.limiterLock.lock();
        RRateLimiter _limiter = this.limiter;
        this.limiterLock.unlock();
        return this.applyRate(_limiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeDeleteRateLimit() {
        block19: {
            RLock redisLockToModifyRateLimit;
            try {
                redisLockToModifyRateLimit = this.redissonClient.getLock("ratelimit-update-lock-" + this.rateLimiterConfig.getName());
            }
            catch (Exception e) {
                redisLockToModifyRateLimit = new DummyRLock();
                log.error("Failed to create a ratelimit-update-lock-{} to safely update the rate", (Object)this.rateLimiterConfig.getName());
            }
            try {
                redisLockToModifyRateLimit.lock(10L, TimeUnit.SECONDS);
                this.limiterLock.lock();
                try {
                    org.redisson.api.RateLimiterConfig configFromRedis;
                    try {
                        configFromRedis = this.limiter.getConfig();
                    }
                    catch (Exception e) {
                        log.warn("trying to update the ratelimit-update-lock-{}, and this error is expected 2-3 times at boot: error={}", (Object)this.rateLimiterConfig.getName(), (Object)e.getMessage());
                        configFromRedis = e.getCause() instanceof NumberFormatException ? new org.redisson.api.RateLimiterConfig(RateType.OVERALL, 0L, 0L) : new org.redisson.api.RateLimiterConfig(RateType.OVERALL, 0L, 0L);
                    }
                    if (configFromRedis.getRate() == (long)this.rateLimiterConfig.getRate()) break block19;
                    try {
                        this.limiter.delete();
                    }
                    catch (Exception e) {
                        log.error("trying to update the ratelimit-update-lock-{} - this requires us to delete the old limit. Something is wrong, we could not delete it", (Object)this.rateLimiterConfig.getName(), (Object)e);
                    }
                    this.limiter = this.redissonClient.getRateLimiter(this.rateLimiterConfig.getName());
                }
                finally {
                    this.limiterLock.unlock();
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    redisLockToModifyRateLimit.unlock();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void acquire() {
        this.acquire(1L);
    }

    @Override
    public void acquire(long permits) {
        int retry = 3;
        while (retry-- >= 0) {
            try {
                this.limiterLock.lock();
                RRateLimiter _limiter = this.limiter;
                this.limiterLock.unlock();
                if (_limiter != null) {
                    Runnable runnable = CircuitBreaker.decorateRunnable(this.circuitBreaker, () -> {
                        _limiter.acquire(permits);
                        this.metrics.inc("rate_limiter", (int)permits, "name", this.rateLimiterConfig.getName(), "status", "ok");
                    });
                    runnable.run();
                    retry = -1;
                    continue;
                }
                this.metrics.inc("rate_limiter", (int)permits, "name", this.rateLimiterConfig.getName(), "status", "error", "error", "linter_null");
                this.sleep(10L);
            }
            catch (CallNotPermittedException e) {
                log.error("circuit open in taking lock. Lock is taken: name={}, retryCount={}, error={}", this.rateLimiterConfig.getName(), retry, e.getMessage());
                retry = -1;
                this.metrics.inc("rate_limiter", (int)permits, "name", this.rateLimiterConfig.getName(), "status", "error", "error", "circuit_open");
            }
            catch (Exception e) {
                log.error("error in acquiring lock: name={}, retryCount={}", this.rateLimiterConfig.getName(), retry, e);
                this.metrics.inc("rate_limiter", (int)permits, "name", this.rateLimiterConfig.getName(), "status", "error", "error", "unknown");
                this.sleep(50L);
            }
        }
    }

    @Override
    public void stop() {
        this.limiterLock.lock();
        try {
            if (this.redissonClient != null) {
                Safe.safe(() -> {
                    this.redissonClient.shutdown();
                    this.redissonClient = null;
                    this.limiter = null;
                }, "failed to stop redisson client: " + this.rateLimiterConfig);
            }
        }
        finally {
            this.limiterLock.unlock();
        }
    }

    @Override
    public StringObjectMap debug() {
        return StringObjectMap.of("rateType", (Object)this.rateLimiterConfig.getRateType(), "rate", (Object)this.rateLimiterConfig.getRate(), "rateInterval", (Object)this.rateLimiterConfig.getRateInterval(), "rateIntervalUnit", (Object)this.rateLimiterConfig.getRateIntervalUnit());
    }

    private RateIntervalUnit convert(TimeUnit rateIntervalUnit) {
        RateIntervalUnit unit = rateIntervalUnit == TimeUnit.DAYS ? RateIntervalUnit.DAYS : (rateIntervalUnit == TimeUnit.HOURS ? RateIntervalUnit.HOURS : (rateIntervalUnit == TimeUnit.MINUTES ? RateIntervalUnit.MINUTES : (rateIntervalUnit == TimeUnit.SECONDS ? RateIntervalUnit.SECONDS : (rateIntervalUnit == TimeUnit.MILLISECONDS ? RateIntervalUnit.MILLISECONDS : RateIntervalUnit.SECONDS))));
        return unit;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class DummyRLock
    implements RLock {
        private DummyRLock() {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        }

        @Override
        public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void lock(long leaseTime, TimeUnit unit) {
            Random random = new Random();
            try {
                Thread.sleep(1000 * random.nextInt(5));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public boolean forceUnlock() {
            return false;
        }

        @Override
        public boolean isLocked() {
            return false;
        }

        @Override
        public boolean isHeldByThread(long threadId) {
            return false;
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return false;
        }

        @Override
        public int getHoldCount() {
            return 0;
        }

        @Override
        public long remainTimeToLive() {
            return 0L;
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return false;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            return null;
        }

        @Override
        public RFuture<Boolean> forceUnlockAsync() {
            return null;
        }

        @Override
        public RFuture<Void> unlockAsync() {
            return null;
        }

        @Override
        public RFuture<Void> unlockAsync(long threadId) {
            return null;
        }

        @Override
        public RFuture<Boolean> tryLockAsync() {
            return null;
        }

        @Override
        public RFuture<Void> lockAsync() {
            return null;
        }

        @Override
        public RFuture<Void> lockAsync(long threadId) {
            return null;
        }

        @Override
        public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
            return null;
        }

        @Override
        public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long threadId) {
            return null;
        }

        @Override
        public RFuture<Boolean> tryLockAsync(long threadId) {
            return null;
        }

        @Override
        public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
            return null;
        }

        @Override
        public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
            return null;
        }

        @Override
        public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
            return null;
        }

        @Override
        public RFuture<Integer> getHoldCountAsync() {
            return null;
        }

        @Override
        public RFuture<Boolean> isLockedAsync() {
            return null;
        }

        @Override
        public RFuture<Long> remainTimeToLiveAsync() {
            return null;
        }
    }
}

