/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.ratelimit.redis;

import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.Safe;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.github.devlibx.easy.ratelimit.IRateLimiter;
import io.github.devlibx.easy.ratelimit.RateLimiterConfig;
import io.github.devlibx.easy.ratelimit.redis.IRedissonProvider;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisBasedRateLimiterV2
implements IRateLimiter {
    private static final Logger log = LoggerFactory.getLogger(RedisBasedRateLimiterV2.class);
    private final RateLimiterConfig rateLimiterConfig;
    private final IMetrics metrics;
    private RedissonClient redissonClient;
    private RRateLimiter limiter;
    private final Lock limiterLock;
    private final CircuitBreaker circuitBreaker;

    @Inject
    public RedisBasedRateLimiterV2(RateLimiterConfig rateLimiterConfig, IMetrics metrics) {
        this.rateLimiterConfig = rateLimiterConfig;
        this.metrics = metrics;
        this.limiterLock = new ReentrantLock();
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(rateLimiterConfig.getProperties().getInt("circuit-breaker-config-failureRateThreshold", 50).intValue()).minimumNumberOfCalls(rateLimiterConfig.getProperties().getInt("circuit-breaker-config-minimumNumberOfCalls", 10)).enableAutomaticTransitionFromOpenToHalfOpen().build();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of(circuitBreakerConfig);
        this.circuitBreaker = circuitBreakerRegistry.circuitBreaker(rateLimiterConfig.getName());
    }

    @Override
    public void start() {
        IRedissonProvider redissonProvider;
        if (this.rateLimiterConfig.getRedis() != null) {
            try {
                redissonProvider = ApplicationContext.getInstance(IRedissonProvider.class);
            }
            catch (Exception e) {
                redissonProvider = new IRedissonProvider.DefaultRedissonProvider();
            }
        } else {
            throw new RuntimeException("redis property must be set to use redis based rate limiter");
        }
        this.redissonClient = redissonProvider.get(this.rateLimiterConfig.getRedis());
        this.limiter = this.redissonClient.getRateLimiter(this.rateLimiterConfig.getName());
        this.applyRate(this.limiter);
        this.rateLimiterConfig.getRateLimitJob().ifPresent(rateLimitJob -> rateLimitJob.startRateLimitJob(this.rateLimiterConfig));
    }

    private boolean applyRate(RRateLimiter limiter) {
        if (limiter == null) {
            return false;
        }
        return limiter.trySetRate(RateType.valueOf(this.rateLimiterConfig.getRateType().name()), this.rateLimiterConfig.getRate(), this.rateLimiterConfig.getRateInterval(), this.convert(this.rateLimiterConfig.getRateIntervalUnit()));
    }

    @Override
    public boolean trySetRate(long rate) {
        this.rateLimiterConfig.setRate((int)rate);
        return this.applyRate(this.limiter);
    }

    @Override
    public void acquire() {
        this.acquire(1L);
    }

    @Override
    public void acquire(long permits) {
        int retry = 3;
        while (retry-- >= 0) {
            try {
                if (this.limiter != null) {
                    Runnable runnable = CircuitBreaker.decorateRunnable(this.circuitBreaker, () -> {
                        this.limiter.acquire(permits);
                        this.metrics.inc("rate_limiter", (int)permits, "name", this.rateLimiterConfig.getName(), "status", "ok");
                    });
                    runnable.run();
                    retry = -1;
                    continue;
                }
                this.metrics.inc("rate_limiter", (int)permits, "name", this.rateLimiterConfig.getName(), "status", "error", "error", "linter_null");
                this.sleep(10L);
            }
            catch (CallNotPermittedException e) {
                log.error("circuit open in taking lock. Lock is taken: name={}, retryCount={}, error={}", this.rateLimiterConfig.getName(), retry, e.getMessage());
                retry = -1;
                this.metrics.inc("rate_limiter", (int)permits, "name", this.rateLimiterConfig.getName(), "status", "error", "error", "circuit_open");
            }
            catch (Exception e) {
                log.error("error in acquiring lock: name={}, retryCount={}", this.rateLimiterConfig.getName(), retry, e);
                this.metrics.inc("rate_limiter", (int)permits, "name", this.rateLimiterConfig.getName(), "status", "error", "error", "unknown");
                this.sleep(50L);
            }
        }
    }

    @Override
    public void stop() {
        this.limiterLock.lock();
        try {
            if (this.redissonClient != null) {
                Safe.safe(() -> {
                    this.redissonClient.shutdown();
                    this.redissonClient = null;
                    this.limiter = null;
                }, "failed to stop redisson client: " + this.rateLimiterConfig);
            }
        }
        finally {
            this.limiterLock.unlock();
        }
    }

    @Override
    public StringObjectMap debug() {
        return StringObjectMap.of("rateType", (Object)this.rateLimiterConfig.getRateType(), "rate", (Object)this.rateLimiterConfig.getRate(), "rateInterval", (Object)this.rateLimiterConfig.getRateInterval(), "rateIntervalUnit", (Object)this.rateLimiterConfig.getRateIntervalUnit());
    }

    private RateIntervalUnit convert(TimeUnit rateIntervalUnit) {
        RateIntervalUnit unit = rateIntervalUnit == TimeUnit.DAYS ? RateIntervalUnit.DAYS : (rateIntervalUnit == TimeUnit.HOURS ? RateIntervalUnit.HOURS : (rateIntervalUnit == TimeUnit.MINUTES ? RateIntervalUnit.MINUTES : (rateIntervalUnit == TimeUnit.SECONDS ? RateIntervalUnit.SECONDS : (rateIntervalUnit == TimeUnit.MILLISECONDS ? RateIntervalUnit.MILLISECONDS : RateIntervalUnit.SECONDS))));
        return unit;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RRateLimiter getLimiter() {
        return this.limiter;
    }
}

