/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.ratelimit.redis;

import io.gitbub.devlibx.easy.helper.json.JsonUtils;
import io.github.devlibx.easy.ratelimit.RateLimiterConfig;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;
import org.redisson.RedissonRateLimiter;
import org.redisson.api.RFuture;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedissonRateLimiterExt
extends RedissonRateLimiter {
    private RateLimiterConfig rateLimiterConfig;
    private final AtomicInteger count = new AtomicInteger();
    private static final String script = "local enableDebugLogging = true\n\n-- Algo will run between lowest value to current value\nlocal currentTimeParam = ARGV[1];\nlocal lowestTimeParam = ARGV[2];\nlocal currentTimeParamString = currentTimeParam .. \"\";\nlocal lowestTimeParamString = lowestTimeParam .. \"\";\n\n-- What is per second rate, how many permits are required, what is the name of this sorted set, what is the TTL value\nlocal rateParam = ARGV[3];\nlocal permits = ARGV[4];\nlocal zset = ARGV[8] .. '-' .. ARGV[5];\nlocal ttlValue = ARGV[6];\nlocal currentTime = ARGV[7];\nlocal keyPrefix = ARGV[8];\n\n-- We have 2 data structure:\n-- 1 - a sorted set of last N seconds (we make sure we only keep last N seconds keys here)\n-- 2 - for each time time seconds a rate limit counter\n\n-- This is the redis key to get current time key\nlocal redisCurrentTimeKey = keyPrefix .. '-' .. currentTimeParamString;\n\n-- This is the value to return\nlocal value = -1\n\nlocal debug = ''\nif enableDebugLogging then\n    debug = '[Set Name: ' .. zset .. ' Current Time: ' .. currentTimeParam .. ' currentTimeRedisKey:' .. redisCurrentTimeKey .. ']'\nend\n\n-- If key does not exist then set the value to rate\nif redis.call('GETEX', redisCurrentTimeKey) == false then\n\n    -- We did not have they key, set it with rate value and TTL\n    redis.call('SET', redisCurrentTimeKey, rateParam, 'EX', ttlValue);\n\n    -- Add current value to the sorted list\n    redis.call('ZADD', zset, currentTimeParam, redisCurrentTimeKey);\n\n    -- Make sure we flush old keys (to free up any old value)\n    redis.call('ZREMRANGEBYSCORE', zset, 0, lowestTimeParam);\n\n    if enableDebugLogging then\n        debug = debug ..\n                ' [key did not existed - create new key with ttl:' .. ttlValue ..\n                ' Sorted key cleared:' .. 0 .. '-' .. lowestTimeParam\n    end\nend\n\n-- Decrement by requested permits\nvalue = redis.call(\"DECRBY\", redisCurrentTimeKey, permits)\n\n-- If we already consumed all limits, then try to get it from old tokesn\nif value < 0 then\n\n    -- Get all the keys from last N sec\n    local sortedSet = redis.call('ZRANGEBYSCORE', zset, '-inf', '+inf');\n\n    for i, v in pairs(sortedSet) do\n\n        value = redis.call(\"DECRBY\", v, permits)\n\n        if value > 0 then\n            if enableDebugLogging then\n                debug = debug .. ' [found value from key ' .. v .. ' with value ' .. value\n            end\n            break\n        else\n            if v ~= redisCurrentTimeKey then\n                redis.call('DEL', v)\n                if enableDebugLogging then\n                    debug = debug .. ' DeleteFromZRange: ' .. v .. ','\n                end\n            end\n        end\n\n    end\nend\n\nlocal resultToReturn = -1\nlocal debugToReturn = ''\nlocal delay = 0\nif enableDebugLogging then\n    if value >= 0 then\n        resultToReturn = value\n        debugToReturn = debug\n    else\n        resultToReturn = -1\n        delay = ((currentTimeParam + 1) * 1000) - currentTime;\n        if enableDebugLogging then\n            debugToReturn = debug .. ' Final value suppress to -1'\n        end\n    end\nelse\n    if value >= 0 then\n        resultToReturn = value\n    else\n        resultToReturn = -1\n        delay = ((currentTimeParam + 1) * 1000) - currentTime;\n    end\nend\n\n-- Meta class\n\nreturn { resultToReturn .. '', delay .. '', debugToReturn }";

    public RedissonRateLimiterExt(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public RFuture<Boolean> trySetRateAsync(RateType type, long rate, long rateInterval, RateIntervalUnit unit) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('hset', KEYS[1], 'rate', ARGV[1]);redis.call('hset', KEYS[1], 'interval', ARGV[2]); redis.call('hset', KEYS[1], 'type', ARGV[3]); return 1;", Collections.singletonList(this.getName()), rate, unit.toMillis(rateInterval), type.ordinal());
    }

    public void acquireExtV3(long permits) {
        this.get(this.acquireAsyncExtV3(permits));
    }

    public RFuture<Void> acquireAsyncExtV3(long permits) {
        RedissonPromise<Void> promise = new RedissonPromise<Void>();
        this.tryAcquireAsyncExtV3(permits, -1L, null).onComplete((res, e) -> {
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            promise.trySuccess(null);
        });
        return promise;
    }

    public RFuture<Boolean> tryAcquireAsyncExtV3(long permits, long timeout, TimeUnit unit) {
        RedissonPromise<Boolean> promise = new RedissonPromise<Boolean>();
        long timeoutInMillis = -1L;
        if (timeout >= 0L) {
            timeoutInMillis = unit.toMillis(timeout);
        }
        this.tryAcquireAsyncExtV3(permits, promise, timeoutInMillis);
        return promise;
    }

    private void tryAcquireAsyncExtV3(long permits, RPromise<Boolean> promise, long timeoutInMillis) {
        long s2 = System.currentTimeMillis();
        RFuture<List<Object>> future = this.tryAcquireAsyncExtV3(RedisCommands.EVAL_LIST, permits);
        future.onComplete((_delay, e) -> {
            Long delay;
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            if (this.rateLimiterConfig != null && this.rateLimiterConfig.getProperties().getBoolean("debug", false).booleanValue() && this.count.incrementAndGet() % this.rateLimiterConfig.getProperties().getInt("debug-percentage", 100) == 0) {
                System.out.println(JsonUtils.asJson(_delay));
            }
            if ((delay = Long.valueOf(Long.parseLong(_delay.get(1).toString()))) <= 0L) {
                delay = null;
            }
            if (delay == null) {
                promise.trySuccess(true);
                return;
            }
            if (timeoutInMillis == -1L) {
                this.commandExecutor.getConnectionManager().getGroup().schedule(() -> this.tryAcquireAsyncExtV3(permits, promise, timeoutInMillis), (long)delay, TimeUnit.MILLISECONDS);
                return;
            }
            long el = System.currentTimeMillis() - s2;
            long remains = timeoutInMillis - el;
            if (remains <= 0L) {
                promise.trySuccess(false);
                return;
            }
            if (remains < delay) {
                this.commandExecutor.getConnectionManager().getGroup().schedule(() -> promise.trySuccess(false), remains, TimeUnit.MILLISECONDS);
            } else {
                long start = System.currentTimeMillis();
                this.commandExecutor.getConnectionManager().getGroup().schedule(() -> {
                    long elapsed = System.currentTimeMillis() - start;
                    if (remains <= elapsed) {
                        promise.trySuccess(false);
                        return;
                    }
                    this.tryAcquireAsyncExtV3(permits, promise, remains - elapsed);
                }, (long)delay, TimeUnit.MILLISECONDS);
            }
        });
    }

    private <T> RFuture<T> tryAcquireAsyncExtV3(RedisCommand<T> command, Long value) {
        DateTime now = DateTime.now();
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, command, this.rateLimiterConfig.getProperties().getString("script", script), (List<Object>)Collections.EMPTY_LIST, new Long(now.getMillis() / 1000L), new Long(now.minusSeconds(this.rateLimiterConfig.getProperties().getInt("buffer", 300)).getMillis() / 1000L), this.rateLimiterConfig.getRate(), value, this.getName().replace("-", ""), this.rateLimiterConfig.getProperties().getInt("ttl", 300), now.getMillis(), this.getName() + "-" + this.rateLimiterConfig.getPrefix());
    }

    public void setRateLimiterConfig(RateLimiterConfig rateLimiterConfig) {
        this.rateLimiterConfig = rateLimiterConfig;
    }
}

