/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.bulkhead.ContextPropagator;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallFinishedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallPermittedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallRejectedEvent;
import io.github.resilience4j.bulkhead.internal.NamingThreadFactory;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.core.lang.Nullable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class FixedThreadPoolBulkhead
implements ThreadPoolBulkhead {
    private static final String CONFIG_MUST_NOT_BE_NULL = "Config must not be null";
    private static final String TAGS_MUST_NOTE_BE_NULL = "Tags must not be null";
    private final String name;
    private final ThreadPoolExecutor executorService;
    private final BulkheadMetrics metrics;
    private final BulkheadEventProcessor eventProcessor;
    private final ThreadPoolBulkheadConfig config;
    private final Map<String, String> tags;

    public FixedThreadPoolBulkhead(String name, @Nullable ThreadPoolBulkheadConfig bulkheadConfig) {
        this(name, bulkheadConfig, HashMap.empty());
    }

    public FixedThreadPoolBulkhead(String name, @Nullable ThreadPoolBulkheadConfig bulkheadConfig, Map<String, String> tags) {
        this.name = name;
        this.config = Objects.requireNonNull(bulkheadConfig, CONFIG_MUST_NOT_BE_NULL);
        this.tags = Objects.requireNonNull(tags, TAGS_MUST_NOTE_BE_NULL);
        this.executorService = new ThreadPoolExecutor(this.config.getCoreThreadPoolSize(), this.config.getMaxThreadPoolSize(), this.config.getKeepAliveDuration().toMillis(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.config.getQueueCapacity()), new NamingThreadFactory(name));
        this.metrics = new BulkheadMetrics();
        this.eventProcessor = new BulkheadEventProcessor();
    }

    public FixedThreadPoolBulkhead(String name) {
        this(name, ThreadPoolBulkheadConfig.ofDefaults(), HashMap.empty());
    }

    public FixedThreadPoolBulkhead(String name, Map<String, String> tags) {
        this(name, ThreadPoolBulkheadConfig.ofDefaults(), tags);
    }

    public FixedThreadPoolBulkhead(String name, Supplier<ThreadPoolBulkheadConfig> configSupplier) {
        this(name, configSupplier.get(), HashMap.empty());
    }

    public FixedThreadPoolBulkhead(String name, Supplier<ThreadPoolBulkheadConfig> configSupplier, Map<String, String> tags) {
        this(name, configSupplier.get(), tags);
    }

    public <T> CompletableFuture<T> submit(Callable<T> callable) {
        CompletableFuture promise = new CompletableFuture();
        try {
            CompletableFuture.supplyAsync(ContextPropagator.decorateSupplier(this.config.getContextPropagator(), () -> {
                try {
                    this.publishBulkheadEvent(() -> new BulkheadOnCallPermittedEvent(this.name));
                    return callable.call();
                }
                catch (CompletionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }), this.executorService).whenComplete((result, throwable) -> {
                this.publishBulkheadEvent(() -> new BulkheadOnCallFinishedEvent(this.name));
                if (throwable != null) {
                    promise.completeExceptionally((Throwable)throwable);
                } else {
                    promise.complete(result);
                }
            });
        }
        catch (RejectedExecutionException rejected) {
            this.publishBulkheadEvent(() -> new BulkheadOnCallRejectedEvent(this.name));
            throw BulkheadFullException.createBulkheadFullException(this);
        }
        return promise;
    }

    public CompletableFuture<Void> submit(Runnable runnable) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        try {
            CompletableFuture.runAsync(ContextPropagator.decorateRunnable(this.config.getContextPropagator(), () -> {
                try {
                    this.publishBulkheadEvent(() -> new BulkheadOnCallPermittedEvent(this.name));
                    runnable.run();
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }), this.executorService).whenComplete((result, throwable) -> {
                this.publishBulkheadEvent(() -> new BulkheadOnCallFinishedEvent(this.name));
                if (throwable != null) {
                    promise.completeExceptionally((Throwable)throwable);
                } else {
                    promise.complete((Void)result);
                }
            });
        }
        catch (RejectedExecutionException rejected) {
            this.publishBulkheadEvent(() -> new BulkheadOnCallRejectedEvent(this.name));
            throw BulkheadFullException.createBulkheadFullException(this);
        }
        return promise;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ThreadPoolBulkheadConfig getBulkheadConfig() {
        return this.config;
    }

    @Override
    public ThreadPoolBulkhead.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public ThreadPoolBulkhead.ThreadPoolBulkheadEventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    private void publishBulkheadEvent(Supplier<BulkheadEvent> eventSupplier) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(eventSupplier.get());
        }
    }

    public String toString() {
        return String.format("FixedThreadPoolBulkhead '%s'", this.name);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            if (!this.executorService.isTerminated()) {
                this.executorService.shutdownNow();
            }
            Thread.currentThread().interrupt();
        }
    }

    private final class BulkheadMetrics
    implements ThreadPoolBulkhead.Metrics {
        private BulkheadMetrics() {
        }

        @Override
        public int getCoreThreadPoolSize() {
            return FixedThreadPoolBulkhead.this.executorService.getCorePoolSize();
        }

        @Override
        public int getThreadPoolSize() {
            return FixedThreadPoolBulkhead.this.executorService.getPoolSize();
        }

        @Override
        public int getMaximumThreadPoolSize() {
            return FixedThreadPoolBulkhead.this.executorService.getMaximumPoolSize();
        }

        @Override
        public int getQueueDepth() {
            return FixedThreadPoolBulkhead.this.executorService.getQueue().size();
        }

        @Override
        public int getRemainingQueueCapacity() {
            return FixedThreadPoolBulkhead.this.executorService.getQueue().remainingCapacity();
        }

        @Override
        public int getQueueCapacity() {
            return FixedThreadPoolBulkhead.this.config.getQueueCapacity();
        }
    }

    private class BulkheadEventProcessor
    extends EventProcessor<BulkheadEvent>
    implements ThreadPoolBulkhead.ThreadPoolBulkheadEventPublisher,
    EventConsumer<BulkheadEvent> {
        private BulkheadEventProcessor() {
        }

        @Override
        public ThreadPoolBulkhead.ThreadPoolBulkheadEventPublisher onCallPermitted(EventConsumer<BulkheadOnCallPermittedEvent> onCallPermittedEventConsumer) {
            this.registerConsumer(BulkheadOnCallPermittedEvent.class.getSimpleName(), onCallPermittedEventConsumer);
            return this;
        }

        @Override
        public ThreadPoolBulkhead.ThreadPoolBulkheadEventPublisher onCallRejected(EventConsumer<BulkheadOnCallRejectedEvent> onCallRejectedEventConsumer) {
            this.registerConsumer(BulkheadOnCallRejectedEvent.class.getSimpleName(), onCallRejectedEventConsumer);
            return this;
        }

        @Override
        public ThreadPoolBulkhead.ThreadPoolBulkheadEventPublisher onCallFinished(EventConsumer<BulkheadOnCallFinishedEvent> onCallFinishedEventConsumer) {
            this.registerConsumer(BulkheadOnCallFinishedEvent.class.getSimpleName(), onCallFinishedEventConsumer);
            return this;
        }

        @Override
        public void consumeEvent(BulkheadEvent event) {
            super.processEvent(event);
        }
    }
}

