/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlatMapSingle<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;

    public FlowableFlatMapSingle(Flowable<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayError, int maxConcurrency) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayError;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        this.source.subscribe(new FlatMapSingleSubscriber<T, R>(s2, this.mapper, this.delayErrors, this.maxConcurrency));
    }

    static final class FlatMapSingleSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 8600231336733376951L;
        final Subscriber<? super R> downstream;
        final boolean delayErrors;
        final int maxConcurrency;
        final AtomicLong requested;
        final CompositeDisposable set;
        final AtomicInteger active;
        final AtomicThrowable errors;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;
        final AtomicReference<SpscLinkedArrayQueue<R>> queue;
        Subscription upstream;
        volatile boolean cancelled;

        FlatMapSingleSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.requested = new AtomicLong();
            this.set = new CompositeDisposable();
            this.errors = new AtomicThrowable();
            this.active = new AtomicInteger(1);
            this.queue = new AtomicReference();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                int m3 = this.maxConcurrency;
                if (m3 == Integer.MAX_VALUE) {
                    s2.request(Long.MAX_VALUE);
                } else {
                    s2.request(this.maxConcurrency);
                }
            }
        }

        @Override
        public void onNext(T t) {
            SingleSource<R> ms;
            try {
                ms = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            this.active.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.cancelled && this.set.add(inner)) {
                ms.subscribe(inner);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.active.decrementAndGet();
            if (this.errors.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                }
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.active.decrementAndGet();
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.set.dispose();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerSuccess(InnerObserver inner, R value) {
            this.set.delete(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                boolean d;
                boolean bl = d = this.active.decrementAndGet() == 0;
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    SpscLinkedArrayQueue<R> q = this.queue.get();
                    if (d && (q == null || q.isEmpty())) {
                        Throwable ex = this.errors.terminate();
                        if (ex != null) {
                            this.downstream.onError(ex);
                        } else {
                            this.downstream.onComplete();
                        }
                        return;
                    }
                    BackpressureHelper.produced(this.requested, 1L);
                    if (this.maxConcurrency != Integer.MAX_VALUE) {
                        this.upstream.request(1L);
                    }
                } else {
                    SpscLinkedArrayQueue<R> q;
                    SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q = this.getOrCreateQueue();
                    synchronized (spscLinkedArrayQueue) {
                        q.offer(value);
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SpscLinkedArrayQueue<R> q;
                SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q = this.getOrCreateQueue();
                synchronized (spscLinkedArrayQueue) {
                    q.offer(value);
                }
                this.active.decrementAndGet();
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        SpscLinkedArrayQueue<R> getOrCreateQueue() {
            SpscLinkedArrayQueue<Object> current;
            do {
                if ((current = this.queue.get()) == null) continue;
                return current;
            } while (!this.queue.compareAndSet(null, current = new SpscLinkedArrayQueue(Flowable.bufferSize())));
            return current;
        }

        void innerError(InnerObserver inner, Throwable e) {
            this.set.delete(inner);
            if (this.errors.addThrowable(e)) {
                if (!this.delayErrors) {
                    this.upstream.cancel();
                    this.set.dispose();
                } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                    this.upstream.request(1L);
                }
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void clear() {
            SpscLinkedArrayQueue<R> q = this.queue.get();
            if (q != null) {
                q.clear();
            }
        }

        void drainLoop() {
            int missed = 1;
            Subscriber<R> a = this.downstream;
            AtomicInteger n = this.active;
            AtomicReference<SpscLinkedArrayQueue<R>> qr = this.queue;
            do {
                SpscLinkedArrayQueue<R> q;
                boolean d;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    if (!this.delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                        ex = this.errors.terminate();
                        this.clear();
                        a.onError(ex);
                        return;
                    }
                    d = n.get() == 0;
                    q = qr.get();
                    Object v = q != null ? (Object)q.poll() : null;
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        Throwable ex2 = this.errors.terminate();
                        if (ex2 != null) {
                            a.onError(ex2);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                }
                if (e == r) {
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    if (!this.delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                        ex = this.errors.terminate();
                        this.clear();
                        a.onError(ex);
                        return;
                    }
                    d = n.get() == 0;
                    q = qr.get();
                    boolean bl = empty = q == null || q.isEmpty();
                    if (d && empty) {
                        Throwable ex3 = this.errors.terminate();
                        if (ex3 != null) {
                            a.onError(ex3);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureHelper.produced(this.requested, e);
                if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                this.upstream.request(e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        final class InnerObserver
        extends AtomicReference<Disposable>
        implements SingleObserver<R>,
        Disposable {
            private static final long serialVersionUID = -502562646270949838L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapSingleSubscriber.this.innerSuccess(this, value);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapSingleSubscriber.this.innerError(this, e);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

