/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Flowable;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.NotificationLite;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MaybeConcatIterable<T>
extends Flowable<T> {
    final Iterable<? extends MaybeSource<? extends T>> sources;

    public MaybeConcatIterable(Iterable<? extends MaybeSource<? extends T>> sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        Iterator<? extends MaybeSource<? extends T>> it;
        try {
            it = ObjectHelper.requireNonNull(this.sources.iterator(), "The sources Iterable returned a null Iterator");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s2);
            return;
        }
        ConcatMaybeObserver<T> parent = new ConcatMaybeObserver<T>(s2, it);
        s2.onSubscribe(parent);
        parent.drain();
    }

    static final class ConcatMaybeObserver<T>
    extends AtomicInteger
    implements MaybeObserver<T>,
    Subscription {
        private static final long serialVersionUID = 3520831347801429610L;
        final Subscriber<? super T> downstream;
        final AtomicLong requested;
        final AtomicReference<Object> current;
        final SequentialDisposable disposables;
        final Iterator<? extends MaybeSource<? extends T>> sources;
        long produced;

        ConcatMaybeObserver(Subscriber<? super T> actual, Iterator<? extends MaybeSource<? extends T>> sources) {
            this.downstream = actual;
            this.sources = sources;
            this.requested = new AtomicLong();
            this.disposables = new SequentialDisposable();
            this.current = new AtomicReference<NotificationLite>(NotificationLite.COMPLETE);
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.disposables.dispose();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.disposables.replace(d);
        }

        @Override
        public void onSuccess(T value) {
            this.current.lazySet(value);
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.current.lazySet((Object)NotificationLite.COMPLETE);
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            AtomicReference<Object> c = this.current;
            Subscriber<Object> a = this.downstream;
            SequentialDisposable cancelled = this.disposables;
            do {
                boolean b;
                boolean goNextSource;
                if (cancelled.isDisposed()) {
                    c.lazySet(null);
                    return;
                }
                Object o = c.get();
                if (o == null) continue;
                if (o != NotificationLite.COMPLETE) {
                    long p = this.produced;
                    if (p != this.requested.get()) {
                        this.produced = p + 1L;
                        c.lazySet(null);
                        goNextSource = true;
                        a.onNext(o);
                    } else {
                        goNextSource = false;
                    }
                } else {
                    goNextSource = true;
                    c.lazySet(null);
                }
                if (!goNextSource || cancelled.isDisposed()) continue;
                try {
                    b = this.sources.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
                if (b) {
                    MaybeSource<T> source;
                    try {
                        source = ObjectHelper.requireNonNull(this.sources.next(), "The source Iterator returned a null MaybeSource");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        a.onError(ex);
                        return;
                    }
                    source.subscribe(this);
                    continue;
                }
                a.onComplete();
            } while (this.decrementAndGet() != 0);
        }
    }
}

