/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.mixed;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.mixed.ScalarXMapZHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapCompletable<T>
extends Completable {
    final Observable<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public ObservableConcatMapCompletable(Observable<T> source, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        if (!ScalarXMapZHelper.tryAsCompletable(this.source, this.mapper, observer)) {
            this.source.subscribe(new ConcatMapCompletableObserver<T>(observer, this.mapper, this.errorMode, this.prefetch));
        }
    }

    static final class ConcatMapCompletableObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 3610901111000061034L;
        final CompletableObserver downstream;
        final Function<? super T, ? extends CompletableSource> mapper;
        final ErrorMode errorMode;
        final AtomicThrowable errors;
        final ConcatMapInnerObserver inner;
        final int prefetch;
        SimpleQueue<T> queue;
        Disposable upstream;
        volatile boolean active;
        volatile boolean done;
        volatile boolean disposed;

        ConcatMapCompletableObserver(CompletableObserver downstream, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.errorMode = errorMode;
            this.prefetch = prefetch;
            this.errors = new AtomicThrowable();
            this.inner = new ConcatMapInnerObserver(this);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                if (d instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)d;
                    int m3 = qd.requestFusion(3);
                    if (m3 == 1) {
                        this.queue = qd;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m3 == 2) {
                        this.queue = qd;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.prefetch);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (t != null) {
                this.queue.offer(t);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.disposed = true;
                    this.inner.dispose();
                    t = this.errors.terminate();
                    if (t != ExceptionHelper.TERMINATED) {
                        this.downstream.onError(t);
                    }
                    if (this.getAndIncrement() == 0) {
                        this.queue.clear();
                    }
                } else {
                    this.done = true;
                    this.drain();
                }
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            this.inner.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        void innerError(Throwable ex) {
            if (this.errors.addThrowable(ex)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.disposed = true;
                    this.upstream.dispose();
                    ex = this.errors.terminate();
                    if (ex != ExceptionHelper.TERMINATED) {
                        this.downstream.onError(ex);
                    }
                    if (this.getAndIncrement() == 0) {
                        this.queue.clear();
                    }
                } else {
                    this.active = false;
                    this.drain();
                }
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            AtomicThrowable errors = this.errors;
            ErrorMode errorMode = this.errorMode;
            do {
                if (this.disposed) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                if (errorMode == ErrorMode.BOUNDARY && errors.get() != null) {
                    this.disposed = true;
                    this.queue.clear();
                    Throwable ex = errors.terminate();
                    this.downstream.onError(ex);
                    return;
                }
                boolean d = this.done;
                boolean empty = true;
                CompletableSource cs = null;
                try {
                    T v = this.queue.poll();
                    if (v != null) {
                        cs = ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null CompletableSource");
                        empty = false;
                    }
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.disposed = true;
                    this.queue.clear();
                    this.upstream.dispose();
                    errors.addThrowable(ex);
                    ex = errors.terminate();
                    this.downstream.onError(ex);
                    return;
                }
                if (d && empty) {
                    this.disposed = true;
                    ex = errors.terminate();
                    if (ex != null) {
                        this.downstream.onError(ex);
                    } else {
                        this.downstream.onComplete();
                    }
                    return;
                }
                if (empty) continue;
                this.active = true;
                cs.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class ConcatMapInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = 5638352172918776687L;
            final ConcatMapCompletableObserver<?> parent;

            ConcatMapInnerObserver(ConcatMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

