/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.parallel.ParallelFailureHandling;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelDoOnNextTry<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Consumer<? super T> onNext;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;

    public ParallelDoOnNextTry(ParallelFlowable<T> source, Consumer<? super T> onNext, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.source = source;
        this.onNext = onNext;
        this.errorHandler = errorHandler;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new ParallelDoOnNextConditionalSubscriber<T>((ConditionalSubscriber)a, this.onNext, this.errorHandler) : new ParallelDoOnNextSubscriber<T>(a, this.onNext, this.errorHandler);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelDoOnNextConditionalSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final ConditionalSubscriber<? super T> downstream;
        final Consumer<? super T> onNext;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription upstream;
        boolean done;

        ParallelDoOnNextConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onNext, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.downstream = actual;
            this.onNext = onNext;
            this.errorHandler = errorHandler;
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    this.onNext.accept(t);
                }
                catch (Throwable ex) {
                    ParallelFailureHandling h2;
                    Exceptions.throwIfFatal(ex);
                    try {
                        h2 = ObjectHelper.requireNonNull(this.errorHandler.apply((Long)(++retries), ex), "The errorHandler returned a null item");
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancel();
                        this.onError(new CompositeException(ex, exc));
                        return false;
                    }
                    switch (h2) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                break;
            }
            return this.downstream.tryOnNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }

    static final class ParallelDoOnNextSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final Consumer<? super T> onNext;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription upstream;
        boolean done;

        ParallelDoOnNextSubscriber(Subscriber<? super T> actual, Consumer<? super T> onNext, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.downstream = actual;
            this.onNext = onNext;
            this.errorHandler = errorHandler;
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    this.onNext.accept(t);
                }
                catch (Throwable ex) {
                    ParallelFailureHandling h2;
                    Exceptions.throwIfFatal(ex);
                    try {
                        h2 = ObjectHelper.requireNonNull(this.errorHandler.apply((Long)(++retries), ex), "The errorHandler returned a null item");
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancel();
                        this.onError(new CompositeException(ex, exc));
                        return false;
                    }
                    switch (h2) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                break;
            }
            this.downstream.onNext(t);
            return true;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

