/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class FutureSubscriber<T>
extends CountDownLatch
implements FlowableSubscriber<T>,
Future<T>,
Subscription {
    T value;
    Throwable error;
    final AtomicReference<Subscription> upstream = new AtomicReference();

    public FutureSubscriber() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Subscription a;
        do {
            if ((a = this.upstream.get()) != this && a != SubscriptionHelper.CANCELLED) continue;
            return false;
        } while (!this.upstream.compareAndSet(a, SubscriptionHelper.CANCELLED));
        if (a != null) {
            a.cancel();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.upstream.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            if (!this.await(timeout, unit)) {
                throw new TimeoutException(ExceptionHelper.timeoutMessage(timeout, unit));
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public void onSubscribe(Subscription s2) {
        SubscriptionHelper.setOnce(this.upstream, s2, Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t) {
        if (this.value != null) {
            this.upstream.get().cancel();
            this.onError(new IndexOutOfBoundsException("More than one element received"));
            return;
        }
        this.value = t;
    }

    @Override
    public void onError(Throwable t) {
        Subscription a;
        do {
            if ((a = this.upstream.get()) == this || a == SubscriptionHelper.CANCELLED) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
        } while (!this.upstream.compareAndSet(a, this));
        this.countDown();
    }

    @Override
    public void onComplete() {
        Subscription a;
        if (this.value == null) {
            this.onError(new NoSuchElementException("The source is empty"));
            return;
        }
        do {
            if ((a = this.upstream.get()) != this && a != SubscriptionHelper.CANCELLED) continue;
            return;
        } while (!this.upstream.compareAndSet(a, this));
        this.countDown();
    }

    @Override
    public void cancel() {
    }

    @Override
    public void request(long n) {
    }
}

