/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscriptions;

import io.reactivex.exceptions.ProtocolViolationException;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public enum SubscriptionHelper implements Subscription
{
    CANCELLED;


    @Override
    public void request(long n) {
    }

    @Override
    public void cancel() {
    }

    public static boolean validate(Subscription current, Subscription next) {
        if (next == null) {
            RxJavaPlugins.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return false;
        }
        return true;
    }

    public static void reportSubscriptionSet() {
        RxJavaPlugins.onError(new ProtocolViolationException("Subscription already set!"));
    }

    public static boolean validate(long n) {
        if (n <= 0L) {
            RxJavaPlugins.onError(new IllegalArgumentException("n > 0 required but it was " + n));
            return false;
        }
        return true;
    }

    public static void reportMoreProduced(long n) {
        RxJavaPlugins.onError(new ProtocolViolationException("More produced than requested: " + n));
    }

    public static boolean set(AtomicReference<Subscription> field, Subscription s2) {
        Subscription current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s2 != null) {
                s2.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s2));
        if (current != null) {
            current.cancel();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Subscription> field, Subscription s2) {
        ObjectHelper.requireNonNull(s2, "s is null");
        if (!field.compareAndSet(null, s2)) {
            s2.cancel();
            if (field.get() != CANCELLED) {
                SubscriptionHelper.reportSubscriptionSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<Subscription> field, Subscription s2) {
        Subscription current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s2 != null) {
                s2.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s2));
        return true;
    }

    public static boolean cancel(AtomicReference<Subscription> field) {
        Subscription current = field.get();
        if (current != CANCELLED && (current = field.getAndSet(CANCELLED)) != CANCELLED) {
            if (current != null) {
                current.cancel();
            }
            return true;
        }
        return false;
    }

    public static boolean deferredSetOnce(AtomicReference<Subscription> field, AtomicLong requested, Subscription s2) {
        if (SubscriptionHelper.setOnce(field, s2)) {
            long r = requested.getAndSet(0L);
            if (r != 0L) {
                s2.request(r);
            }
            return true;
        }
        return false;
    }

    public static void deferredRequest(AtomicReference<Subscription> field, AtomicLong requested, long n) {
        Subscription s2 = field.get();
        if (s2 != null) {
            s2.request(n);
        } else if (SubscriptionHelper.validate(n)) {
            long r;
            BackpressureHelper.add(requested, n);
            s2 = field.get();
            if (s2 != null && (r = requested.getAndSet(0L)) != 0L) {
                s2.request(r);
            }
        }
    }

    public static boolean setOnce(AtomicReference<Subscription> field, Subscription s2, long request) {
        if (SubscriptionHelper.setOnce(field, s2)) {
            s2.request(request);
            return true;
        }
        return false;
    }
}

