/*
 * Decompiled with CFR 0.152.
 */
package jodd.chalk;

import jodd.chalk.Chalk;

public class Chalk256
extends Chalk<Chalk256> {
    private static final String[] FG_CODES;
    private static final String[] BG_CODES;

    public static Chalk256 chalk() {
        return new Chalk256();
    }

    public Chalk256 standard(int index) {
        this.startSequence(FG_CODES[this.index(index, 0, 8)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 bright(int index) {
        this.startSequence(FG_CODES[this.index(index, 8, 16)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 rgb(int index) {
        this.startSequence(FG_CODES[this.index(index, 16, 232)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 rgb(int r, int b, int g2) {
        this.startSequence(FG_CODES[this.index(36 * r + 6 * g2 + b, 16, 232)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 grayscale(int index) {
        this.startSequence(FG_CODES[this.index(index, 232, 256)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 bgStandard(int index) {
        this.startSequence(BG_CODES[this.index(index, 0, 8)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 bgBright(int index) {
        this.startSequence(BG_CODES[this.index(index, 8, 16)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 bgRgb(int index) {
        this.startSequence(BG_CODES[this.index(index, 16, 232)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 bgRgb(int r, int b, int g2) {
        this.startSequence(BG_CODES[this.index(36 * r + 6 * g2 + b, 16, 232)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    public Chalk256 bgGrayscale(int index) {
        this.startSequence(BG_CODES[this.index(index, 232, 256)]);
        this.endSequence("0");
        return (Chalk256)this._this();
    }

    private int index(int index, int from, int to) {
        if ((index += from) < from || index >= to) {
            throw new IllegalArgumentException("Color index not in range: [0, " + (to - from) + "]");
        }
        return index;
    }

    static {
        int i;
        FG_CODES = new String[256];
        BG_CODES = new String[256];
        for (i = 0; i < FG_CODES.length; ++i) {
            Chalk256.FG_CODES[i] = "38;5;" + i;
        }
        for (i = 0; i < BG_CODES.length; ++i) {
            Chalk256.BG_CODES[i] = "48;5;" + i;
        }
    }
}

