/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.IOException;
import java.io.Writer;
import jodd.buffer.FastCharBuffer;

public class FastCharArrayWriter
extends Writer {
    private final FastCharBuffer buffer;

    public FastCharArrayWriter() {
        this(1024);
    }

    public FastCharArrayWriter(int size) {
        this.buffer = new FastCharBuffer(size);
    }

    @Override
    public void write(char[] b, int off, int len) {
        this.buffer.append(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.append((char)b);
    }

    @Override
    public void write(String s2, int off, int len) {
        this.write(s2.toCharArray(), off, len);
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public void reset() {
        this.buffer.clear();
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buffer.toArray());
    }

    public char[] toCharArray() {
        return this.buffer.toArray();
    }

    public String toString() {
        return new String(this.toCharArray());
    }
}

