/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.util.ArrayList;
import java.util.Collection;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.impl.ArrayConverter;
import jodd.util.StringUtil;

public class ShortArrayConverter
implements TypeConverter<short[]> {
    protected final TypeConverterManager typeConverterManager;

    public ShortArrayConverter(TypeConverterManager typeConverterManager) {
        this.typeConverterManager = typeConverterManager;
    }

    @Override
    public short[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected short convertType(Object value) {
        return this.typeConverterManager.convertType(value, Short.TYPE);
    }

    protected short[] convertToSingleElementArray(Object value) {
        return new short[]{this.convertType(value)};
    }

    protected short[] convertValueToArray(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            short[] target = new short[collection.size()];
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            ArrayList<Short> shortArrayList = new ArrayList<Short>();
            for (Object element : iterable) {
                short convertedValue = this.convertType(element);
                shortArrayList.add(convertedValue);
            }
            short[] array = new short[shortArrayList.size()];
            for (int i = 0; i < shortArrayList.size(); ++i) {
                Short s2 = (Short)shortArrayList.get(i);
                array[i] = s2;
            }
            return array;
        }
        if (value instanceof CharSequence) {
            String[] strings = StringUtil.splitc(value.toString(), ArrayConverter.NUMBER_DELIMITERS);
            return this.convertArrayToArray(strings);
        }
        return this.convertToSingleElementArray(value);
    }

    protected short[] convertArrayToArray(Object value) {
        short[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = new short[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected short[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        short[] result;
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    result = null;
                                    if (primitiveComponentType == Short.TYPE) {
                                        return (short[])value;
                                    }
                                    if (primitiveComponentType != Integer.TYPE) break block8;
                                    int[] array = (int[])value;
                                    result = new short[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = (short)array[i];
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Long.TYPE) break block10;
                                long[] array = (long[])value;
                                result = new short[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = (short)array[i];
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Float.TYPE) break block11;
                            float[] array = (float[])value;
                            result = new short[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = (short)array[i];
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Double.TYPE) break block12;
                        double[] array = (double[])value;
                        result = new short[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = (short)array[i];
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Byte.TYPE) break block13;
                    byte[] array = (byte[])value;
                    result = new short[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = array[i];
                    }
                    break block9;
                }
                if (primitiveComponentType != Character.TYPE) break block14;
                char[] array = (char[])value;
                result = new short[array.length];
                for (int i = 0; i < array.length; ++i) {
                    result[i] = (short)array[i];
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = new short[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = (short)(array[i] ? 1 : 0);
            }
        }
        return result;
    }
}

