/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

public class Bits {
    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static char getChar(byte[] b, int off) {
        return (char)((b[off + 1] & 0xFF) + (b[off] << 8));
    }

    public static short getShort(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) + (b[off] << 8));
    }

    public static int getInt(byte[] b, int off) {
        return (b[off + 3] & 0xFF) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + (b[off] << 24);
    }

    public static float getFloat(byte[] b, int off) {
        int i = Bits.getInt(b, off);
        return Float.intBitsToFloat(i);
    }

    public static long getLong(byte[] b, int off) {
        return ((long)b[off + 7] & 0xFFL) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off] << 56);
    }

    public static double getDouble(byte[] b, int off) {
        long j = Bits.getLong(b, off);
        return Double.longBitsToDouble(j);
    }

    public static void putBoolean(byte[] b, int off, boolean val2) {
        b[off] = (byte)(val2 ? 1 : 0);
    }

    public static void putChar(byte[] b, int off, char val2) {
        b[off + 1] = (byte)val2;
        b[off] = (byte)(val2 >>> 8);
    }

    public static void putShort(byte[] b, int off, short val2) {
        b[off + 1] = (byte)val2;
        b[off] = (byte)(val2 >>> 8);
    }

    public static void putInt(byte[] b, int off, int val2) {
        b[off + 3] = (byte)val2;
        b[off + 2] = (byte)(val2 >>> 8);
        b[off + 1] = (byte)(val2 >>> 16);
        b[off] = (byte)(val2 >>> 24);
    }

    public static void putFloat(byte[] b, int off, float val2) {
        int i = Float.floatToIntBits(val2);
        Bits.putInt(b, off, i);
    }

    public static void putLong(byte[] b, int off, long val2) {
        b[off + 7] = (byte)val2;
        b[off + 6] = (byte)(val2 >>> 8);
        b[off + 5] = (byte)(val2 >>> 16);
        b[off + 4] = (byte)(val2 >>> 24);
        b[off + 3] = (byte)(val2 >>> 32);
        b[off + 2] = (byte)(val2 >>> 40);
        b[off + 1] = (byte)(val2 >>> 48);
        b[off] = (byte)(val2 >>> 56);
    }

    public static void putDouble(byte[] b, int off, double val2) {
        long j = Double.doubleToLongBits(val2);
        Bits.putLong(b, off, j);
    }

    public static boolean isSet(byte value, byte mask) {
        return (value & mask) == mask;
    }

    public static boolean isSet(int value, int mask) {
        return (value & mask) == mask;
    }

    public static boolean notSet(int value, int mask) {
        return (value & mask) != mask;
    }

    public static int set(int value, int mask, boolean setBit) {
        return setBit ? value | mask : value & ~mask;
    }

    public static byte set(byte value, byte mask, boolean setBit) {
        return (byte)(setBit ? value | mask : value & ~mask);
    }
}

