/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import jodd.exception.UncheckedException;
import jodd.io.StreamUtil;
import jodd.io.findfile.ClassScanner;
import jodd.template.StringTemplateParser;
import jodd.util.StringUtil;

public class PropertiesUtil {
    private static final StringTemplateParser stp = new StringTemplateParser();

    public static Properties createFromFile(String fileName) throws IOException {
        return PropertiesUtil.createFromFile(new File(fileName));
    }

    public static Properties createFromFile(File file) throws IOException {
        Properties prop = new Properties();
        PropertiesUtil.loadFromFile(prop, file);
        return prop;
    }

    public static void loadFromFile(Properties p, String fileName) throws IOException {
        PropertiesUtil.loadFromFile(p, new File(fileName));
    }

    public static void loadFromFile(Properties p, File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            p.load(fis);
        }
        catch (Throwable throwable) {
            StreamUtil.close(fis);
            throw throwable;
        }
        StreamUtil.close(fis);
    }

    public static void writeToFile(Properties p, String fileName) throws IOException {
        PropertiesUtil.writeToFile(p, new File(fileName), null);
    }

    public static void writeToFile(Properties p, String fileName, String header) throws IOException {
        PropertiesUtil.writeToFile(p, new File(fileName), header);
    }

    public static void writeToFile(Properties p, File file) throws IOException {
        PropertiesUtil.writeToFile(p, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(Properties p, File file, String header) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            p.store(fos, header);
        }
        catch (Throwable throwable) {
            StreamUtil.close(fos);
            throw throwable;
        }
        StreamUtil.close(fos);
    }

    public static Properties createFromString(String data) throws IOException {
        Properties p = new Properties();
        PropertiesUtil.loadFromString(p, data);
        return p;
    }

    public static void loadFromString(Properties p, String data) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes("ISO-8859-1"));){
            p.load(is);
        }
    }

    public static Properties subset(Properties p, String prefix, boolean stripPrefix) {
        if (StringUtil.isBlank(prefix)) {
            return p;
        }
        if (!prefix.endsWith(".")) {
            prefix = prefix + '.';
        }
        Properties result = new Properties();
        int baseLen = prefix.length();
        for (Object o : p.keySet()) {
            String key = (String)o;
            if (!key.startsWith(prefix)) continue;
            result.setProperty(stripPrefix ? key.substring(baseLen) : key, p.getProperty(key));
        }
        return result;
    }

    public static Properties createFromClasspath(String ... rootTemplate) {
        Properties p = new Properties();
        return PropertiesUtil.loadFromClasspath(p, rootTemplate);
    }

    public static Properties loadFromClasspath(Properties p, String ... rootTemplate) {
        ClassScanner.create().registerEntryConsumer(entryData -> UncheckedException.runAndWrapException(() -> p.load(entryData.openInputStream()))).includeResources(true).ignoreException(true).excludeAllEntries(true).includeEntries(rootTemplate).scanDefaultClasspath();
        return p;
    }

    public static String getProperty(Map map, String key) {
        return PropertiesUtil.getProperty(map, key, null);
    }

    public static String getProperty(Map map, String key, String defaultValue) {
        Object val2 = map.get(key);
        return val2 instanceof String ? (String)val2 : defaultValue;
    }

    public static void resolveAllVariables(Properties prop) {
        for (Object o : prop.keySet()) {
            String key = (String)o;
            String value = PropertiesUtil.resolveProperty(prop, key);
            prop.setProperty(key, value);
        }
    }

    public static String resolveProperty(Map map, String key) {
        String value = PropertiesUtil.getProperty(map, key);
        if (value == null) {
            return null;
        }
        value = stp.parse(value, macroName -> PropertiesUtil.getProperty(map, macroName));
        return value;
    }

    static {
        stp.setParseValues(true);
    }
}

