/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.Serializable;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RAtomicLongReactive;
import org.redisson.api.RBitSet;
import org.redisson.api.RBitSetReactive;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBlockingQueueReactive;
import org.redisson.api.RBucket;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RDeque;
import org.redisson.api.RDequeReactive;
import org.redisson.api.RHyperLogLog;
import org.redisson.api.RHyperLogLogReactive;
import org.redisson.api.RLexSortedSet;
import org.redisson.api.RLexSortedSetReactive;
import org.redisson.api.RList;
import org.redisson.api.RListReactive;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.api.RObject;
import org.redisson.api.RObjectReactive;
import org.redisson.api.RQueue;
import org.redisson.api.RQueueReactive;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RScoredSortedSetReactive;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RSetCacheReactive;
import org.redisson.api.RSetReactive;
import org.redisson.api.annotation.REntity;
import org.redisson.client.codec.Codec;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.misc.BiHashMap;

public class RedissonReference
implements Serializable {
    private static final long serialVersionUID = -2378564460151709127L;
    private static final BiHashMap<String, String> REACTIVE_MAP = new BiHashMap();
    private String type;
    private String keyName;
    private String codec;

    public static void warmUp() {
    }

    public RedissonReference() {
    }

    public RedissonReference(Class<?> type, String keyName) {
        this(type, keyName, null);
    }

    public RedissonReference(Class<?> type, String keyName, Codec codec) {
        if (!(ClassUtils.isAnnotationPresent(type, REntity.class) || RObject.class.isAssignableFrom(type) || RObjectReactive.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject or RLiveObject or RObjectReactive");
        }
        this.type = RObjectReactive.class.isAssignableFrom(type) ? REACTIVE_MAP.get(type.getName()) : type.getName();
        this.keyName = keyName;
        if (codec != null) {
            this.codec = codec.getClass().getName();
        }
    }

    public Class<?> getType() throws ClassNotFoundException {
        return Class.forName(this.type);
    }

    public Class<?> getReactiveType() throws ClassNotFoundException {
        if (REACTIVE_MAP.containsValue(this.type)) {
            return Class.forName(REACTIVE_MAP.reverseGet(this.type));
        }
        throw new ClassNotFoundException("There is no Reactive compatible type for " + this.type);
    }

    public String getTypeName() {
        return this.type;
    }

    public String getReactiveTypeName() {
        return this.type + "Reactive";
    }

    public void setType(Class<?> type) {
        if (!(ClassUtils.isAnnotationPresent(type, REntity.class) || RObject.class.isAssignableFrom(type) && RObjectReactive.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject or RLiveObject or RObjectReactive");
        }
        this.type = type.getName();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getCodec() {
        return this.codec;
    }

    public Class<? extends Codec> getCodecType() throws ClassNotFoundException {
        if (this.codec != null) {
            return Class.forName(this.codec);
        }
        return null;
    }

    public String getCodecName() {
        return this.codec;
    }

    public void setCodecType(Class<? extends Codec> codec) {
        this.codec = codec.getName();
    }

    static {
        REACTIVE_MAP.put(RAtomicLongReactive.class.getName(), RAtomicLong.class.getName());
        REACTIVE_MAP.put(RBitSetReactive.class.getName(), RBitSet.class.getName());
        REACTIVE_MAP.put(RBlockingQueueReactive.class.getName(), RBlockingQueue.class.getName());
        REACTIVE_MAP.put(RBucketReactive.class.getName(), RBucket.class.getName());
        REACTIVE_MAP.put(RDequeReactive.class.getName(), RDeque.class.getName());
        REACTIVE_MAP.put(RHyperLogLogReactive.class.getName(), RHyperLogLog.class.getName());
        REACTIVE_MAP.put(RLexSortedSetReactive.class.getName(), RLexSortedSet.class.getName());
        REACTIVE_MAP.put(RListReactive.class.getName(), RList.class.getName());
        REACTIVE_MAP.put(RMapCacheReactive.class.getName(), RMapCache.class.getName());
        REACTIVE_MAP.put(RMapReactive.class.getName(), RMap.class.getName());
        REACTIVE_MAP.put(RQueueReactive.class.getName(), RQueue.class.getName());
        REACTIVE_MAP.put(RScoredSortedSetReactive.class.getName(), RScoredSortedSet.class.getName());
        REACTIVE_MAP.put(RSetCacheReactive.class.getName(), RSetCache.class.getName());
        REACTIVE_MAP.put(RSetReactive.class.getName(), RSet.class.getName());
        REACTIVE_MAP.makeImmutable();
    }
}

