/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class RedissonListIterator<V>
implements ListIterator<V> {
    private V prevCurrentValue;
    private V nextCurrentValue;
    private V currentValueHasRead;
    private int currentIndex;
    private boolean hasBeenModified = true;

    public RedissonListIterator(int startIndex) {
        this.currentIndex = startIndex - 1;
    }

    public abstract V getValue(int var1);

    public abstract V remove(int var1);

    public abstract void fastSet(int var1, V var2);

    public abstract void add(int var1, V var2);

    @Override
    public boolean hasNext() {
        V val2 = this.getValue(this.currentIndex + 1);
        if (val2 != null) {
            this.nextCurrentValue = val2;
        }
        return val2 != null;
    }

    @Override
    public V next() {
        if (this.nextCurrentValue == null && !this.hasNext()) {
            throw new NoSuchElementException("No such element at index " + this.currentIndex);
        }
        ++this.currentIndex;
        this.currentValueHasRead = this.nextCurrentValue;
        this.nextCurrentValue = null;
        this.hasBeenModified = false;
        return this.currentValueHasRead;
    }

    @Override
    public void remove() {
        if (this.currentValueHasRead == null) {
            throw new IllegalStateException("Neither next nor previous have been called");
        }
        if (this.hasBeenModified) {
            throw new IllegalStateException("Element been already deleted");
        }
        this.remove(this.currentIndex);
        --this.currentIndex;
        this.hasBeenModified = true;
        this.currentValueHasRead = null;
    }

    @Override
    public boolean hasPrevious() {
        if (this.currentIndex < 0) {
            return false;
        }
        V val2 = this.getValue(this.currentIndex);
        if (val2 != null) {
            this.prevCurrentValue = val2;
        }
        return val2 != null;
    }

    @Override
    public V previous() {
        if (this.prevCurrentValue == null && !this.hasPrevious()) {
            throw new NoSuchElementException("No such element at index " + this.currentIndex);
        }
        --this.currentIndex;
        this.hasBeenModified = false;
        this.currentValueHasRead = this.prevCurrentValue;
        this.prevCurrentValue = null;
        return this.currentValueHasRead;
    }

    @Override
    public int nextIndex() {
        return this.currentIndex + 1;
    }

    @Override
    public int previousIndex() {
        return this.currentIndex;
    }

    @Override
    public void set(V e) {
        if (this.hasBeenModified) {
            throw new IllegalStateException();
        }
        this.fastSet(this.currentIndex, e);
    }

    @Override
    public void add(V e) {
        this.add(this.currentIndex + 1, e);
        ++this.currentIndex;
        this.hasBeenModified = true;
    }
}

