/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.redisson.misc.RPromise;

public class CountableListener<T>
implements BiConsumer<Object, Throwable> {
    protected final AtomicInteger counter = new AtomicInteger();
    protected final RPromise<T> result;
    protected final T value;

    public CountableListener() {
        this(null, null);
    }

    public CountableListener(RPromise<T> result, T value) {
        this(result, value, 0);
    }

    public CountableListener(RPromise<T> result, T value, int count) {
        this.result = result;
        this.value = value;
        this.counter.set(count);
    }

    public void setCounter(int newValue) {
        this.counter.set(newValue);
    }

    public void decCounter() {
        if (this.counter.decrementAndGet() == 0) {
            this.onSuccess(this.value);
            if (this.result != null) {
                this.result.trySuccess(this.value);
            }
        }
    }

    protected void onSuccess(T value) {
    }

    @Override
    public void accept(Object t, Throwable u) {
        if (u != null) {
            if (this.result != null) {
                this.result.tryFailure(u);
            }
            return;
        }
        this.decCounter();
    }
}

