/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

public final class HighwayHash {
    private final long[] v0 = new long[4];
    private final long[] v1 = new long[4];
    private final long[] mul0 = new long[4];
    private final long[] mul1 = new long[4];
    private boolean done = false;

    public HighwayHash(long key0, long key1, long key2, long key3) {
        this.reset(key0, key1, key2, key3);
    }

    public HighwayHash(long[] key) {
        if (key.length != 4) {
            throw new IllegalArgumentException(String.format("Key length (%s) must be 4", key.length));
        }
        this.reset(key[0], key[1], key[2], key[3]);
    }

    public void updatePacket(byte[] packet, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException(String.format("Pos (%s) must be positive", pos));
        }
        if (pos + 32 > packet.length) {
            throw new IllegalArgumentException("packet must have at least 32 bytes after pos");
        }
        long a0 = this.read64(packet, pos + 0);
        long a1 = this.read64(packet, pos + 8);
        long a2 = this.read64(packet, pos + 16);
        long a3 = this.read64(packet, pos + 24);
        this.update(a0, a1, a2, a3);
    }

    public void update(long a0, long a1, long a2, long a3) {
        if (this.done) {
            throw new IllegalStateException("Can compute a hash only once per instance");
        }
        this.v1[0] = this.v1[0] + (this.mul0[0] + a0);
        this.v1[1] = this.v1[1] + (this.mul0[1] + a1);
        this.v1[2] = this.v1[2] + (this.mul0[2] + a2);
        this.v1[3] = this.v1[3] + (this.mul0[3] + a3);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.mul0[n] = this.mul0[n] ^ (this.v1[i] & 0xFFFFFFFFL) * (this.v0[i] >>> 32);
            int n2 = i;
            this.v0[n2] = this.v0[n2] + this.mul1[i];
            int n3 = i;
            this.mul1[n3] = this.mul1[n3] ^ (this.v0[i] & 0xFFFFFFFFL) * (this.v1[i] >>> 32);
        }
        this.v0[0] = this.v0[0] + this.zipperMerge0(this.v1[1], this.v1[0]);
        this.v0[1] = this.v0[1] + this.zipperMerge1(this.v1[1], this.v1[0]);
        this.v0[2] = this.v0[2] + this.zipperMerge0(this.v1[3], this.v1[2]);
        this.v0[3] = this.v0[3] + this.zipperMerge1(this.v1[3], this.v1[2]);
        this.v1[0] = this.v1[0] + this.zipperMerge0(this.v0[1], this.v0[0]);
        this.v1[1] = this.v1[1] + this.zipperMerge1(this.v0[1], this.v0[0]);
        this.v1[2] = this.v1[2] + this.zipperMerge0(this.v0[3], this.v0[2]);
        this.v1[3] = this.v1[3] + this.zipperMerge1(this.v0[3], this.v0[2]);
    }

    public void updateRemainder(byte[] bytes, int pos, int size_mod32) {
        if (pos < 0) {
            throw new IllegalArgumentException(String.format("Pos (%s) must be positive", pos));
        }
        if (size_mod32 < 0 || size_mod32 >= 32) {
            throw new IllegalArgumentException(String.format("size_mod32 (%s) must be between 0 and 31", size_mod32));
        }
        if (pos + size_mod32 > bytes.length) {
            throw new IllegalArgumentException("bytes must have at least size_mod32 bytes after pos");
        }
        int size_mod4 = size_mod32 & 3;
        int remainder = size_mod32 & 0xFFFFFFFC;
        byte[] packet = new byte[32];
        int i = 0;
        while (i < 4) {
            int n = i++;
            this.v0[n] = this.v0[n] + (((long)size_mod32 << 32) + (long)size_mod32);
        }
        this.rotate32By(size_mod32, this.v1);
        for (i = 0; i < remainder; ++i) {
            packet[i] = bytes[pos + i];
        }
        if ((size_mod32 & 0x10) != 0) {
            for (i = 0; i < 4; ++i) {
                packet[28 + i] = bytes[pos + remainder + i + size_mod4 - 4];
            }
        } else if (size_mod4 != 0) {
            packet[16] = bytes[pos + remainder + 0];
            packet[17] = bytes[pos + remainder + (size_mod4 >>> 1)];
            packet[18] = bytes[pos + remainder + (size_mod4 - 1)];
        }
        this.updatePacket(packet, 0);
    }

    public long finalize64() {
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.done = true;
        return this.v0[0] + this.v1[0] + this.mul0[0] + this.mul1[0];
    }

    public long[] finalize128() {
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.done = true;
        long[] hash = new long[]{this.v0[0] + this.mul0[0] + this.v1[2] + this.mul1[2], this.v0[1] + this.mul0[1] + this.v1[3] + this.mul1[3]};
        return hash;
    }

    public long[] finalize256() {
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.permuteAndUpdate();
        this.done = true;
        long[] hash = new long[4];
        this.modularReduction(this.v1[1] + this.mul1[1], this.v1[0] + this.mul1[0], this.v0[1] + this.mul0[1], this.v0[0] + this.mul0[0], hash, 0);
        this.modularReduction(this.v1[3] + this.mul1[3], this.v1[2] + this.mul1[2], this.v0[3] + this.mul0[3], this.v0[2] + this.mul0[2], hash, 2);
        return hash;
    }

    private void reset(long key0, long key1, long key2, long key3) {
        this.mul0[0] = -2601156619688686033L;
        this.mul0[1] = -6626703657320631856L;
        this.mul0[2] = 1376283091369227076L;
        this.mul0[3] = 2611923443488327891L;
        this.mul1[0] = 4310963063287117203L;
        this.mul1[1] = -4563006886106789236L;
        this.mul1[2] = -4732044268327596948L;
        this.mul1[3] = 4983270260364809079L;
        this.v0[0] = this.mul0[0] ^ key0;
        this.v0[1] = this.mul0[1] ^ key1;
        this.v0[2] = this.mul0[2] ^ key2;
        this.v0[3] = this.mul0[3] ^ key3;
        this.v1[0] = this.mul1[0] ^ (key0 >>> 32 | key0 << 32);
        this.v1[1] = this.mul1[1] ^ (key1 >>> 32 | key1 << 32);
        this.v1[2] = this.mul1[2] ^ (key2 >>> 32 | key2 << 32);
        this.v1[3] = this.mul1[3] ^ (key3 >>> 32 | key3 << 32);
    }

    private long zipperMerge0(long v1, long v0) {
        return (v0 & 0xFF000000L | v1 & 0xFF00000000L) >>> 24 | (v0 & 0xFF0000000000L | v1 & 0xFF000000000000L) >>> 16 | v0 & 0xFF0000L | (v0 & 0xFF00L) << 32 | (v1 & 0xFF00000000000000L) >>> 8 | v0 << 56;
    }

    private long zipperMerge1(long v1, long v0) {
        return (v1 & 0xFF000000L | v0 & 0xFF00000000L) >>> 24 | v1 & 0xFF0000L | (v1 & 0xFF0000000000L) >>> 16 | (v1 & 0xFF00L) << 24 | (v0 & 0xFF000000000000L) >>> 8 | (v1 & 0xFFL) << 48 | v0 & 0xFF00000000000000L;
    }

    private long read64(byte[] src, int pos) {
        return (long)src[pos + 0] & 0xFFL | ((long)src[pos + 1] & 0xFFL) << 8 | ((long)src[pos + 2] & 0xFFL) << 16 | ((long)src[pos + 3] & 0xFFL) << 24 | ((long)src[pos + 4] & 0xFFL) << 32 | ((long)src[pos + 5] & 0xFFL) << 40 | ((long)src[pos + 6] & 0xFFL) << 48 | ((long)src[pos + 7] & 0xFFL) << 56;
    }

    private void rotate32By(long count, long[] lanes) {
        int i = 0;
        while (i < 4) {
            long half0 = lanes[i] & 0xFFFFFFFFL;
            long half1 = lanes[i] >>> 32 & 0xFFFFFFFFL;
            lanes[i] = half0 << (int)count & 0xFFFFFFFFL | half0 >>> (int)(32L - count);
            int n = i++;
            lanes[n] = lanes[n] | (half1 << (int)count & 0xFFFFFFFFL | half1 >>> (int)(32L - count)) << 32;
        }
    }

    private void permuteAndUpdate() {
        this.update(this.v0[2] >>> 32 | this.v0[2] << 32, this.v0[3] >>> 32 | this.v0[3] << 32, this.v0[0] >>> 32 | this.v0[0] << 32, this.v0[1] >>> 32 | this.v0[1] << 32);
    }

    private void modularReduction(long a3_unmasked, long a2, long a1, long a0, long[] hash, int pos) {
        long a3 = a3_unmasked & 0x3FFFFFFFFFFFFFFFL;
        hash[pos + 1] = a1 ^ (a3 << 1 | a2 >>> 63) ^ (a3 << 2 | a2 >>> 62);
        hash[pos + 0] = a0 ^ a2 << 1 ^ a2 << 2;
    }

    public static long hash64(byte[] data, int offset, int length, long[] key) {
        HighwayHash h2 = new HighwayHash(key);
        h2.processAll(data, offset, length);
        return h2.finalize64();
    }

    public static long[] hash128(byte[] data, int offset, int length, long[] key) {
        HighwayHash h2 = new HighwayHash(key);
        h2.processAll(data, offset, length);
        return h2.finalize128();
    }

    public static long[] hash256(byte[] data, int offset, int length, long[] key) {
        HighwayHash h2 = new HighwayHash(key);
        h2.processAll(data, offset, length);
        return h2.finalize256();
    }

    private void processAll(byte[] data, int offset, int length) {
        int i = 0;
        while (i + 32 <= length) {
            this.updatePacket(data, offset + i);
            i += 32;
        }
        if ((length & 0x1F) != 0) {
            this.updateRemainder(data, offset + i, length & 0x1F);
        }
    }
}

