/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class InfinitySemaphoreLatch
extends AbstractQueuedSynchronizer {
    private static final long serialVersionUID = 1744280161777661090L;
    volatile boolean closed;
    AtomicInteger sharedResources = new AtomicInteger();
    private static final int OPEN_STATE = 0;

    public InfinitySemaphoreLatch() {
        this.setState(0);
    }

    @Override
    public final int tryAcquireShared(int ignored) {
        return this.getState() == 0 ? 1 : -1;
    }

    @Override
    public final boolean tryReleaseShared(int state) {
        this.setState(state);
        return true;
    }

    public final boolean acquireAmount(int amount) {
        if (this.closed) {
            return false;
        }
        this.releaseShared(this.sharedResources.addAndGet(amount));
        return true;
    }

    public final boolean acquire() {
        if (this.closed) {
            return false;
        }
        this.releaseShared(this.sharedResources.incrementAndGet());
        return true;
    }

    public final void release() {
        this.releaseShared(this.sharedResources.decrementAndGet());
    }

    public boolean isOpened() {
        return this.getState() == 0;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }

    public final boolean awaitUninterruptibly() {
        try {
            return this.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquireSharedNanos(1, unit.toNanos(time));
    }

    @Override
    public String toString() {
        int s2 = this.getState();
        String q = this.hasQueuedThreads() ? "non" : "";
        return "ReclosableLatch [State = " + s2 + ", " + q + "empty queue]";
    }
}

