/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.Flowable;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;

public abstract class SetRxIterator<V> {
    public Flowable<V> create() {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private long nextIterPos;
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues();
                    this.completed = false;
                }
            }

            protected void nextValues() {
                SetRxIterator.this.scanIterator(this.client, this.nextIterPos).onComplete((res, e) -> {
                    if (e != null) {
                        p.onError((Throwable)e);
                        return;
                    }
                    if (this.finished) {
                        this.client = null;
                        this.nextIterPos = 0L;
                        return;
                    }
                    this.client = res.getRedisClient();
                    this.nextIterPos = res.getPos();
                    for (Object val2 : res.getValues()) {
                        p.onNext(val2);
                        this.elementsRead.incrementAndGet();
                    }
                    if (this.elementsRead.get() >= this.readAmount.get()) {
                        p.onComplete();
                        this.elementsRead.set(0L);
                        this.completed = true;
                        return;
                    }
                    if (res.getPos() == 0L && !SetRxIterator.this.tryAgain()) {
                        this.finished = true;
                        p.onComplete();
                    }
                    if (this.finished || this.completed) {
                        return;
                    }
                    this.nextValues();
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    protected abstract RFuture<ListScanResult<Object>> scanIterator(RedisClient var1, long var2);
}

