/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonObject;
import org.redisson.RedissonSet;
import org.redisson.api.RCollectionAsync;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RObject;
import org.redisson.api.SortOrder;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.Hash;
import org.redisson.misc.HashValue;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.transaction.BaseTransactionalObject;
import org.redisson.transaction.operation.DeleteOperation;
import org.redisson.transaction.operation.TouchOperation;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.UnlinkOperation;
import org.redisson.transaction.operation.set.MoveOperation;

public abstract class BaseTransactionalSet<V>
extends BaseTransactionalObject {
    static final Object NULL = new Object();
    private final long timeout;
    final Map<HashValue, Object> state = new HashMap<HashValue, Object>();
    final List<TransactionalOperation> operations;
    final RCollectionAsync<V> set;
    final RObject object;
    final String name;
    final CommandAsyncExecutor commandExecutor;
    Boolean deleted;

    public BaseTransactionalSet(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RCollectionAsync<V> set) {
        this.commandExecutor = commandExecutor;
        this.timeout = timeout;
        this.operations = operations;
        this.set = set;
        this.object = (RObject)((Object)set);
        this.name = this.object.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashValue toHash(Object value) {
        ByteBuf state = ((RedissonObject)((Object)this.set)).encode(value);
        try {
            HashValue hashValue = new HashValue(Hash.hash128(state));
            return hashValue;
        }
        finally {
            state.release();
        }
    }

    public RFuture<Boolean> isExistsAsync() {
        if (this.deleted != null) {
            return RedissonPromise.newSucceededFuture(this.deleted == false);
        }
        return this.set.isExistsAsync();
    }

    public RFuture<Boolean> unlinkAsync(CommandAsyncExecutor commandExecutor) {
        return this.deleteAsync(commandExecutor, new UnlinkOperation(this.name));
    }

    public RFuture<Boolean> touchAsync(CommandAsyncExecutor commandExecutor) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        if (this.deleted != null && this.deleted.booleanValue()) {
            this.operations.add(new TouchOperation(this.name));
            result.trySuccess(false);
            return result;
        }
        this.set.isExistsAsync().onComplete((exists, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            this.operations.add(new TouchOperation(this.name));
            if (!exists.booleanValue()) {
                for (Object value : this.state.values()) {
                    if (value == NULL) continue;
                    exists = true;
                    break;
                }
            }
            result.trySuccess((Boolean)exists);
        });
        return result;
    }

    public RFuture<Boolean> deleteAsync(CommandAsyncExecutor commandExecutor) {
        return this.deleteAsync(commandExecutor, new DeleteOperation(this.name));
    }

    protected RFuture<Boolean> deleteAsync(CommandAsyncExecutor commandExecutor, TransactionalOperation operation) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        if (this.deleted != null) {
            this.operations.add(operation);
            result.trySuccess(this.deleted == false);
            this.deleted = true;
            return result;
        }
        this.set.isExistsAsync().onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            this.operations.add(operation);
            this.state.replaceAll((k, v) -> NULL);
            this.deleted = true;
            result.trySuccess((Boolean)res);
        });
        return result;
    }

    public RFuture<Boolean> containsAsync(Object value) {
        for (Object val2 : this.state.values()) {
            if (val2 == NULL || !this.isEqual(val2, value)) continue;
            return RedissonPromise.newSucceededFuture(true);
        }
        return this.set.containsAsync(value);
    }

    protected abstract ListScanResult<Object> scanIteratorSource(String var1, RedisClient var2, long var3, String var5, int var6);

    protected ListScanResult<Object> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        ListScanResult<Object> res = this.scanIteratorSource(name, client, startPos, pattern, count);
        HashMap<HashValue, Object> newstate = new HashMap<HashValue, Object>(this.state);
        Iterator iterator = res.getValues().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object value = newstate.remove(this.toHash(e));
            if (value != NULL) continue;
            iterator.remove();
        }
        if (startPos == 0L) {
            for (Map.Entry entry : newstate.entrySet()) {
                if (entry.getValue() == NULL) continue;
                res.getValues().add(entry.getValue());
            }
        }
        return res;
    }

    protected abstract RFuture<Set<V>> readAllAsyncSource();

    public RFuture<Set<V>> readAllAsync() {
        RedissonPromise<Set<V>> result = new RedissonPromise<Set<V>>();
        RFuture<Set<Set>> future = this.readAllAsyncSource();
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            Set set = (Set)future.getNow();
            HashMap<HashValue, Object> newstate = new HashMap<HashValue, Object>(this.state);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Object value = newstate.remove(this.toHash(key));
                if (value != NULL) continue;
                iterator.remove();
            }
            for (Object value : newstate.values()) {
                if (value == NULL) continue;
                set.add(value);
            }
            result.trySuccess(set);
        });
        return result;
    }

    public RFuture<Boolean> addAsync(V value) {
        long threadId = Thread.currentThread().getId();
        TransactionalOperation operation = this.createAddOperation(value, threadId);
        return this.addAsync(value, operation);
    }

    public RFuture<Boolean> addAsync(final V value, final TransactionalOperation operation) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, value, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalSet.this.toHash(value);
                Object entry = BaseTransactionalSet.this.state.get(keyHash);
                if (entry != null) {
                    BaseTransactionalSet.this.operations.add(operation);
                    BaseTransactionalSet.this.state.put(keyHash, value);
                    if (BaseTransactionalSet.this.deleted != null) {
                        BaseTransactionalSet.this.deleted = false;
                    }
                    result.trySuccess(entry == NULL);
                    return;
                }
                BaseTransactionalSet.this.set.containsAsync(value).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalSet.this.operations.add(operation);
                    BaseTransactionalSet.this.state.put(keyHash, value);
                    if (BaseTransactionalSet.this.deleted != null) {
                        BaseTransactionalSet.this.deleted = false;
                    }
                    result.trySuccess(res == false);
                });
            }
        });
        return result;
    }

    protected abstract TransactionalOperation createAddOperation(V var1, long var2);

    public RFuture<V> removeRandomAsync() {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> removeRandomAsync(int amount) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Boolean> moveAsync(String destination, V value) {
        RedissonSet destinationSet = new RedissonSet(this.object.getCodec(), this.commandExecutor, destination, null);
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        RLock destinationLock = this.getLock(destinationSet, value);
        RLock lock = this.getLock(this.set, value);
        RedissonMultiLock multiLock = new RedissonMultiLock(destinationLock, lock);
        long threadId = Thread.currentThread().getId();
        multiLock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).onComplete((res, e) -> {
            if (e != null) {
                multiLock.unlockAsync(threadId);
                result.tryFailure((Throwable)e);
                return;
            }
            HashValue keyHash = this.toHash(value);
            Object currentValue = this.state.get(keyHash);
            if (currentValue != null) {
                this.operations.add(this.createMoveOperation(destination, value, threadId));
                if (currentValue == NULL) {
                    result.trySuccess(false);
                } else {
                    this.state.put(keyHash, NULL);
                    result.trySuccess(true);
                }
                return;
            }
            this.set.containsAsync(value).onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                this.operations.add(this.createMoveOperation(destination, value, threadId));
                if (r.booleanValue()) {
                    this.state.put(keyHash, NULL);
                }
                result.trySuccess((Boolean)r);
            });
        });
        return result;
    }

    protected abstract MoveOperation createMoveOperation(String var1, V var2, long var3);

    protected abstract RLock getLock(RCollectionAsync<V> var1, V var2);

    public RFuture<Boolean> removeAsync(final Object value) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        final long threadId = Thread.currentThread().getId();
        this.executeLocked(result, value, new Runnable(){

            @Override
            public void run() {
                HashValue keyHash = BaseTransactionalSet.this.toHash(value);
                Object currentValue = BaseTransactionalSet.this.state.get(keyHash);
                if (currentValue != null) {
                    BaseTransactionalSet.this.operations.add(BaseTransactionalSet.this.createRemoveOperation(value, threadId));
                    if (currentValue == NULL) {
                        result.trySuccess(false);
                    } else {
                        BaseTransactionalSet.this.state.put(keyHash, NULL);
                        result.trySuccess(true);
                    }
                    return;
                }
                BaseTransactionalSet.this.set.containsAsync(value).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    BaseTransactionalSet.this.operations.add(BaseTransactionalSet.this.createRemoveOperation(value, threadId));
                    if (res.booleanValue()) {
                        BaseTransactionalSet.this.state.put(keyHash, NULL);
                    }
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    protected abstract TransactionalOperation createRemoveOperation(Object var1, long var2);

    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        ArrayList coll = new ArrayList(c);
        Iterator iterator = coll.iterator();
        block0: while (iterator.hasNext()) {
            Object value = iterator.next();
            for (Object val2 : this.state.values()) {
                if (val2 == NULL || !this.isEqual(val2, value)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return this.set.containsAllAsync(coll);
    }

    public RFuture<Boolean> addAllAsync(final Collection<? extends V> c) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        final long threadId = Thread.currentThread().getId();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                BaseTransactionalSet.this.containsAllAsync(c).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    for (Object value : c) {
                        BaseTransactionalSet.this.operations.add(BaseTransactionalSet.this.createAddOperation(value, threadId));
                        HashValue keyHash = BaseTransactionalSet.this.toHash(value);
                        BaseTransactionalSet.this.state.put(keyHash, value);
                    }
                    if (BaseTransactionalSet.this.deleted != null) {
                        BaseTransactionalSet.this.deleted = false;
                    }
                    result.trySuccess(res == false);
                });
            }
        }, c);
        return result;
    }

    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Boolean> removeAllAsync(final Collection<?> c) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        final long threadId = Thread.currentThread().getId();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                BaseTransactionalSet.this.containsAllAsync(c).onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    for (Object value : c) {
                        BaseTransactionalSet.this.operations.add(BaseTransactionalSet.this.createRemoveOperation(value, threadId));
                        HashValue keyHash = BaseTransactionalSet.this.toHash(value);
                        BaseTransactionalSet.this.state.put(keyHash, NULL);
                    }
                    result.trySuccess(res == false);
                });
            }
        }, c);
        return result;
    }

    public RFuture<Integer> unionAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Integer> diffAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Integer> intersectionAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readUnionAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readDiffAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqual(Object value, Object oldValue) {
        ByteBuf valueBuf = ((RedissonObject)((Object)this.set)).encode(value);
        ByteBuf oldValueBuf = ((RedissonObject)((Object)this.set)).encode(oldValue);
        try {
            boolean bl = valueBuf.equals(oldValueBuf);
            return bl;
        }
        finally {
            valueBuf.readableBytes();
            oldValueBuf.readableBytes();
        }
    }

    protected <R> void executeLocked(RPromise<R> promise, Object value, Runnable runnable) {
        RLock lock = this.getLock(this.set, value);
        this.executeLocked(promise, runnable, lock);
    }

    protected <R> void executeLocked(RPromise<R> promise, Runnable runnable, RLock lock) {
        lock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).onComplete((res, e) -> {
            if (e == null) {
                runnable.run();
            } else {
                promise.tryFailure((Throwable)e);
            }
        });
    }

    protected <R> void executeLocked(RPromise<R> promise, Runnable runnable, Collection<?> values) {
        ArrayList<RLock> locks = new ArrayList<RLock>(values.size());
        for (Object value : values) {
            RLock lock = this.getLock(this.set, value);
            locks.add(lock);
        }
        RedissonMultiLock multiLock = new RedissonMultiLock(locks.toArray(new RLock[locks.size()]));
        long threadId = Thread.currentThread().getId();
        multiLock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).onComplete((res, e) -> {
            if (e == null) {
                runnable.run();
            } else {
                multiLock.unlockAsync(threadId);
                promise.tryFailure((Throwable)e);
            }
        });
    }
}

