/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.testing.dynamo;

import com.amazonaws.client.builder.AwsClientBuilder;
import io.github.devlibx.easy.testing.dynamo.TestingDynamoDbConfig;
import io.github.devlibx.easy.testing.mysql.TestingDynamoDbDataSource;
import java.lang.invoke.StringConcatFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dynamodb.DynaliteContainer;

public class DynamoExtension
implements ParameterResolver,
AfterEachCallback,
BeforeEachCallback {
    private static final Logger log = LoggerFactory.getLogger(DynamoExtension.class);
    private Map<String, DockerDynamoHolder> dockerDynamoDbHolderMap;
    private final String name;

    private DynamoExtension(String name) {
        this.name = name;
    }

    public static DynamoExtension builder(String name) {
        return new DynamoExtension(name);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        DockerDynamoHolder dockerMySqlHolder;
        String name = this.name;
        String dockerDynamoLName = "docker_" + name;
        ExtensionContext.Store store = context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
        this.dockerDynamoDbHolderMap = (Map)store.getOrComputeIfAbsent((Object)"__dynamo_docker_map__", _name -> new HashMap());
        if (!this.dockerDynamoDbHolderMap.containsKey(dockerDynamoLName)) {
            DockerDynamoHolder dockerMySqlHolder2 = new DockerDynamoHolder();
            this.dockerDynamoDbHolderMap.put(dockerDynamoLName, dockerMySqlHolder2);
        } else if (this.dockerDynamoDbHolderMap.containsKey(dockerDynamoLName) && !(dockerMySqlHolder = this.dockerDynamoDbHolderMap.get(dockerDynamoLName)).isRunning() && dockerMySqlHolder.dynamoDbContainerRunnable) {
            dockerMySqlHolder.start();
        }
    }

    private String findDataSourceNameFromMethodParameterAnnotation(ParameterContext parameterContext) {
        TestingDynamoDbDataSource dataSourceAnnotation = parameterContext.findAnnotation(TestingDynamoDbDataSource.class).orElse(null);
        String datasourceName = "default";
        if (dataSourceAnnotation != null) {
            datasourceName = dataSourceAnnotation.value();
        }
        return datasourceName;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean match;
        boolean bl = match = parameterContext.getParameter().getType() == TestingDynamoDbConfig.class || parameterContext.getParameter().getType() == DataSource.class;
        if (match) {
            String name = this.findDataSourceNameFromMethodParameterAnnotation(parameterContext);
            return Objects.equals(name, this.name);
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String datasourceName = this.findDataSourceNameFromMethodParameterAnnotation(parameterContext);
        if (!Objects.equals(datasourceName, this.name)) {
            return null;
        }
        if (parameterContext.getParameter().getType() == TestingDynamoDbConfig.class) {
            TestingDynamoDbConfig config = new TestingDynamoDbConfig();
            config.setEndpointConfiguration(this.getEndPoint(datasourceName));
            return config;
        }
        return null;
    }

    private AwsClientBuilder.EndpointConfiguration getEndPoint(String dataSourceName) {
        if (this.dockerDynamoDbHolderMap.containsKey("docker_" + dataSourceName) && this.dockerDynamoDbHolderMap.get("docker_" + dataSourceName).isRunning()) {
            return this.dockerDynamoDbHolderMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"docker_\u0001"}, (String)dataSourceName)).dynamoContainer.getEndpointConfiguration();
        }
        return null;
    }

    private boolean isRunning(String dataSourceName) {
        return this.dockerDynamoDbHolderMap.containsKey("docker_" + dataSourceName) && this.dockerDynamoDbHolderMap.get("docker_" + dataSourceName).isRunning();
    }

    private static class DockerDynamoHolder {
        private DynaliteContainer dynamoContainer;
        public boolean dynamoDbContainerRunnable = false;

        public DockerDynamoHolder() {
            this.start();
        }

        private void start() {
            try {
                log.info("Try to create a client for docker dynamo - to see if we can use docker mysql");
                this.dynamoContainer = new DynaliteContainer();
                this.dynamoContainer.start();
                this.dynamoDbContainerRunnable = true;
                log.info("docker dynamodb available");
            }
            catch (Exception e) {
                log.error("failed to start docker dynamodb: error={}", (Object)e.getMessage());
                this.dynamoContainer = null;
                e.printStackTrace();
            }
        }

        public boolean isRunning() {
            if (this.dynamoContainer != null) {
                return this.dynamoContainer.isRunning();
            }
            return false;
        }
    }
}

