/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.testing.mysql;

import ch.qos.logback.classic.Level;
import com.zaxxer.hikari.HikariDataSource;
import io.gitbub.devlibx.easy.helper.LoggingHelper;
import io.gitbub.devlibx.easy.helper.Safe;
import io.github.devlibx.easy.testing.mysql.TestingMySqlConfig;
import io.github.devlibx.easy.testing.mysql.TestingMySqlDataSource;
import java.lang.invoke.StringConcatFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;

public class MySqlExtension
implements ParameterResolver,
AfterEachCallback,
BeforeEachCallback {
    private static final Logger log = LoggerFactory.getLogger(MySqlExtension.class);
    public static final String DEFAULT_DATASOURCE_NAME = "default";
    public static final String DATASOURCE_NAME_PREFIX = "dataSourceName";
    private Map<String, DockerMySqlHolder> dockerMySqlHolderMap;
    private Map<String, LocalMySqlHolder> localMySqlHolderMap;
    private String database;
    private String username;
    private String password;
    private String host;
    private int port;
    private String name;

    private String findDataSourceByTagName(ExtensionContext context) {
        AtomicReference<String> name = new AtomicReference<String>(DEFAULT_DATASOURCE_NAME);
        context.getTags().forEach(tag -> {
            if (tag.startsWith("dataSourceName=")) {
                StringTokenizer st = new StringTokenizer((String)tag, "=");
                st.nextToken();
                name.set(st.nextToken());
            }
        });
        return name.get();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        DockerMySqlHolder dockerMySqlHolder;
        LocalMySqlHolder localMySqlHolder;
        LoggingHelper.setupLogging();
        LoggingHelper.getLogger(DockerClientProviderStrategy.class).setLevel(Level.OFF);
        LoggingHelper.getLogger(AbstrDockerCmd.class).setLevel(Level.OFF);
        String name = this.name;
        String dockerMySQLName = "docker_" + name;
        String localMySQLName = "local_" + name;
        TestingMySqlConfig config = new TestingMySqlConfig();
        config.setHost(this.host);
        config.setPort(this.port);
        config.setDatabase(this.database);
        config.setUsername(this.username);
        config.setPassword(this.password);
        ExtensionContext.Store store = context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
        this.localMySqlHolderMap = (Map)store.getOrComputeIfAbsent((Object)"__mysql_local_map__", _name -> new HashMap());
        this.dockerMySqlHolderMap = (Map)store.getOrComputeIfAbsent((Object)"__mysql_docker_map__", _name -> new HashMap());
        if (!this.localMySqlHolderMap.containsKey(localMySQLName)) {
            localMySqlHolder = new LocalMySqlHolder(config);
            this.localMySqlHolderMap.put(localMySQLName, localMySqlHolder);
            if (localMySqlHolder.isRunning()) {
                return;
            }
        } else if (this.localMySqlHolderMap.containsKey(localMySQLName) && (localMySqlHolder = this.localMySqlHolderMap.get(localMySQLName)).isRunning()) {
            return;
        }
        if (!this.dockerMySqlHolderMap.containsKey(dockerMySQLName)) {
            dockerMySqlHolder = new DockerMySqlHolder(config);
            this.dockerMySqlHolderMap.put(dockerMySQLName, dockerMySqlHolder);
        } else if (this.dockerMySqlHolderMap.containsKey(dockerMySQLName) && !(dockerMySqlHolder = this.dockerMySqlHolderMap.get(dockerMySQLName)).isRunning() && dockerMySqlHolder.mySqlContainerRunnable) {
            dockerMySqlHolder.start(config);
        }
    }

    public static MySqlExtensionBuilder builder(String name) {
        return new MySqlExtensionBuilder(name);
    }

    public static MySqlExtensionBuilder builder() {
        return new MySqlExtensionBuilder(DEFAULT_DATASOURCE_NAME);
    }

    private String findDataSourceNameFromMethodParameterAnnotation(ParameterContext parameterContext) {
        TestingMySqlDataSource dataSourceAnnotation = parameterContext.findAnnotation(TestingMySqlDataSource.class).orElse(null);
        String datasourceName = DEFAULT_DATASOURCE_NAME;
        if (dataSourceAnnotation != null) {
            datasourceName = dataSourceAnnotation.value();
        }
        return datasourceName;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean match;
        boolean bl = match = parameterContext.getParameter().getType() == TestingMySqlConfig.class || parameterContext.getParameter().getType() == DataSource.class;
        if (match) {
            String name = this.findDataSourceNameFromMethodParameterAnnotation(parameterContext);
            return Objects.equals(name, this.name);
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String datasourceName = this.findDataSourceNameFromMethodParameterAnnotation(parameterContext);
        if (!Objects.equals(datasourceName, this.name)) {
            return null;
        }
        if (parameterContext.getParameter().getType() == TestingMySqlConfig.class) {
            TestingMySqlConfig config = new TestingMySqlConfig();
            config.setRunning(this.isMySqlRunning(datasourceName));
            if (config.isRunning()) {
                config.setJdbcUrl(this.getJdbcUrl(datasourceName));
                config.setUsername(this.username);
                config.setPassword(this.password);
            }
            return config;
        }
        if (parameterContext.getParameter().getType() == DataSource.class && this.isMySqlRunning(datasourceName)) {
            HikariDataSource dataSource = new HikariDataSource();
            dataSource.setJdbcUrl(this.getJdbcUrl(datasourceName));
            dataSource.setDriverClassName("com.mysql.jdbc.Driver");
            dataSource.setUsername(this.username);
            dataSource.setPassword(this.password);
            extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)"datasource", (Object)dataSource);
            return dataSource;
        }
        return null;
    }

    private boolean isMySqlRunning(String dataSourceName) {
        if (this.localMySqlHolderMap.containsKey("local_" + dataSourceName) && this.localMySqlHolderMap.get("local_" + dataSourceName).isRunning()) {
            return true;
        }
        return this.dockerMySqlHolderMap.containsKey("docker_" + dataSourceName) && this.dockerMySqlHolderMap.get("docker_" + dataSourceName).isRunning();
    }

    private String getJdbcUrl(String dataSourceName) {
        if (this.localMySqlHolderMap.containsKey("local_" + dataSourceName) && this.localMySqlHolderMap.get("local_" + dataSourceName).isRunning()) {
            return this.localMySqlHolderMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"local_\u0001"}, (String)dataSourceName)).jdbcUrl;
        }
        if (this.dockerMySqlHolderMap.containsKey("docker_" + dataSourceName) && this.dockerMySqlHolderMap.get("docker_" + dataSourceName).isRunning()) {
            return this.dockerMySqlHolderMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"docker_\u0001"}, (String)dataSourceName)).mySQLContainer.getJdbcUrl();
        }
        return null;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Safe.safe(() -> {
            HikariDataSource dataSource = (HikariDataSource)context.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)"datasource");
            if (dataSource != null) {
                dataSource.close();
            }
        });
    }

    private static class LocalMySqlHolder {
        private final TestingMySqlConfig config;
        private final HikariDataSource dataSource;
        private final String jdbcUrl;

        public LocalMySqlHolder(TestingMySqlConfig config) {
            this.config = config;
            this.jdbcUrl = String.format("jdbc:mysql://%s:%d/%s?useSSL=false", config.getHost(), config.getPort(), config.getDatabase());
            this.dataSource = this.getDatasource();
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public boolean isRunning() {
            try (Connection connection = this.dataSource.getConnection();){
                boolean bl;
                block14: {
                    PreparedStatement statement = connection.prepareStatement("SELECT 1;");
                    try {
                        ResultSet resultset = statement.executeQuery();
                        bl = resultset.next();
                        if (statement == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return bl;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void close() {
            Safe.safe(() -> {
                if (this.dataSource != null) {
                    this.dataSource.close();
                }
            });
        }

        private HikariDataSource getDatasource() {
            HikariDataSource dataSource = new HikariDataSource();
            dataSource.setJdbcUrl(this.jdbcUrl);
            dataSource.setDriverClassName("com.mysql.jdbc.Driver");
            dataSource.setUsername(this.config.getUsername());
            dataSource.setPassword(this.config.getPassword());
            return dataSource;
        }
    }

    private static class DockerMySqlHolder {
        private MySQLContainer mySQLContainer;
        public boolean mySqlContainerRunnable = false;

        public DockerMySqlHolder(TestingMySqlConfig config) {
            this.start(config);
        }

        private void start(TestingMySqlConfig config) {
            try {
                log.info("Try to create a client for docker mysql - to see if we can use docker mysql");
                this.mySQLContainer = (MySQLContainer)new MySQLContainer("mysql:5.5").withDatabaseName(config.getDatabase()).withUsername(config.getUsername()).withPassword(config.getPassword()).withEnv("MYSQL_ROOT_HOST", "%").withExposedPorts(new Integer[]{3306});
                this.mySQLContainer.start();
                this.mySqlContainerRunnable = true;
                log.info("docker mysql available");
            }
            catch (Exception e) {
                log.error("failed to start docker mysql: error={}", (Object)e.getMessage());
                this.mySQLContainer = null;
            }
        }

        public boolean isRunning() {
            if (this.mySQLContainer != null) {
                return this.mySQLContainer.isRunning();
            }
            return false;
        }
    }

    public static class MySqlExtensionBuilder {
        private final String name;
        private String database;
        private String username;
        private String password;
        private String host = "localhost";
        private int port = 3306;

        public MySqlExtensionBuilder(String name) {
            this.name = name;
        }

        public MySqlExtension build() {
            MySqlExtension extension = new MySqlExtension();
            extension.database = this.database;
            extension.username = this.username;
            extension.password = this.password;
            extension.host = this.host;
            extension.port = this.port;
            extension.name = this.name;
            return extension;
        }

        public MySqlExtensionBuilder withDatabase(String database) {
            this.database = database;
            return this;
        }

        public MySqlExtensionBuilder withHost(String host) {
            this.host = host;
            this.port = 3306;
            return this;
        }

        public MySqlExtensionBuilder withHostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
            return this;
        }

        public MySqlExtensionBuilder withUsernamePassword(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }
    }
}

