/*
 * Decompiled with CFR 0.152.
 */
package com.devlibx.graph.domain;

import com.devlibx.graph.domain.Node;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Graph {
    Node start;
    List<Node> source;
    List<Node> transformation;
    List<Node> sink;
    Node end;

    public static GraphBuilder builder() {
        return new GraphBuilder();
    }

    public Node getStart() {
        return this.start;
    }

    public List<Node> getSource() {
        return this.source;
    }

    public List<Node> getTransformation() {
        return this.transformation;
    }

    public List<Node> getSink() {
        return this.sink;
    }

    public Node getEnd() {
        return this.end;
    }

    public void setStart(Node start) {
        this.start = start;
    }

    public void setSource(List<Node> source) {
        this.source = source;
    }

    public void setTransformation(List<Node> transformation) {
        this.transformation = transformation;
    }

    public void setSink(List<Node> sink) {
        this.sink = sink;
    }

    public void setEnd(Node end) {
        this.end = end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Graph)) {
            return false;
        }
        Graph other = (Graph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Node this$start = this.getStart();
        Node other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        List<Node> this$source = this.getSource();
        List<Node> other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        List<Node> this$transformation = this.getTransformation();
        List<Node> other$transformation = other.getTransformation();
        if (this$transformation == null ? other$transformation != null : !((Object)this$transformation).equals(other$transformation)) {
            return false;
        }
        List<Node> this$sink = this.getSink();
        List<Node> other$sink = other.getSink();
        if (this$sink == null ? other$sink != null : !((Object)this$sink).equals(other$sink)) {
            return false;
        }
        Node this$end = this.getEnd();
        Node other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Graph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Node $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        List<Node> $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        List<Node> $transformation = this.getTransformation();
        result = result * 59 + ($transformation == null ? 43 : ((Object)$transformation).hashCode());
        List<Node> $sink = this.getSink();
        result = result * 59 + ($sink == null ? 43 : ((Object)$sink).hashCode());
        Node $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    public String toString() {
        return "Graph(start=" + this.getStart() + ", source=" + this.getSource() + ", transformation=" + this.getTransformation() + ", sink=" + this.getSink() + ", end=" + this.getEnd() + ")";
    }

    public Graph() {
    }

    public Graph(Node start, List<Node> source, List<Node> transformation, List<Node> sink, Node end) {
        this.start = start;
        this.source = source;
        this.transformation = transformation;
        this.sink = sink;
        this.end = end;
    }

    public static class GraphBuilder {
        private Node start;
        private List<Node> source;
        private List<Node> transformation;
        private List<Node> sink;
        private Node end;

        GraphBuilder() {
        }

        public GraphBuilder start(Node start) {
            this.start = start;
            return this;
        }

        public GraphBuilder source(List<Node> source) {
            this.source = source;
            return this;
        }

        public GraphBuilder transformation(List<Node> transformation) {
            this.transformation = transformation;
            return this;
        }

        public GraphBuilder sink(List<Node> sink) {
            this.sink = sink;
            return this;
        }

        public GraphBuilder end(Node end) {
            this.end = end;
            return this;
        }

        public Graph build() {
            return new Graph(this.start, this.source, this.transformation, this.sink, this.end);
        }

        public String toString() {
            return "Graph.GraphBuilder(start=" + this.start + ", source=" + this.source + ", transformation=" + this.transformation + ", sink=" + this.sink + ", end=" + this.end + ")";
        }
    }
}

